/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.HSToNativeJDWPBridge;
import com.oracle.svm.jdwp.bridge.JDWPBridge;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.JDWPJNIConfig;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.ResidentJDWPFeatureEnabled;
import com.oracle.svm.jdwp.bridge.StackFrame;
import com.oracle.svm.jdwp.bridge.jniutils.JNI;
import com.oracle.svm.jdwp.bridge.jniutils.JNIMethodScope;
import com.oracle.svm.jdwp.bridge.jniutils.JNIUtil;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryInput;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryMarshaller;
import com.oracle.svm.jdwp.bridge.nativebridge.BinaryOutput;
import com.oracle.svm.jdwp.bridge.nativebridge.ForeignException;
import com.oracle.svm.jdwp.bridge.nativebridge.JNIConfig;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolate;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolateThread;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeObjectHandles;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

final class HSToNativeJDWPBridgeGen {
    HSToNativeJDWPBridgeGen() {
    }

    static HSToNativeJDWPBridge createHSToNative(NativeIsolate isolate, long objectHandle) {
        return new HSToNativeStartPoint(isolate, objectHandle);
    }

    private static final class HSToNativeStartPoint
    extends HSToNativeJDWPBridge {
        private static final BinaryMarshaller<Packet> packetMarshaller;
        private static final BinaryMarshaller<StackFrame> stackFrameMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        HSToNativeStartPoint(NativeIsolate isolate, long objectHandle) {
            super(isolate, objectHandle);
        }

        @Override
        public void clearStepping(long threadId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.clearStepping0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public String currentWorkingDirectory() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                String string = HSToNativeStartPoint.currentWorkingDirectory0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Packet dispatch(Packet packet) throws JDWPException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int marshalledParametersSizeEstimate = packetMarshaller.inferSize(packet);
                BinaryOutput.ByteArrayBinaryOutput marshalledParametersOutput = BinaryOutput.ByteArrayBinaryOutput.create(marshalledParametersSizeEstimate);
                packetMarshaller.write(marshalledParametersOutput, packet);
                byte[] endPointResult = HSToNativeStartPoint.dispatch0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), marshalledParametersOutput.getArray());
                BinaryInput marshalledResultInput = BinaryInput.create(endPointResult);
                Packet packet2 = packetMarshaller.read(marshalledResultInput);
                return packet2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int fieldRefIdToIndex(long fieldRefId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n = HSToNativeStartPoint.fieldRefIdToIndex0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), fieldRefId);
                return n;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long fieldRefIndexToId(int fieldRefIndex) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.fieldRefIndexToId0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), fieldRefIndex);
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long getCurrentThis() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.getCurrentThis0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public String getSystemProperty(String key) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                String string = HSToNativeStartPoint.getSystemProperty0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), key);
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public StackFrame[] getThreadFrames(long threadId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StackFrame[] hsResult;
                byte[] endPointResult = HSToNativeStartPoint.getThreadFrames0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId);
                BinaryInput marshalledResultInput = BinaryInput.create(endPointResult);
                int hsResultLength = marshalledResultInput.readInt();
                if (hsResultLength != -1) {
                    hsResult = new StackFrame[hsResultLength];
                    for (int hsResultIndex = 0; hsResultIndex < hsResultLength; ++hsResultIndex) {
                        StackFrame hsResultElement;
                        hsResult[hsResultIndex] = hsResultElement = stackFrameMarshaller.read(marshalledResultInput);
                    }
                } else {
                    hsResult = null;
                }
                StackFrame[] stackFrameArray = hsResult;
                return stackFrameArray;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int getThreadStatus(long threadId) throws JDWPException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n = HSToNativeStartPoint.getThreadStatus0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId);
                return n;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean isCurrentThreadVirtual() {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                boolean bl = HSToNativeStartPoint.isCurrentThreadVirtual0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean isEventEnabled(long threadId, int eventKind) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                boolean bl = HSToNativeStartPoint.isEventEnabled0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId, eventKind);
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int methodRefIdToIndex(long methodRefId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n = HSToNativeStartPoint.methodRefIdToIndex0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), methodRefId);
                return n;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long methodRefIndexToId(int methodRefIndex) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.methodRefIndexToId0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), methodRefIndex);
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void setEventEnabled(long threadId, int eventKind, boolean enable) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.setEventEnabled0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId, eventKind, enable);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void setStepping(long threadId, int depth, int size) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.setStepping0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId, depth, size);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void setSteppingFromLocation(long threadId, int depth, int size, long methodId, int bci, int lineNumber) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.setSteppingFromLocation0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId, depth, size, methodId, bci, lineNumber);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void setThreadRequest(boolean start, boolean enable) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.setThreadRequest0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), start, enable);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long threadResume(long suspendId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.threadResume0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), suspendId);
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long threadSuspend(long threadId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.threadSuspend0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), threadId);
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void toggleBreakpoint(long methodId, int bci, boolean enable) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.toggleBreakpoint0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), methodId, bci, enable);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void toggleMethodEnterEvent(long clazzId, boolean enable) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.toggleMethodEnterEvent0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), clazzId, enable);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void toggleMethodExitEvent(long clazzId, boolean enable) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.toggleMethodExitEvent0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), clazzId, enable);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int typeRefIdToIndex(long typeRefId) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n = HSToNativeStartPoint.typeRefIdToIndex0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), typeRefId);
                return n;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long typeRefIndexToId(int typeRefIndex) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long l = HSToNativeStartPoint.typeRefIndexToId0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), typeRefIndex);
                return l;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public int[] typeStatus(long ... typeIds) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int[] nArray = HSToNativeStartPoint.typeStatus0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), typeIds);
                return nArray;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void vmResume(long[] ignoredThreadIds) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                HSToNativeStartPoint.vmResume0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), ignoredThreadIds);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public long[] vmSuspend(long[] ignoredThreadIds) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                long[] lArray = HSToNativeStartPoint.vmSuspend0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), ignoredThreadIds);
                return lArray;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void clearStepping0(long var0, long var2, long var4);

        private static native String currentWorkingDirectory0(long var0, long var2);

        private static native byte[] dispatch0(long var0, long var2, byte[] var4) throws JDWPException;

        private static native int fieldRefIdToIndex0(long var0, long var2, long var4);

        private static native long fieldRefIndexToId0(long var0, long var2, int var4);

        private static native long getCurrentThis0(long var0, long var2);

        private static native String getSystemProperty0(long var0, long var2, String var4);

        private static native byte[] getThreadFrames0(long var0, long var2, long var4);

        private static native int getThreadStatus0(long var0, long var2, long var4) throws JDWPException;

        private static native boolean isCurrentThreadVirtual0(long var0, long var2);

        private static native boolean isEventEnabled0(long var0, long var2, long var4, int var6);

        private static native int methodRefIdToIndex0(long var0, long var2, long var4);

        private static native long methodRefIndexToId0(long var0, long var2, int var4);

        private static native void setEventEnabled0(long var0, long var2, long var4, int var6, boolean var7);

        private static native void setStepping0(long var0, long var2, long var4, int var6, int var7);

        private static native void setSteppingFromLocation0(long var0, long var2, long var4, int var6, int var7, long var8, int var10, int var11);

        private static native void setThreadRequest0(long var0, long var2, boolean var4, boolean var5);

        private static native long threadResume0(long var0, long var2, long var4);

        private static native long threadSuspend0(long var0, long var2, long var4);

        private static native void toggleBreakpoint0(long var0, long var2, long var4, int var6, boolean var7);

        private static native void toggleMethodEnterEvent0(long var0, long var2, long var4, boolean var6);

        private static native void toggleMethodExitEvent0(long var0, long var2, long var4, boolean var6);

        private static native int typeRefIdToIndex0(long var0, long var2, long var4);

        private static native long typeRefIndexToId0(long var0, long var2, int var4);

        private static native int[] typeStatus0(long var0, long var2, long[] var4);

        private static native void vmResume0(long var0, long var2, long[] var4);

        private static native long[] vmSuspend0(long var0, long var2, long[] var4);

        static {
            JNIConfig config = JDWPJNIConfig.getInstance();
            packetMarshaller = config.lookupMarshaller(Packet.class, new Class[0]);
            stackFrameMarshaller = config.lookupMarshaller(StackFrame.class, new Class[0]);
            throwableMarshaller = config.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class HSToNativeEndPoint {
        private static final BinaryMarshaller<Packet> packetMarshaller;
        private static final BinaryMarshaller<StackFrame> stackFrameMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private HSToNativeEndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_clearStepping0", include=ResidentJDWPFeatureEnabled.class)
        static void clearStepping(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::clearStepping", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.clearStepping(threadId);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_currentWorkingDirectory0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JString currentWorkingDirectory(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::currentWorkingDirectory", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                String endPointResult = receiverObject.currentWorkingDirectory();
                scope.setObjectResult(JNIUtil.createHSString(jniEnv, endPointResult));
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JString)scope.getObjectResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_dispatch0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JByteArray dispatch(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, JNI.JByteArray marshalledData) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::dispatch", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                CCharPointer staticMarshallBuffer = (CCharPointer)StackValue.get((int)256);
                int marshalledDataLength = JNIUtil.GetArrayLength(jniEnv, marshalledData);
                CCharPointer marshallBuffer = marshalledDataLength <= 256 ? staticMarshallBuffer : (CCharPointer)UnmanagedMemory.malloc((int)marshalledDataLength);
                try {
                    JNIUtil.GetByteArrayRegion(jniEnv, marshalledData, 0, marshalledDataLength, marshallBuffer);
                    BinaryInput marshalledParametersInput = BinaryInput.create(marshallBuffer, marshalledDataLength);
                    Packet packet = packetMarshaller.read(marshalledParametersInput);
                    Packet endPointResult = receiverObject.dispatch(packet);
                    int marshalledResultSizeEstimate = packetMarshaller.inferSize(endPointResult);
                    int marshallBufferLength = Math.max(256, marshalledDataLength);
                    try (BinaryOutput.CCharPointerBinaryOutput marshalledResultOutput = marshalledResultSizeEstimate > marshallBufferLength ? BinaryOutput.CCharPointerBinaryOutput.create(marshalledResultSizeEstimate) : BinaryOutput.create(marshallBuffer, marshallBufferLength, false);){
                        packetMarshaller.write(marshalledResultOutput, endPointResult);
                        int marshalledResultPosition = marshalledResultOutput.getPosition();
                        JNI.JByteArray marshalledResult = marshalledResultPosition <= marshalledDataLength ? marshalledData : JNIUtil.NewByteArray(jniEnv, marshalledResultPosition);
                        JNIUtil.SetByteArrayRegion(jniEnv, marshalledResult, 0, marshalledResultPosition, marshalledResultOutput.getAddress());
                        scope.setObjectResult(marshalledResult);
                    }
                }
                finally {
                    if (marshallBuffer != staticMarshallBuffer) {
                        UnmanagedMemory.free((PointerBase)marshallBuffer);
                    }
                }
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JByteArray)scope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_fieldRefIdToIndex0", include=ResidentJDWPFeatureEnabled.class)
        static int fieldRefIdToIndex(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long fieldRefId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::fieldRefIdToIndex", jniEnv);
            try {
                int endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                int n = endPointResult = receiverObject.fieldRefIdToIndex(fieldRefId);
                scope.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_fieldRefIndexToId0", include=ResidentJDWPFeatureEnabled.class)
        static long fieldRefIndexToId(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, int fieldRefIndex) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::fieldRefIndexToId", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.fieldRefIndexToId(fieldRefIndex);
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_getCurrentThis0", include=ResidentJDWPFeatureEnabled.class)
        static long getCurrentThis(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::getCurrentThis", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.getCurrentThis();
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_getSystemProperty0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JString getSystemProperty(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, JNI.JString key) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::getSystemProperty", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                String endPointResult = receiverObject.getSystemProperty(JNIUtil.createString(jniEnv, key));
                scope.setObjectResult(JNIUtil.createHSString(jniEnv, endPointResult));
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JString)scope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_getThreadFrames0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JByteArray getThreadFrames(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::getThreadFrames", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                CCharPointer staticMarshallBuffer = (CCharPointer)StackValue.get((int)256);
                StackFrame[] endPointResult = receiverObject.getThreadFrames(threadId);
                int marshalledResultSizeEstimate = 4 + (endPointResult != null && endPointResult.length > 0 ? endPointResult.length * stackFrameMarshaller.inferSize(endPointResult[0]) : 0);
                try (BinaryOutput.CCharPointerBinaryOutput marshalledResultOutput = marshalledResultSizeEstimate > 256 ? BinaryOutput.CCharPointerBinaryOutput.create(marshalledResultSizeEstimate) : BinaryOutput.create(staticMarshallBuffer, 256, false);){
                    if (endPointResult != null) {
                        marshalledResultOutput.writeInt(endPointResult.length);
                        for (StackFrame endPointResultElement : endPointResult) {
                            stackFrameMarshaller.write(marshalledResultOutput, endPointResultElement);
                        }
                    } else {
                        marshalledResultOutput.writeInt(-1);
                    }
                    int marshalledResultPosition = marshalledResultOutput.getPosition();
                    JNI.JByteArray marshalledResult = JNIUtil.NewByteArray(jniEnv, marshalledResultPosition);
                    JNIUtil.SetByteArrayRegion(jniEnv, marshalledResult, 0, marshalledResultPosition, marshalledResultOutput.getAddress());
                    scope.setObjectResult(marshalledResult);
                }
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JByteArray)scope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_getThreadStatus0", include=ResidentJDWPFeatureEnabled.class)
        static int getThreadStatus(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::getThreadStatus", jniEnv);
            try {
                int endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                int n = endPointResult = receiverObject.getThreadStatus(threadId);
                scope.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_isCurrentThreadVirtual0", include=ResidentJDWPFeatureEnabled.class)
        static boolean isCurrentThreadVirtual(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::isCurrentThreadVirtual", jniEnv);
            try {
                boolean endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                boolean bl = endPointResult = receiverObject.isCurrentThreadVirtual();
                scope.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return false;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_isEventEnabled0", include=ResidentJDWPFeatureEnabled.class)
        static boolean isEventEnabled(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId, int eventKind) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::isEventEnabled", jniEnv);
            try {
                boolean endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                boolean bl = endPointResult = receiverObject.isEventEnabled(threadId, eventKind);
                scope.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return false;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_methodRefIdToIndex0", include=ResidentJDWPFeatureEnabled.class)
        static int methodRefIdToIndex(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long methodRefId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::methodRefIdToIndex", jniEnv);
            try {
                int endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                int n = endPointResult = receiverObject.methodRefIdToIndex(methodRefId);
                scope.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_methodRefIndexToId0", include=ResidentJDWPFeatureEnabled.class)
        static long methodRefIndexToId(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, int methodRefIndex) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::methodRefIndexToId", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.methodRefIndexToId(methodRefIndex);
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_setEventEnabled0", include=ResidentJDWPFeatureEnabled.class)
        static void setEventEnabled(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId, int eventKind, boolean enable) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::setEventEnabled", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.setEventEnabled(threadId, eventKind, enable);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_setStepping0", include=ResidentJDWPFeatureEnabled.class)
        static void setStepping(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId, int depth, int size) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::setStepping", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.setStepping(threadId, depth, size);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_setSteppingFromLocation0", include=ResidentJDWPFeatureEnabled.class)
        static void setSteppingFromLocation(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId, int depth, int size, long methodId, int bci, int lineNumber) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::setSteppingFromLocation", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.setSteppingFromLocation(threadId, depth, size, methodId, bci, lineNumber);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_setThreadRequest0", include=ResidentJDWPFeatureEnabled.class)
        static void setThreadRequest(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, boolean start, boolean enable) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::setThreadRequest", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.setThreadRequest(start, enable);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_threadResume0", include=ResidentJDWPFeatureEnabled.class)
        static long threadResume(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long suspendId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::threadResume", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.threadResume(suspendId);
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_threadSuspend0", include=ResidentJDWPFeatureEnabled.class)
        static long threadSuspend(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long threadId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::threadSuspend", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.threadSuspend(threadId);
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_toggleBreakpoint0", include=ResidentJDWPFeatureEnabled.class)
        static void toggleBreakpoint(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long methodId, int bci, boolean enable) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::toggleBreakpoint", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.toggleBreakpoint(methodId, bci, enable);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_toggleMethodEnterEvent0", include=ResidentJDWPFeatureEnabled.class)
        static void toggleMethodEnterEvent(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long clazzId, boolean enable) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::toggleMethodEnterEvent", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.toggleMethodEnterEvent(clazzId, enable);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_toggleMethodExitEvent0", include=ResidentJDWPFeatureEnabled.class)
        static void toggleMethodExitEvent(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long clazzId, boolean enable) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::toggleMethodExitEvent", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.toggleMethodExitEvent(clazzId, enable);
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_typeRefIdToIndex0", include=ResidentJDWPFeatureEnabled.class)
        static int typeRefIdToIndex(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, long typeRefId) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::typeRefIdToIndex", jniEnv);
            try {
                int endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                int n = endPointResult = receiverObject.typeRefIdToIndex(typeRefId);
                scope.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_typeRefIndexToId0", include=ResidentJDWPFeatureEnabled.class)
        static long typeRefIndexToId(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, int typeRefIndex) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::typeRefIndexToId", jniEnv);
            try {
                long endPointResult;
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long l = endPointResult = receiverObject.typeRefIndexToId(typeRefIndex);
                scope.close();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_typeStatus0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JIntArray typeStatus(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, JNI.JLongArray typeIds) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::typeStatus", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                int[] endPointResult = receiverObject.typeStatus(JNIUtil.createArray(jniEnv, typeIds));
                scope.setObjectResult(JNIUtil.createHSArray(jniEnv, endPointResult));
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JIntArray)scope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_vmResume0", include=ResidentJDWPFeatureEnabled.class)
        static void vmResume(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, JNI.JLongArray ignoredThreadIds) {
            try (JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::vmResume", jniEnv);){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                receiverObject.vmResume(JNIUtil.createArray(jniEnv, ignoredThreadIds));
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_svm_jdwp_bridge_HSToNativeJDWPBridgeGen_00024HSToNativeStartPoint_vmSuspend0", include=ResidentJDWPFeatureEnabled.class)
        static JNI.JLongArray vmSuspend(JNI.JNIEnv jniEnv, JNI.JClass jniClazz, @CEntryPoint.IsolateThreadContext long isolateThread, long objectId, JNI.JLongArray ignoredThreadIds) {
            JNIMethodScope scope = new JNIMethodScope("HSToNativeJDWPBridgeGen::vmSuspend", jniEnv);
            try (JNIMethodScope sc = scope;){
                JDWPBridge receiverObject = NativeObjectHandles.resolve(objectId, JDWPBridge.class);
                long[] endPointResult = receiverObject.vmSuspend(JNIUtil.createArray(jniEnv, ignoredThreadIds));
                scope.setObjectResult(JNIUtil.createHSArray(jniEnv, endPointResult));
            }
            catch (Throwable e) {
                ForeignException.forThrowable(e, throwableMarshaller).throwUsingJNI(jniEnv);
                scope.setObjectResult((JNI.JObject)Word.nullPointer());
            }
            return (JNI.JLongArray)scope.getObjectResult();
        }

        static {
            JNIConfig config = JDWPJNIConfig.getInstance();
            packetMarshaller = config.lookupMarshaller(Packet.class, new Class[0]);
            stackFrameMarshaller = config.lookupMarshaller(StackFrame.class, new Class[0]);
            throwableMarshaller = config.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

