/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedPrimitiveType;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

public abstract class InterpreterResolvedJavaType
implements ResolvedJavaType {
    public static final ResolvedJavaMethod[] NO_METHODS = new ResolvedJavaMethod[0];
    private final String name;
    private final Class<?> clazz;
    private final JavaConstant clazzConstant;
    private final boolean isWordType;
    private volatile boolean methodEnterEventEnabled;
    private volatile boolean methodExitEventEnabled;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected InterpreterResolvedJavaType(String name, Class<?> javaClass) {
        this.name = MetadataUtil.requireNonNull(name);
        this.clazzConstant = null;
        this.clazz = MetadataUtil.requireNonNull(javaClass);
        this.isWordType = WordBase.class.isAssignableFrom(javaClass);
    }

    protected InterpreterResolvedJavaType(String name, Class<?> javaClass, boolean isWordType) {
        this.name = MetadataUtil.requireNonNull(name);
        this.clazzConstant = null;
        this.clazz = MetadataUtil.requireNonNull(javaClass);
        this.isWordType = isWordType;
    }

    protected InterpreterResolvedJavaType(String name, JavaConstant clazzConstant, boolean isWordType) {
        this.name = MetadataUtil.requireNonNull(name);
        this.clazzConstant = MetadataUtil.requireNonNull(clazzConstant);
        this.clazz = null;
        this.isWordType = isWordType;
    }

    public final String getName() {
        return this.name;
    }

    public final Class<?> getJavaClass() {
        return MetadataUtil.requireNonNull(this.clazz);
    }

    public final boolean isWordType() {
        return this.isWordType;
    }

    public final boolean isPrimitive() {
        return this instanceof InterpreterResolvedPrimitiveType;
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof InterpreterResolvedJavaType) {
            InterpreterResolvedJavaType that = (InterpreterResolvedJavaType)obj;
            if (this.clazz != null) {
                return this.clazz == that.clazz;
            }
            assert (this.clazzConstant != null && that.clazzConstant != null);
            return this.clazzConstant.equals((Object)that.clazzConstant);
        }
        return false;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final String toString() {
        return "InterpreterResolvedJavaType<" + this.getName() + ">";
    }

    public void toggleMethodEnterEvent(boolean enable) {
        this.methodEnterEventEnabled = enable;
    }

    public void toggleMethodExitEvent(boolean enable) {
        this.methodExitEventEnabled = enable;
    }

    public boolean isMethodEnterEvent() {
        return this.methodEnterEventEnabled;
    }

    public boolean isMethodExitEvent() {
        return this.methodExitEventEnabled;
    }

    public final boolean hasFinalizer() {
        throw VMError.intentionallyUnimplemented();
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isInstanceClass() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isEnum() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isInitialized() {
        throw VMError.intentionallyUnimplemented();
    }

    public final void initialize() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isLinked() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isInstance(JavaConstant obj) {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaType getSingleImplementor() {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        throw VMError.intentionallyUnimplemented();
    }

    public final Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw VMError.intentionallyUnimplemented();
    }

    public final Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaField[] getStaticFields() {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        throw VMError.intentionallyUnimplemented();
    }

    public final InterpreterResolvedObjectType getArrayClass() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isLocal() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isMember() {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaType getEnclosingType() {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaMethod[] getDeclaredConstructors() {
        throw VMError.intentionallyUnimplemented();
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return NO_METHODS;
    }

    public List<ResolvedJavaMethod> getAllMethods(boolean forceLink) {
        throw VMError.intentionallyUnimplemented();
    }

    public final ResolvedJavaMethod getClassInitializer() {
        throw VMError.intentionallyUnimplemented();
    }

    public final boolean isCloneableWithAllocation() {
        throw VMError.intentionallyUnimplemented();
    }

    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw VMError.intentionallyUnimplemented();
    }

    public final Annotation[] getAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }

    public final Annotation[] getDeclaredAnnotations() {
        throw VMError.intentionallyUnimplemented();
    }
}

