/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.InterpreterDirectivesSupportImpl;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.interpreter.metadata.InterpreterUniverseImpl;
import com.oracle.svm.interpreter.metadata.Lazy;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.Serializers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.word.Pointer;

public class DebuggerSupport {
    public static final String IMAGE_INTERP_HASH_SYMBOL_NAME = "__svm_interp_hash";
    public static final CGlobalData<Pointer> IMAGE_INTERP_HASH = CGlobalDataFactory.forSymbol("__svm_interp_hash");
    private static final SerializationContext.Builder READER_BUILDER = Serializers.newBuilderForInterpreterMetadata();
    private ArrayList<Object> referencesInImage = new ArrayList();
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private final ArrayList<FunctionPointerHolder> methodPointersInImage = new ArrayList();
    private final Lazy<InterpreterUniverse> universe = Lazy.of(() -> {
        DebuggerSupport.logForcedReferencesHistogram(this.referencesInImage, this.methodPointersInImage);
        try {
            return InterpreterUniverseImpl.loadFrom(this.getUniverseSerializerBuilder(), false, DebuggerSupport.getMetadataHashString(), DebuggerSupport.getMetadataFilePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue() && InterpreterOptions.InterpreterTrace.getValue().booleanValue()) {
                e.printStackTrace();
            }
            throw VMError.shouldNotReachHere(e);
        }
    });

    @Fold
    public static boolean isEnabled() {
        return ImageSingletons.contains(DebuggerSupport.class);
    }

    @Fold
    public static DebuggerSupport singleton() {
        return (DebuggerSupport)ImageSingletons.lookup(DebuggerSupport.class);
    }

    public static Path getMetadataFilePath() {
        return MetadataUtil.metadataFilePath(Path.of(ProcessProperties.getExecutableName(), new String[0]));
    }

    public static String getMetadataHashString() {
        Pointer base = IMAGE_INTERP_HASH.get();
        int length = base.readInt(0);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = base.readByte(4 + i);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void logForcedReferencesHistogram(ArrayList<Object> references, ArrayList<FunctionPointerHolder> methodPointers) {
        InterpreterUtil.traceInterpreter("Forced constants: ").signed(references.size()).newline();
        InterpreterUtil.traceInterpreter("Forced method pointers: ").signed(methodPointers.size()).newline();
        InterpreterUtil.traceInterpreter("Forced constants histogram:");
        EconomicMap histogram = EconomicMap.create();
        for (Object object : references) {
            histogram.put(object.getClass(), (Object)((Integer)histogram.get(object.getClass(), (Object)0) + 1));
        }
        MapCursor cursor = histogram.getEntries();
        while (cursor.advance()) {
            InterpreterUtil.traceInterpreter("  ").string(((Class)cursor.getKey()).toString()).string(" ").string(((Integer)cursor.getValue()).toString()).newline();
        }
    }

    public static ResolvedJavaType lookupType(Class<?> declaringClass) {
        return InterpreterDirectivesSupportImpl.getInterpreterType(declaringClass);
    }

    public static ResolvedJavaMethod lookupMethod(ResolvedJavaType clazz, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        VMError.guarantee(clazz instanceof InterpreterResolvedJavaType);
        return InterpreterDirectivesSupportImpl.getInterpreterMethod((InterpreterResolvedJavaType)clazz, methodName, returnType, parameterTypes);
    }

    public SerializationContext.Builder getUniverseSerializerBuilder() {
        return READER_BUILDER;
    }

    public InterpreterUniverse getUniverse() {
        return this.universe.get();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void trimForcedReferencesInImageHeap() {
        Set unique = Collections.newSetFromMap(new IdentityHashMap());
        unique.addAll(this.referencesInImage);
        this.referencesInImage = new ArrayList(unique);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void ensureConstantIsInImageHeap(SnippetReflectionProvider snippetReflectionProvider, ImageHeapConstant imageHeapConstant) {
        if (!imageHeapConstant.isBackedByHostedObject()) {
            throw VMError.shouldNotReachHere("Constant is not backed: " + String.valueOf(imageHeapConstant));
        }
        Object value = snippetReflectionProvider.asObject(Object.class, imageHeapConstant.getHostedObject());
        VMError.guarantee(value != null);
        this.referencesInImage.add(value);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void ensureMethodPointerIsInImage(FunctionPointerHolder value) {
        if (value != null) {
            this.methodPointersInImage.add(value);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void buildMethodIdMapping(ResolvedJavaMethod[] encodedMethods) {
        assert (encodedMethods[0] == null);
        for (int i = 1; i < encodedMethods.length; ++i) {
            ResolvedJavaMethod method = encodedMethods[i];
            if (method == null) continue;
            InterpreterResolvedJavaMethod interpreterMethod = BuildTimeInterpreterUniverse.singleton().getMethod(method);
            interpreterMethod.setMethodId(i);
        }
    }
}

