/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import org.graalvm.nativeimage.ImageSingletons;

final class ComputeVTableIndex
implements FieldValueTransformerWithAvailability {
    ComputeVTableIndex() {
    }

    @Override
    public boolean isAvailable() {
        return BuildPhaseProvider.isHostedUniverseBuilt();
    }

    public Object transform(Object receiver, Object originalValue) {
        SubstrateMethodAccessor accessor = (SubstrateMethodAccessor)receiver;
        if (accessor.getVTableIndex() == -2) {
            HostedMethod member = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).hostedMetaAccess().lookupJavaMethod(accessor.getMember());
            if (member.canBeStaticallyBound()) {
                return -1;
            }
            return member.getVTableIndex();
        }
        VMError.guarantee(accessor.getVTableIndex() == -1);
        return accessor.getVTableIndex();
    }
}

