/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot.amd64;

import com.oracle.svm.core.pltgot.amd64.AMD64ExitMethodAddressResolutionOp;
import com.oracle.svm.core.pltgot.amd64.AMD64MethodAddressResolutionDispatcher;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.PLTStubGenerator;
import com.oracle.svm.hosted.pltgot.amd64.AMD64PLTStubGenerator;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.Value;

public final class AMD64HostedPLTGOTConfiguration
extends HostedPLTGOTConfiguration {
    @Override
    public Method getArchSpecificResolverAsMethod() {
        return ReflectionUtil.lookupMethod(AMD64MethodAddressResolutionDispatcher.class, (String)"resolveMethodAddress", (Class[])new Class[]{Long.TYPE});
    }

    @Override
    public PLTStubGenerator getArchSpecificPLTStubGenerator() {
        return new AMD64PLTStubGenerator();
    }

    @Override
    public Register getExitMethodAddressResolutionRegister(RegisterConfig registerConfig) {
        return this.getGOTPassingRegister(registerConfig);
    }

    @Override
    public LIRInstruction createExitMethodAddressResolutionOp(RegisterValue exitThroughRegisterValue) {
        return new AMD64ExitMethodAddressResolutionOp((Value)exitThroughRegisterValue);
    }

    @Override
    public Register getGOTPassingRegister(RegisterConfig registerConfig) {
        return registerConfig.getReturnRegister(this.getArchSpecificResolverAsHostedMethod().getSignature().getReturnKind());
    }
}

