/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class RuntimeOptionFeature
implements InternalFeature {
    private RuntimeOptionParser runtimeOptionParser;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.runtimeOptionParser = new RuntimeOptionParser();
        ImageSingletons.add(RuntimeOptionParser.class, (Object)this.runtimeOptionParser);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.registerObjectReachableCallback(OptionKey.class, this::collectOptionKeys);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        UnmodifiableEconomicMap map = HostedOptionValues.singleton().getMap();
        for (OptionKey key : map.getKeys()) {
            RuntimeOptionKey runtimeOptionKey;
            if (!(key instanceof RuntimeOptionKey) || !(runtimeOptionKey = (RuntimeOptionKey)key).shouldRegisterForIsolateArgumentParser()) continue;
            IsolateArgumentParser.singleton().register(runtimeOptionKey);
            RuntimeOptionFeature.registerOptionAsRead(accessImpl, runtimeOptionKey.getDescriptor().getDeclaringClass(), runtimeOptionKey.getName());
        }
        IsolateArgumentParser.singleton().sealOptions();
    }

    private void collectOptionKeys(Feature.DuringAnalysisAccess access, OptionKey<?> optionKey, ObjectScanner.ScanReason reason) {
        if (optionKey instanceof HostedOptionKey) {
            return;
        }
        OptionDescriptor optionDescriptor = optionKey.getDescriptor();
        if (optionDescriptor == null) {
            throw VMError.shouldNotReachHere("No OptionDescriptor registered for an OptionKey. Often that is the result of an incomplete build. The registration code is generated by an annotation processor at build time, so a clean and full rebuild often helps to solve this problem");
        }
        if (optionDescriptor.getContainer().optionsAreDiscoverable()) {
            this.runtimeOptionParser.addDescriptor(optionDescriptor);
        }
    }

    public static void registerOptionAsRead(FeatureImpl.BeforeAnalysisAccessImpl accessImpl, Class<?> clazz, String fieldName) {
        try {
            Field javaField = clazz.getField(fieldName);
            AnalysisField analysisField = accessImpl.getMetaAccess().lookupJavaField(javaField);
            accessImpl.registerAsRead(analysisField, (Object)"it is a runtime option field");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

