/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerSubstitutionType;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

@BasedOnJDKClass.List(value={@BasedOnJDKClass(value=MethodHandle.class), @BasedOnJDKClass(value=MethodType.class), @BasedOnJDKClass(className="java.lang.invoke.MethodHandleStatics"), @BasedOnJDKClass(className="java.lang.invoke.ClassSpecializer"), @BasedOnJDKClass(className="java.lang.invoke.ClassSpecializer", innerClass={"SpeciesData"}), @BasedOnJDKClass(className="java.lang.invoke.MemberName"), @BasedOnJDKClass(className="java.lang.invoke.MethodHandleNatives"), @BasedOnJDKClass(className="java.lang.invoke.LambdaForm"), @BasedOnJDKClass(className="java.lang.invoke.LambdaForm", innerClass={"BasicType"}), @BasedOnJDKClass(className="java.lang.invoke.LambdaForm", innerClass={"Name"}), @BasedOnJDKClass(className="java.lang.invoke.LambdaForm", innerClass={"NamedFunction"}), @BasedOnJDKClass(className="java.lang.invoke.BoundMethodHandle"), @BasedOnJDKClass(className="java.lang.invoke.DirectMethodHandle"), @BasedOnJDKClass(className="java.lang.invoke.MethodHandleImpl", innerClass={"IntrinsicMethodHandle"})})
public class MethodHandleInvokerRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private static final Class<?> METHOD_HANDLE_STATICS_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.MethodHandleStatics");
    private static final Field DEBUG_METHOD_HANDLE_NAMES_FIELD = ReflectionUtil.lookupField(METHOD_HANDLE_STATICS_CLASS, (String)"DEBUG_METHOD_HANDLE_NAMES");
    private static final Class<?> CLASS_SPECIALIZER_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.ClassSpecializer");
    private static final Field CLASS_SPECIALIZER_META_TYPE_FIELD = ReflectionUtil.lookupField(CLASS_SPECIALIZER_CLASS, (String)"metaType");
    private static final Class<?> SPECIES_DATA_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.ClassSpecializer$SpeciesData");
    private static final Method SPECIES_DATA_OUTER_METHOD = ReflectionUtil.lookupMethod(SPECIES_DATA_CLASS, (String)"outer", (Class[])new Class[0]);
    private static final Field SPECIES_DATA_SPECIES_CODE_FIELD = ReflectionUtil.lookupField(SPECIES_DATA_CLASS, (String)"speciesCode");
    private static final Method CLASS_GET_CLASS_DATA_METHOD = ReflectionUtil.lookupMethod(Class.class, (String)"getClassData", (Class[])new Class[0]);
    private static final Class<?> MEMBER_NAME_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.MemberName");
    private static final Method MEMBER_NAME_GET_DECLARING_CLASS_METHOD = ReflectionUtil.lookupMethod(MEMBER_NAME_CLASS, (String)"getDeclaringClass", (Class[])new Class[0]);
    private static final Method MEMBER_NAME_GET_NAME_METHOD = ReflectionUtil.lookupMethod(MEMBER_NAME_CLASS, (String)"getName", (Class[])new Class[0]);
    private static final Method MEMBER_NAME_GET_METHOD_OR_FIELD_TYPE_METHOD = ReflectionUtil.lookupMethod(MEMBER_NAME_CLASS, (String)"getMethodOrFieldType", (Class[])new Class[0]);
    private static final Method MEMBER_NAME_GET_REFERENCE_KIND_METHOD = ReflectionUtil.lookupMethod(MEMBER_NAME_CLASS, (String)"getReferenceKind", (Class[])new Class[0]);
    private static final Class<?> METHOD_HANDLE_NATIVES_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.MethodHandleNatives");
    private static final Method METHOD_HANDLE_NATIVES_REF_KIND_NAME_METHOD = ReflectionUtil.lookupMethod(METHOD_HANDLE_NATIVES_CLASS, (String)"refKindName", (Class[])new Class[]{Byte.TYPE});
    private static final Class<?> LAMBDA_FORM_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm");
    private static final Field LAMBDA_FORM_CUSTOMIZED_FIELD = ReflectionUtil.lookupField(LAMBDA_FORM_CLASS, (String)"customized");
    private static final Field LAMBDA_FORM_NAMES_FIELD = ReflectionUtil.lookupField(LAMBDA_FORM_CLASS, (String)"names");
    private static final Class<?> BASIC_TYPE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm$BasicType");
    private static final Class<?> NAME_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm$Name");
    private static final Field NAME_INDEX_FIELD = ReflectionUtil.lookupField(NAME_CLASS, (String)"index");
    private static final Field NAME_CONSTRAINT_FIELD = ReflectionUtil.lookupField(NAME_CLASS, (String)"constraint");
    private static final Field NAME_ARGUMENTS_FIELD = ReflectionUtil.lookupField(NAME_CLASS, (String)"arguments");
    private static final Field NAME_FUNCTION_FIELD = ReflectionUtil.lookupField(NAME_CLASS, (String)"function");
    private static final Class<?> NAMED_FUNCTION_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm$NamedFunction");
    private static final Field NAMED_FUNCTION_MEMBER_FIELD = ReflectionUtil.lookupField(NAMED_FUNCTION_CLASS, (String)"member");
    private static final Method NAMED_FUNCTION_RESOLVED_HANDLE_METHOD = ReflectionUtil.lookupMethod(NAMED_FUNCTION_CLASS, (String)"resolvedHandle", (Class[])new Class[0]);
    private static final Field FORM_FIELD = ReflectionUtil.lookupField(MethodHandle.class, (String)"form");
    private static final Class<?> BOUND_METHOD_HANDLE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.BoundMethodHandle");
    private static final Method BOUND_METHOD_HANDLE_SPECIES_DATA_METHOD = ReflectionUtil.lookupMethod(BOUND_METHOD_HANDLE_CLASS, (String)"speciesData", (Class[])new Class[0]);
    private static final Class<?> DIRECT_METHOD_HANDLE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle");
    private static final Method DIRECT_METHOD_HANDLE_INTERNAL_MEMBER_NAME_METHOD = ReflectionUtil.lookupMethod(DIRECT_METHOD_HANDLE_CLASS, (String)"internalMemberName", (Class[])new Class[0]);
    private static final String DMH_CLASS_NAME_SUBSTRING = "LambdaForm$DMH";
    private static final String DMH_STABLE_NAME_TEMPLATE = "Ljava/lang/invoke/LambdaForm$DMH.s";
    private static final String MH_CLASS_NAME_SUBSTRING = "LambdaForm$MH";
    private static final String MH_STABLE_NAME_TEMPLATE = "Ljava/lang/invoke/LambdaForm$MH.s";
    private static final String VH_CLASS_NAME_SUBSTRING = "LambdaForm$VH";
    private static final String VH_STABLE_NAME_TEMPLATE = "Ljava/lang/invoke/LambdaForm$VH.s";
    private final BigBang bb;
    private final ConcurrentMap<ResolvedJavaType, MethodHandleInvokerSubstitutionType> typeSubstitutions = new ConcurrentHashMap<ResolvedJavaType, MethodHandleInvokerSubstitutionType>();
    private final Set<String> uniqueTypeNames = new HashSet<String>();

    MethodHandleInvokerRenamingSubstitutionProcessor(BigBang bb) {
        this.bb = bb;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (!MethodHandleInvokerRenamingSubstitutionProcessor.shouldReplace(type)) {
            return type;
        }
        return this.typeSubstitutions.computeIfAbsent(type, original -> this.getSubstitution(type, (ResolvedJavaType)original));
    }

    public static boolean isMethodHandleType(ResolvedJavaType type) {
        String name = type.getName();
        return name.contains(DMH_CLASS_NAME_SUBSTRING) || name.contains(MH_CLASS_NAME_SUBSTRING) || name.contains(VH_CLASS_NAME_SUBSTRING);
    }

    private static boolean shouldReplace(ResolvedJavaType type) {
        return !(type instanceof MethodHandleInvokerSubstitutionType) && !(type instanceof BaseLayerType) && MethodHandleInvokerRenamingSubstitutionProcessor.isMethodHandleType(type);
    }

    private MethodHandleInvokerSubstitutionType getSubstitution(ResolvedJavaType type, ResolvedJavaType original) {
        int hash;
        boolean isDirect = type.getName().contains(DMH_CLASS_NAME_SUBSTRING);
        try {
            Object lambdaForm;
            Object customizedMemberName = null;
            boolean customizedArbitraryMethodHandle = false;
            Class clazz = OriginalClassProvider.getJavaClass((JavaType)original);
            Object classData = CLASS_GET_CLASS_DATA_METHOD.invoke((Object)clazz, new Object[0]);
            if (LAMBDA_FORM_CLASS.isInstance(classData)) {
                lambdaForm = classData;
            } else if (classData instanceof List) {
                List list = (List)classData;
                VMError.guarantee(list.size() > 1, "The classData cannot be a list with fewer than 2 elements.");
                lambdaForm = list.get(0);
                VMError.guarantee(LAMBDA_FORM_CLASS.isInstance(lambdaForm), "Expected classData to contain LambdaForm at the start of the list: %s", classData);
                if (isDirect) {
                    VMError.guarantee(list.size() == 2);
                    Object customizedHandle = list.get(1);
                    VMError.guarantee(DIRECT_METHOD_HANDLE_CLASS.isInstance(customizedHandle) && LAMBDA_FORM_CUSTOMIZED_FIELD.get(lambdaForm) == customizedHandle, "Expected classData to contain LambdaForm and its customization: %s", classData);
                    customizedMemberName = DIRECT_METHOD_HANDLE_INTERNAL_MEMBER_NAME_METHOD.invoke(customizedHandle, new Object[0]);
                } else {
                    Object customizedHandle = LAMBDA_FORM_CUSTOMIZED_FIELD.get(lambdaForm);
                    if (customizedHandle != null) {
                        VMError.guarantee(customizedHandle == list.get(1), "Expected the customization to be right after the LambdaForm: %s", list.get(1));
                    }
                    customizedArbitraryMethodHandle = true;
                }
            } else {
                throw VMError.shouldNotReachHere("Unexpected classData: %s", classData);
            }
            hash = this.computeLambdaFormHash(lambdaForm, isDirect);
            if (customizedMemberName != null) {
                hash = hash * 31 + MethodHandleInvokerRenamingSubstitutionProcessor.memberNameToString(customizedMemberName).hashCode();
            }
            if (customizedArbitraryMethodHandle) {
                hash = hash * 31 + "customized".hashCode();
            }
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        boolean isVarHandle = type.getName().contains(VH_CLASS_NAME_SUBSTRING);
        return new MethodHandleInvokerSubstitutionType(original, this.findUniqueName(hash, isDirect, isVarHandle));
    }

    private int computeLambdaFormHash(Object lambdaForm, boolean isDirect) {
        int hash;
        if (isDirect) {
            hash = lambdaForm.toString().hashCode();
        } else {
            try {
                hash = this.getUniqueStableHash(lambdaForm);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        return hash;
    }

    private int getUniqueStableHash(Object lambdaForm) throws ReflectiveOperationException {
        String lambdaFormString = lambdaForm.toString();
        int hash = 0;
        Object names = LAMBDA_FORM_NAMES_FIELD.get(lambdaForm);
        int namesLength = Array.getLength(names);
        for (int i = 0; i < namesLength; ++i) {
            Object function;
            Object arguments;
            Object name = Array.get(names, i);
            assert (NAME_INDEX_FIELD.getShort(name) >= 0) : "The name " + String.valueOf(name) + " from the lambda form " + String.valueOf(lambdaForm) + " has no index set, which produces unstable names.";
            Object constraint = NAME_CONSTRAINT_FIELD.get(name);
            if (constraint != null) {
                if (constraint instanceof Class) {
                    Class classConstraint = (Class)constraint;
                    hash = hash * 31 + classConstraint.getName().hashCode();
                } else if (SPECIES_DATA_CLASS.isInstance(constraint)) {
                    hash = hash * 31 + MethodHandleInvokerRenamingSubstitutionProcessor.getSpeciesDataHash(constraint);
                } else {
                    throw new AssertionError((Object)("The name " + String.valueOf(name) + " has a constraint that could cause an unstable name: " + String.valueOf(constraint)));
                }
            }
            if ((arguments = NAME_ARGUMENTS_FIELD.get(name)) != null) {
                int argumentsLength = Array.getLength(arguments);
                for (int j = 0; j < argumentsLength; ++j) {
                    Object argument = Array.get(arguments, j);
                    if (!(argument == null || argument instanceof Integer || NAME_CLASS.isInstance(argument) || ((Class)BASIC_TYPE_CLASS.arrayType()).isInstance(argument))) {
                        throw new AssertionError((Object)("Lambda form argument " + String.valueOf(argument) + " is of type " + String.valueOf(argument.getClass()) + " which might produce unstable name."));
                    }
                    if (!((Class)BASIC_TYPE_CLASS.arrayType()).isInstance(argument)) continue;
                    lambdaFormString = lambdaFormString.replace(String.valueOf(argument), Arrays.toString((Object[])argument));
                }
            }
            if ((function = NAME_FUNCTION_FIELD.get(name)) == null) continue;
            Object member = NAMED_FUNCTION_MEMBER_FIELD.get(function);
            if (member != null) {
                hash = hash * 31 + MethodHandleInvokerRenamingSubstitutionProcessor.memberNameToString(member).hashCode();
            }
            Object resolvedHandle = NAMED_FUNCTION_RESOLVED_HANDLE_METHOD.invoke(function, new Object[0]);
            MethodType methodType = ((MethodHandle)resolvedHandle).type();
            hash = hash * 31 + methodType.descriptorString().hashCode();
            if (BOUND_METHOD_HANDLE_CLASS.isInstance(resolvedHandle)) {
                assert (!DEBUG_METHOD_HANDLE_NAMES_FIELD.getBoolean(null)) : "The method handle " + String.valueOf(resolvedHandle) + " with debug method handle names can contain the string representation from any object, which would cause the name to be unstable.";
                Object speciesData = BOUND_METHOD_HANDLE_SPECIES_DATA_METHOD.invoke(resolvedHandle, new Object[0]);
                hash = hash * 31 + MethodHandleInvokerRenamingSubstitutionProcessor.getSpeciesDataHash(speciesData);
            }
            Object innerLambdaForm = FORM_FIELD.get(resolvedHandle);
            hash = hash * 31 + this.computeLambdaFormHash(innerLambdaForm, DIRECT_METHOD_HANDLE_CLASS.isInstance(resolvedHandle));
        }
        return hash * 31 + lambdaFormString.hashCode();
    }

    private static String memberNameToString(Object memberName) throws ReflectiveOperationException {
        Class declaringClass = (Class)MEMBER_NAME_GET_DECLARING_CLASS_METHOD.invoke(memberName, new Object[0]);
        String name = (String)MEMBER_NAME_GET_NAME_METHOD.invoke(memberName, new Object[0]);
        MethodType methodType = (MethodType)MEMBER_NAME_GET_METHOD_OR_FIELD_TYPE_METHOD.invoke(memberName, new Object[0]);
        byte refKind = (Byte)MEMBER_NAME_GET_REFERENCE_KIND_METHOD.invoke(memberName, new Object[0]);
        String refKindName = (String)METHOD_HANDLE_NATIVES_REF_KIND_NAME_METHOD.invoke(null, refKind);
        return declaringClass.getName() + name + methodType.descriptorString() + refKindName;
    }

    private static int getSpeciesDataHash(Object speciesData) throws ReflectiveOperationException {
        Object classSpecializer = SPECIES_DATA_OUTER_METHOD.invoke(speciesData, new Object[0]);
        Class metaType = (Class)CLASS_SPECIALIZER_META_TYPE_FIELD.get(classSpecializer);
        Class speciesCode = (Class)SPECIES_DATA_SPECIES_CODE_FIELD.get(speciesData);
        return metaType.getName().hashCode() * 31 + speciesCode.getName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueName(int hashCode, boolean isDirect, boolean isVarHandle) {
        Object baseName = Integer.toHexString(hashCode);
        baseName = isDirect ? DMH_STABLE_NAME_TEMPLATE + (String)baseName : (isVarHandle ? VH_STABLE_NAME_TEMPLATE + (String)baseName : MH_STABLE_NAME_TEMPLATE + (String)baseName);
        String name = (String)baseName + ";";
        Set<String> set = this.uniqueTypeNames;
        synchronized (set) {
            int suffix = 1;
            while (this.uniqueTypeNames.contains(name)) {
                name = (String)baseName + "_" + suffix + ";";
                ++suffix;
            }
            this.uniqueTypeNames.add(name);
            return name;
        }
    }

    public boolean isNameAlwaysStable(String methodHandleName) {
        int lastIndex = methodHandleName.lastIndexOf(95);
        if (lastIndex < 0) {
            return true;
        }
        return !this.uniqueTypeNames.contains(methodHandleName.substring(0, lastIndex) + "_1;");
    }

    boolean checkAllTypeNames() {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        List types = this.bb.getUniverse().getTypes();
        if (types.stream().anyMatch(aType -> MethodHandleInvokerRenamingSubstitutionProcessor.shouldReplace(aType.getWrapped()))) {
            throw new AssertionError((Object)"All relevant types must have been substituted.");
        }
        HashSet names = new HashSet();
        types.stream().filter(MethodHandleInvokerRenamingSubstitutionProcessor::isMethodHandleType).map(AnalysisType::getName).forEach(name -> {
            if (names.contains(name)) {
                throw new AssertionError((Object)("Duplicate name: " + name));
            }
            names.add(name);
        });
        return true;
    }
}

