/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk.localization;

import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class LocalizationFeature_Options_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(LocalizationFeature.Options.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "AddAllCharsets": {
                return OptionDescriptor.create((String)"AddAllCharsets", (OptionType)OptionType.Debug, Boolean.class, (String)"Make all hosted charsets available at run time", (Object)this.getContainer(), LocalizationFeature.Options.AddAllCharsets, (String)"AddAllCharsets", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "DefaultCharset": {
                return OptionDescriptor.create((String)"DefaultCharset", (OptionType)OptionType.User, String.class, (String)"Default charset of the image, by the default it is the same as the default charset of the image builder.", (Object)this.getContainer(), LocalizationFeature.Options.DefaultCharset, (String)"DefaultCharset", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DefaultLocale": {
                return OptionDescriptor.create((String)"DefaultLocale", (OptionType)OptionType.User, String.class, (String)"Default locale of the image, by the default it is the same as the default locale of the image builder.", (Object)this.getContainer(), LocalizationFeature.Options.DefaultLocale, (String)"DefaultLocale", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)true, (String)"Please switch to using system properties such as '-Duser.country=CH -Duser.language=de'.");
            }
            case "IncludeAllLocales": {
                return OptionDescriptor.create((String)"IncludeAllLocales", (OptionType)OptionType.User, Boolean.class, (String)"Make all hosted locales available at run time.", (Object)this.getContainer(), LocalizationFeature.Options.IncludeAllLocales, (String)"IncludeAllLocales", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IncludeLocales": {
                return OptionDescriptor.create((String)"IncludeLocales", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Comma separated list of locales to be included into the image. The default locale is included in the list automatically if not present.", (Object)this.getContainer(), LocalizationFeature.Options.IncludeLocales, (String)"IncludeLocales", (OptionStability)OptionStability.STABLE, (boolean)false, (String)"");
            }
            case "IncludeResourceBundles": {
                return OptionDescriptor.create((String)"IncludeResourceBundles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Comma separated list of bundles to be included into the image.", (Object)this.getContainer(), LocalizationFeature.Options.IncludeResourceBundles, (String)"IncludeResourceBundles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LocalizationCompressBundles": {
                return OptionDescriptor.create((String)"LocalizationCompressBundles", (OptionType)OptionType.User, AccumulatingLocatableMultiOptionValue.Strings.class, (String)"Regular expressions matching which bundles should be compressed.", (Object)this.getContainer(), LocalizationFeature.Options.LocalizationCompressBundles, (String)"LocalizationCompressBundles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LocalizationCompressInParallel": {
                return OptionDescriptor.create((String)"LocalizationCompressInParallel", (OptionType)OptionType.Expert, Boolean.class, (String)"Compress the bundles in parallel.", (Object)this.getContainer(), LocalizationFeature.Options.LocalizationCompressInParallel, (String)"LocalizationCompressInParallel", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LocalizationOptimizedMode": {
                return OptionDescriptor.create((String)"LocalizationOptimizedMode", (OptionType)OptionType.User, Boolean.class, (String)"Optimize the resource bundle lookup using a simple map.", (Object)this.getContainer(), LocalizationFeature.Options.LocalizationOptimizedMode, (String)"LocalizationOptimizedMode", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LocalizationSubstituteLoadLookup": {
                return OptionDescriptor.create((String)"LocalizationSubstituteLoadLookup", (OptionType)OptionType.User, Boolean.class, (String)"Store the resource bundle content more efficiently in the fallback mode.", (Object)this.getContainer(), LocalizationFeature.Options.LocalizationSubstituteLoadLookup, (String)"LocalizationSubstituteLoadLookup", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceLocalizationFeature": {
                return OptionDescriptor.create((String)"TraceLocalizationFeature", (OptionType)OptionType.Debug, Boolean.class, (String)"When enabled, localization feature details are printed.", (Object)this.getContainer(), LocalizationFeature.Options.TraceLocalizationFeature, (String)"TraceLocalizationFeature", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 11;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("AddAllCharsets");
                    }
                    case 1: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("DefaultCharset");
                    }
                    case 2: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("DefaultLocale");
                    }
                    case 3: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("IncludeAllLocales");
                    }
                    case 4: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("IncludeLocales");
                    }
                    case 5: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("IncludeResourceBundles");
                    }
                    case 6: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("LocalizationCompressBundles");
                    }
                    case 7: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("LocalizationCompressInParallel");
                    }
                    case 8: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("LocalizationOptimizedMode");
                    }
                    case 9: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("LocalizationSubstituteLoadLookup");
                    }
                    case 10: {
                        return LocalizationFeature_Options_OptionDescriptors.this.get("TraceLocalizationFeature");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

