/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.ImageLayerLoader;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerField;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.imagelayer.CapnProtoAdapters;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredStaticFieldSupport;
import com.oracle.svm.hosted.imagelayer.LoadImageSingletonDataImpl;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.lambda.LambdaParser;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.PatchedWordConstant;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.serialize.SerializationFeature;
import com.oracle.svm.hosted.util.IdentityHashCodeUtil;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import com.oracle.svm.shaded.org.capnproto.StructList;
import com.oracle.svm.shaded.org.capnproto.Text;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.NodeClassMap;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.replacements.nodes.MethodHandleNode;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.internal.reflect.ReflectionFactory;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.impl.CEntryPointLiteralCodePointer;
import org.graalvm.word.WordBase;
import sun.reflect.annotation.AnnotationParser;

public class SVMImageLayerLoader
extends ImageLayerLoader {
    private final Field dynamicHubCompanionField;
    private final boolean useSharedLayerGraphs;
    private final SVMImageLayerSnapshotUtil imageLayerSnapshotUtil;
    private final HostedImageLayerBuildingSupport imageLayerBuildingSupport;
    private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot;
    private final FileChannel graphsChannel;
    private final ClassInitializationSupport classInitializationSupport;
    private final boolean buildingApplicationLayer;
    private HostedUniverse hostedUniverse;
    protected final Map<Integer, AnalysisType> types = new ConcurrentHashMap<Integer, AnalysisType>();
    protected final Map<Integer, AnalysisMethod> methods = new ConcurrentHashMap<Integer, AnalysisMethod>();
    protected final Map<Integer, AnalysisField> fields = new ConcurrentHashMap<Integer, AnalysisField>();
    protected final Map<Integer, ImageHeapConstant> constants = new ConcurrentHashMap<Integer, ImageHeapConstant>();
    private final Map<Integer, BaseLayerType> baseLayerTypes = new ConcurrentHashMap<Integer, BaseLayerType>();
    private final Map<Integer, Integer> typeToHubIdentityHashCode = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, BaseLayerMethod> baseLayerMethods = new ConcurrentHashMap<Integer, BaseLayerMethod>();
    private final Map<Integer, BaseLayerField> baseLayerFields = new ConcurrentHashMap<Integer, BaseLayerField>();
    protected final Set<CompletionExecutor.DebugContextRunnable> futureBigbangTasks = ConcurrentHashMap.newKeySet();
    protected final Map<Integer, Integer> typeToConstant = new ConcurrentHashMap<Integer, Integer>();
    protected final Map<String, Integer> stringToConstant = new ConcurrentHashMap<String, Integer>();
    protected final Map<Enum<?>, Integer> enumToConstant = new ConcurrentHashMap();
    protected final Map<Integer, Long> objectOffsets = new ConcurrentHashMap<Integer, Long>();
    private final Map<Class<?>, Boolean> capturingClasses = new ConcurrentHashMap();
    private final Map<ResolvedJavaMethod, Boolean> methodHandleCallers = new ConcurrentHashMap<ResolvedJavaMethod, Boolean>();
    private EconomicMap<String, Integer> typeDescriptorToBaseLayerId;
    private EconomicMap<String, Integer> methodDescriptorToBaseLayerId;
    protected AnalysisUniverse universe;
    protected AnalysisMetaAccess metaAccess;
    protected HostedValuesProvider hostedValuesProvider;
    private final LayeredStaticFieldSupport layeredStaticFieldSupport = LayeredStaticFieldSupport.singleton();
    private NodeClassMap nodeClassMap;

    public SVMImageLayerLoader(SVMImageLayerSnapshotUtil imageLayerSnapshotUtil, HostedImageLayerBuildingSupport imageLayerBuildingSupport, SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot, FileChannel graphChannel, boolean useSharedLayerGraphs) {
        this.dynamicHubCompanionField = ReflectionUtil.lookupField(DynamicHub.class, (String)"companion");
        this.imageLayerSnapshotUtil = imageLayerSnapshotUtil;
        this.imageLayerBuildingSupport = imageLayerBuildingSupport;
        this.snapshot = snapshot;
        this.graphsChannel = graphChannel;
        this.useSharedLayerGraphs = useSharedLayerGraphs;
        this.classInitializationSupport = ClassInitializationSupport.singleton();
        this.buildingApplicationLayer = ImageLayerBuildingSupport.buildingApplicationLayer();
    }

    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    public void setUniverse(AnalysisUniverse universe) {
        this.universe = universe;
    }

    public AnalysisMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    public void setMetaAccess(AnalysisMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public void initNodeClassMap() {
        assert (this.nodeClassMap == null) : "cannot re-initialize the nodeClassMap";
        byte[] encodedGlobalNodeClassMap = this.readEncodedObject(this.snapshot.getNodeClassMapLocation().toString());
        SVMImageLayerSnapshotUtil.AbstractSVMGraphDecoder decoder = this.imageLayerSnapshotUtil.getGraphDecoder(this, null, this.universe.getSnippetReflection(), null);
        this.nodeClassMap = (NodeClassMap)ObjectCopier.decode((ObjectCopier.Decoder)decoder, (byte[])encodedGlobalNodeClassMap);
    }

    public void setHostedValuesProvider(HostedValuesProvider hostedValuesProvider) {
        this.hostedValuesProvider = hostedValuesProvider;
    }

    public HostedUniverse getHostedUniverse() {
        return this.hostedUniverse;
    }

    public void setHostedUniverse(HostedUniverse hostedUniverse) {
        this.hostedUniverse = hostedUniverse;
    }

    public HostedImageLayerBuildingSupport getImageLayerBuildingSupport() {
        return this.imageLayerBuildingSupport;
    }

    public void loadLayerAnalysis() {
        this.universe.setStartTypeId(this.snapshot.getNextTypeId());
        this.universe.setStartMethodId(this.snapshot.getNextMethodId());
        this.universe.setStartFieldId(this.snapshot.getNextFieldId());
        ImageHeapConstant.setCurrentId((int)this.snapshot.getNextConstantId());
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader> typesReader = this.snapshot.getTypes();
        this.typeDescriptorToBaseLayerId = EconomicMap.create((int)typesReader.size());
        for (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData : typesReader) {
            String descriptor = typeData.getDescriptor().toString();
            this.typeDescriptorToBaseLayerId.put((Object)descriptor, (Object)typeData.getId());
        }
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader> methodsReader = this.snapshot.getMethods();
        this.methodDescriptorToBaseLayerId = EconomicMap.create((int)methodsReader.size());
        for (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData : methodsReader) {
            String descriptor = methodData.getDescriptor().toString();
            this.methodDescriptorToBaseLayerId.put((Object)descriptor, (Object)methodData.getId());
        }
        CapnProtoAdapters.forEach(this.snapshot.getConstantsToRelink(), id -> this.prepareConstantRelinking(this.findConstant(id)));
    }

    public void relinkNonTransformedStaticFinalFieldValues() {
        this.relinkStaticFinalFieldValues(false);
    }

    public void relinkTransformedStaticFinalFieldValues() {
        this.relinkStaticFinalFieldValues(true);
    }

    private void relinkStaticFinalFieldValues(boolean isLateLoading) {
        IntStream.range(0, this.snapshot.getConstants().size()).parallel().forEach(i -> {
            ImageHeapConstant constant;
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader constantData = (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader)((Object)((Object)this.snapshot.getConstants().get(i)));
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.Reader relinking = constantData.getObject().getRelinking();
            if (relinking.isFieldConstant() && relinking.getFieldConstant().getRequiresLateLoading() == isLateLoading && (constant = this.getOrCreateConstant(constantData.getId())).getHostedObject() != null) {
                this.universe.getHeapScanner().registerBaseLayerValue(constant, (Object)"persisted");
            }
        });
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader findConstant(int id) {
        return CapnProtoAdapters.binarySearchUnique(id, this.snapshot.getConstants(), SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader::getId);
    }

    private void prepareConstantRelinking(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader constantData) {
        if (!constantData.isObject()) {
            return;
        }
        int id = constantData.getId();
        int identityHashCode = constantData.getIdentityHashCode();
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.Reader relinking = constantData.getObject().getRelinking();
        if (relinking.isClassConstant()) {
            int typeId = relinking.getClassConstant().getTypeId();
            this.typeToConstant.put(typeId, id);
        } else if (relinking.isStringConstant()) {
            String value = relinking.getStringConstant().getValue().toString();
            SVMImageLayerLoader.injectIdentityHashCode(value.intern(), identityHashCode);
            this.stringToConstant.put(value, id);
        } else if (relinking.isEnumConstant()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.EnumConstant.Reader enumConstant = relinking.getEnumConstant();
            Enum<?> enumValue = this.getEnumValue(enumConstant.getEnumClass(), enumConstant.getEnumName());
            SVMImageLayerLoader.injectIdentityHashCode(enumValue, identityHashCode);
            this.enumToConstant.put(enumValue, id);
        }
    }

    public void cleanupAfterCompilation() {
        if (this.graphsChannel != null) {
            try {
                this.graphsChannel.close();
            }
            catch (IOException e) {
                throw AnalysisError.shouldNotReachHere((Throwable)e);
            }
        }
    }

    public AnalysisType getAnalysisTypeForBaseLayerId(int tid) {
        if (!this.types.containsKey(tid)) {
            this.loadType(this.findType(tid));
        }
        AnalysisError.guarantee((boolean)this.types.containsKey(tid), (String)"Type with id %d was not correctly loaded.", (Object[])new Object[]{tid});
        return this.universe.lookup((JavaType)this.types.get(tid).getWrapped());
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader findType(int tid) {
        return CapnProtoAdapters.binarySearchUnique(tid, this.snapshot.getTypes(), SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader::getId);
    }

    private void loadType(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData) {
        int tid = typeData.getId();
        if (this.delegateLoadType(typeData)) {
            return;
        }
        Class<?> clazz = this.lookupBaseLayerTypeInHostVM(typeData.getClassJavaName().toString());
        ResolvedJavaType superClass = this.getResolvedJavaTypeForBaseLayerId(typeData.getSuperClassTypeId());
        ResolvedJavaType[] interfaces = CapnProtoAdapters.toArray(typeData.getInterfaces(), this::getResolvedJavaTypeForBaseLayerId, ResolvedJavaType[]::new);
        if (clazz != null) {
            this.metaAccess.lookupJavaType(clazz);
        }
        if (!this.types.containsKey(tid)) {
            BaseLayerType baseLayerType = this.getBaseLayerType(typeData, tid, superClass, interfaces);
            baseLayerType.setInstanceFields(CapnProtoAdapters.toArray(typeData.getInstanceFieldIds(), this::getBaseLayerField, ResolvedJavaField[]::new));
            baseLayerType.setInstanceFieldsWithSuper(CapnProtoAdapters.toArray(typeData.getInstanceFieldIdsWithSuper(), this::getBaseLayerField, ResolvedJavaField[]::new));
            AnalysisType type = this.universe.lookup((JavaType)baseLayerType);
            AnalysisError.guarantee((SVMImageLayerLoader.getBaseLayerTypeId(type) == tid ? 1 : 0) != 0, (String)"The base layer type %s is not correctly matched to the id %d", (Object[])new Object[]{type, tid});
        }
    }

    protected boolean delegateLoadType(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.WrappedType.Reader wrappedType = typeData.getWrappedType();
        if (wrappedType.isNone()) {
            return false;
        }
        if (wrappedType.isSerializationGenerated()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.WrappedType.SerializationGenerated.Reader sg = wrappedType.getSerializationGenerated();
            String rawDeclaringClassName = sg.getRawDeclaringClass().toString();
            String rawTargetConstructorClassName = sg.getRawTargetConstructor().toString();
            Class<?> rawDeclaringClass = this.imageLayerBuildingSupport.lookupClass(false, rawDeclaringClassName);
            Class<?> rawTargetConstructorClass = this.imageLayerBuildingSupport.lookupClass(false, rawTargetConstructorClassName);
            Constructor rawTargetConstructor = ReflectionUtil.lookupConstructor(rawTargetConstructorClass, (Class[])new Class[0]);
            Constructor<?> constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(rawDeclaringClass, rawTargetConstructor);
            SerializationSupport.currentLayer().addConstructorAccessor(rawDeclaringClass, rawTargetConstructorClass, SerializationFeature.getConstructorAccessor(constructor));
            Class<?> constructorAccessor = SerializationSupport.getSerializationConstructorAccessor(rawDeclaringClass, rawTargetConstructorClass).getClass();
            this.metaAccess.lookupJavaType(constructorAccessor);
            return true;
        }
        if (wrappedType.isLambda()) {
            String capturingClassName = wrappedType.getLambda().getCapturingClass().toString();
            Class<?> capturingClass = this.imageLayerBuildingSupport.lookupClass(false, capturingClassName);
            this.loadLambdaTypes(capturingClass);
            return this.types.containsKey(typeData.getId());
        }
        if (wrappedType.isProxyType()) {
            Class[] interfaces = CapnProtoAdapters.toArray(typeData.getInterfaces(), tid -> this.getAnalysisTypeForBaseLayerId(tid).getJavaClass(), Class[]::new);
            Class<?> proxy = Proxy.getProxyClass(interfaces[0].getClassLoader(), interfaces);
            this.metaAccess.lookupJavaType(proxy);
            return true;
        }
        return false;
    }

    private void loadLambdaTypes(Class<?> capturingClass) {
        this.capturingClasses.computeIfAbsent(capturingClass, key -> {
            LambdaParser.allExecutablesDeclaredInClass((ResolvedJavaType)this.universe.getBigbang().getMetaAccess().lookupJavaType(capturingClass)).filter(m -> m.getCode() != null).forEach(m -> SVMImageLayerLoader.loadLambdaTypes(((AnalysisMethod)m).getWrapped(), this.universe.getBigbang()));
            return true;
        });
    }

    private static void loadLambdaTypes(ResolvedJavaMethod m, BigBang bigBang) {
        StructuredGraph graph = SVMImageLayerLoader.getMethodGraph(m, bigBang);
        if (graph != null) {
            NodeIterable constantNodes = ConstantNode.getConstantNodes((StructuredGraph)graph);
            for (ConstantNode cNode : constantNodes) {
                Class<?> lambdaClass = LambdaParser.getLambdaClassFromConstantNode(cNode);
                if (lambdaClass == null) continue;
                bigBang.getMetaAccess().lookupJavaType(lambdaClass);
            }
        }
    }

    private void loadMethodHandleTargets(ResolvedJavaMethod m, BigBang bigBang) {
        this.methodHandleCallers.computeIfAbsent(m, method -> {
            StructuredGraph graph = SVMImageLayerLoader.getMethodGraph(m, bigBang);
            if (graph != null) {
                for (Node node : graph.getNodes()) {
                    if (!(node instanceof MethodHandleNode)) continue;
                    MethodHandleNode methodHandleNode = (MethodHandleNode)node;
                    bigBang.getUniverse().lookup((JavaMethod)methodHandleNode.getTargetMethod());
                }
            }
            return true;
        });
    }

    private static StructuredGraph getMethodGraph(ResolvedJavaMethod m, BigBang bigBang) {
        StructuredGraph graph;
        if (m instanceof BaseLayerMethod) {
            return null;
        }
        try {
            graph = LambdaParser.createMethodGraph(m, bigBang.getOptions());
        }
        catch (NoClassDefFoundError | BytecodeParser.BytecodeParserError e) {
            return null;
        }
        return graph;
    }

    private ResolvedJavaType getResolvedJavaTypeForBaseLayerId(int tid) {
        return tid == 0 ? null : this.getAnalysisTypeForBaseLayerId(tid).getWrapped();
    }

    protected Class<?> lookupBaseLayerTypeInHostVM(String type) {
        int arrayType = 0;
        String componentType = type;
        while (componentType.endsWith("[]")) {
            componentType = componentType.substring(0, componentType.length() - 2);
            ++arrayType;
        }
        TypeDescriptor.OfField<Class<?>> clazz = SVMImageLayerLoader.lookupPrimitiveClass(componentType);
        if (clazz == null) {
            clazz = this.imageLayerBuildingSupport.lookupClass(true, componentType);
        }
        if (clazz == null) {
            return null;
        }
        while (arrayType > 0) {
            clazz = clazz.arrayType();
            --arrayType;
        }
        return clazz;
    }

    private static Class<?> lookupPrimitiveClass(String type) {
        return switch (type) {
            case "boolean" -> Boolean.TYPE;
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "char" -> Character.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "void" -> Void.TYPE;
            default -> null;
        };
    }

    private BaseLayerType getBaseLayerType(int tid) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData = this.findType(tid);
        ResolvedJavaType superClass = this.getResolvedJavaTypeForBaseLayerId(typeData.getSuperClassTypeId());
        ResolvedJavaType[] interfaces = CapnProtoAdapters.toArray(typeData.getInterfaces(), this::getResolvedJavaTypeForBaseLayerId, ResolvedJavaType[]::new);
        return this.getBaseLayerType(typeData, tid, superClass, interfaces);
    }

    private BaseLayerType getBaseLayerType(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader td, int tid, ResolvedJavaType superClass, ResolvedJavaType[] interfaces) {
        return this.baseLayerTypes.computeIfAbsent(tid, typeId -> {
            String className = td.getClassName().toString();
            String sourceFileName = td.hasSourceFileName() ? td.getSourceFileName().toString() : null;
            ResolvedJavaType enclosingType = this.getResolvedJavaTypeForBaseLayerId(td.getEnclosingTypeId());
            ResolvedJavaType componentType = this.getResolvedJavaTypeForBaseLayerId(td.getComponentTypeId());
            ResolvedJavaType objectType = this.universe.getOriginalMetaAccess().lookupJavaType(Object.class);
            Annotation[] annotations = this.getAnnotations(td.getAnnotationList());
            return new BaseLayerType(className, tid, td.getModifiers(), td.getIsInterface(), td.getIsEnum(), td.getIsInitialized(), td.getIsLinked(), sourceFileName, enclosingType, componentType, superClass, interfaces, objectType, annotations);
        });
    }

    private Annotation[] getAnnotations(StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader> reader) {
        return CapnProtoAdapters.toArray(reader, this::getAnnotation, Annotation[]::new);
    }

    private Annotation getAnnotation(SharedLayerSnapshotCapnProtoSchemaHolder.Annotation.Reader a) {
        String typeName = a.getTypeName().toString();
        Class<Annotation> annotationType = this.lookupBaseLayerTypeInHostVM(typeName).asSubclass(Annotation.class);
        HashMap<String, Object> annotationValuesMap = new HashMap<String, Object>();
        a.getValues().forEach(v -> {
            Object value = this.getAnnotationValue((SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader)((Object)v));
            annotationValuesMap.put(v.getName().toString(), value);
        });
        return AnnotationParser.annotationForMap(annotationType, annotationValuesMap);
    }

    private Object getAnnotationValue(SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader v) {
        return switch (v.which()) {
            default -> throw new MatchException(null, null);
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.STRING -> v.getString().toString();
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.ENUM -> this.getEnumValue(v.getEnum().getClassName(), v.getEnum().getName());
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.PRIMITIVE -> {
                SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader p = v.getPrimitive();
                long rawValue = p.getRawValue();
                char typeChar = (char)p.getTypeChar();
                switch (JavaKind.fromPrimitiveOrVoidTypeChar((char)typeChar)) {
                    case Boolean: {
                        yield rawValue != 0L;
                    }
                    case Byte: {
                        yield (byte)rawValue;
                    }
                    case Char: {
                        yield Character.valueOf((char)rawValue);
                    }
                    case Short: {
                        yield (short)rawValue;
                    }
                    case Int: {
                        yield (int)rawValue;
                    }
                    case Long: {
                        yield rawValue;
                    }
                    case Float: {
                        yield Float.valueOf(Float.intBitsToFloat((int)rawValue));
                    }
                    case Double: {
                        yield Double.longBitsToDouble(rawValue);
                    }
                }
                throw AnalysisError.shouldNotReachHere((String)("Unknown annotation value type: " + typeChar));
            }
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.PRIMITIVE_ARRAY -> CapnProtoAdapters.toArray(v.getPrimitiveArray());
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.CLASS_NAME -> this.imageLayerBuildingSupport.lookupClass(false, v.getClassName().toString());
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.ANNOTATION -> this.getAnnotation(v.getAnnotation());
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which.MEMBERS -> {
                SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Members.Reader m = v.getMembers();
                StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader> mv = m.getMemberValues();
                Class<?> membersClass = this.imageLayerBuildingSupport.lookupClass(false, m.getClassName().toString());
                Object array = Array.newInstance(membersClass, mv.size());
                for (int i = 0; i < mv.size(); ++i) {
                    Array.set(array, i, this.getAnnotationValue((SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Reader)((Object)mv.get(i))));
                }
                yield array;
            }
            case SharedLayerSnapshotCapnProtoSchemaHolder.AnnotationValue.Which._NOT_IN_SCHEMA -> throw AnalysisError.shouldNotReachHere((String)("Unknown annotation value kind: " + String.valueOf((Object)v.which())));
        };
    }

    public int lookupHostedTypeInBaseLayer(AnalysisType type) {
        int id = -1;
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof BaseLayerType) {
            BaseLayerType baseLayerType = (BaseLayerType)resolvedJavaType;
            id = baseLayerType.getBaseLayerId();
        } else {
            String typeDescriptor = this.imageLayerSnapshotUtil.getTypeDescriptor(type);
            Integer typeId = (Integer)this.typeDescriptorToBaseLayerId.get((Object)typeDescriptor);
            if (typeId != null) {
                id = typeId;
                this.initializeBaseLayerTypeBeforePublishing(type, this.findType(typeId));
            }
        }
        if (id == -1 || this.types.putIfAbsent(id, type) != null) {
            return -1;
        }
        return id;
    }

    private static int getBaseLayerTypeId(AnalysisType type) {
        VMError.guarantee(type.isInBaseLayer());
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof BaseLayerType) {
            BaseLayerType baseLayerType = (BaseLayerType)resolvedJavaType;
            return baseLayerType.getBaseLayerId();
        }
        return type.getId();
    }

    private void initializeBaseLayerTypeBeforePublishing(AnalysisType type, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData) {
        assert (!(type.getWrapped() instanceof BaseLayerType));
        Class clazz = OriginalClassProvider.getJavaClass((JavaType)type);
        if (typeData.getIsInitialized()) {
            this.classInitializationSupport.withUnsealedConfiguration(() -> this.classInitializationSupport.initializeAtBuildTime(clazz, "computed in a previous layer"));
        } else if (typeData.getIsFailedInitialization()) {
            this.classInitializationSupport.withUnsealedConfiguration(() -> this.classInitializationSupport.initializeAtBuildTime(clazz, "computed in a previous layer"));
            VMError.guarantee(this.classInitializationSupport.isFailedInitialization(clazz), "Expected the initialization to fail for %s, as it has failed in a previous layer.", clazz);
        } else {
            this.classInitializationSupport.withUnsealedConfiguration(() -> this.classInitializationSupport.initializeAtRunTime(clazz, "computed in a previous layer"));
        }
        int hubIdentityHashCode = typeData.getHubIdentityHashCode();
        this.typeToHubIdentityHashCode.put(typeData.getId(), hubIdentityHashCode);
    }

    public void initializeBaseLayerType(AnalysisType type) {
        VMError.guarantee(type.isInBaseLayer());
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader td = this.findType(SVMImageLayerLoader.getBaseLayerTypeId(type));
        this.registerFlag(td.getIsInstantiated(), debug -> type.registerAsInstantiated((Object)"persisted"));
        this.registerFlag(td.getIsUnsafeAllocated(), debug -> type.registerAsUnsafeAllocated((Object)"persisted"));
        this.registerFlag(td.getIsReachable(), debug -> type.registerAsReachable((Object)"persisted"));
        if (!td.getIsInstantiated() && td.getIsAnySubtypeInstantiated()) {
            PrimitiveList.Int.Reader subTypesReader = td.getSubTypes();
            for (int i = 0; i < subTypesReader.size(); ++i) {
                int tid = subTypesReader.get(i);
                SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader subTypeReader = this.findType(tid);
                if (!subTypeReader.getIsInstantiated()) continue;
                this.registerFlag(true, debug -> this.getAnalysisTypeForBaseLayerId(subTypeReader.getId()));
            }
        }
    }

    private void registerFlag(boolean flag, CompletionExecutor.DebugContextRunnable task) {
        if (flag) {
            if (this.universe.getBigbang() != null) {
                this.universe.getBigbang().postTask(task);
            } else {
                this.futureBigbangTasks.add(task);
            }
        }
    }

    public AnalysisMethod getAnalysisMethodForBaseLayerId(int mid) {
        AnalysisMethod analysisMethod;
        if (!this.methods.containsKey(mid)) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.findMethod(mid);
            this.loadMethod(methodData);
        }
        AnalysisError.guarantee(((analysisMethod = this.methods.get(mid)) != null ? 1 : 0) != 0, (String)"Method with id %d was not correctly loaded.", (Object[])new Object[]{mid});
        return analysisMethod;
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader findMethod(int mid) {
        return CapnProtoAdapters.binarySearchUnique(mid, this.snapshot.getMethods(), SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader::getId);
    }

    private void loadMethod(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData) {
        Executable method;
        int mid = methodData.getId();
        if (this.delegateLoadMethod(methodData)) {
            return;
        }
        int tid = methodData.getDeclaringTypeId();
        AnalysisType type = this.getAnalysisTypeForBaseLayerId(tid);
        AnalysisType[] parameterTypes = CapnProtoAdapters.toArray(methodData.getArgumentTypeIds(), this::getAnalysisTypeForBaseLayerId, AnalysisType[]::new);
        AnalysisType returnType = this.getAnalysisTypeForBaseLayerId(methodData.getReturnTypeId());
        String name = methodData.getName().toString();
        if (methodData.hasClassName()) {
            String className = methodData.getClassName().toString();
            method = null;
            Class<?> clazz = this.lookupBaseLayerTypeInHostVM(className);
            if (clazz != null) {
                Class[] argumentClasses = CapnProtoAdapters.toArray(methodData.getArgumentClassNames(), this::lookupBaseLayerTypeInHostVM, Class[]::new);
                method = SVMImageLayerLoader.lookupMethodByReflection(name, clazz, argumentClasses);
            }
            if (method != null) {
                this.metaAccess.lookupJavaMethod(method);
                if (this.methods.containsKey(mid)) {
                    return;
                }
            }
        }
        Class[] argumentClasses = (Class[])Arrays.stream(parameterTypes).map(AnalysisType::getJavaClass).toArray(Class[]::new);
        method = SVMImageLayerLoader.lookupMethodByReflection(name, type.getJavaClass(), argumentClasses);
        if (method != null) {
            this.metaAccess.lookupJavaMethod(method);
            if (this.methods.containsKey(mid)) {
                return;
            }
        }
        ResolvedSignature signature = ResolvedSignature.fromArray((ResolvedJavaType[])parameterTypes, (ResolvedJavaType)returnType);
        if (name.equals("<init>")) {
            type.findConstructor((Signature)signature);
        } else if (name.equals("<clinit>")) {
            type.getClassInitializer();
        } else {
            type.findMethod(name, (Signature)signature);
        }
        if (!this.methods.containsKey(mid)) {
            this.createBaseLayerMethod(methodData, mid, name, parameterTypes, returnType);
        }
    }

    protected boolean delegateLoadMethod(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.Reader wrappedMethod = methodData.getWrappedMethod();
        if (wrappedMethod.isNone()) {
            return false;
        }
        if (wrappedMethod.isFactoryMethod()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.FactoryMethod.Reader fm = wrappedMethod.getFactoryMethod();
            AnalysisMethod analysisMethod = this.getAnalysisMethodForBaseLayerId(fm.getTargetConstructorId());
            if (analysisMethod.wrapped instanceof BaseLayerMethod) {
                return false;
            }
            AnalysisType instantiatedType = this.getAnalysisTypeForBaseLayerId(fm.getInstantiatedTypeId());
            FactoryMethodSupport.singleton().lookup(this.metaAccess, analysisMethod, instantiatedType, fm.getThrowAllocatedObject());
            return true;
        }
        if (wrappedMethod.isCEntryPointCallStub()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.CEntryPointCallStub.Reader stub = wrappedMethod.getCEntryPointCallStub();
            boolean asNotPublished = stub.getNotPublished();
            AnalysisMethod originalMethod = this.getAnalysisMethodForBaseLayerId(stub.getOriginalMethodId());
            CEntryPointCallStubSupport.singleton().registerStubForMethod(originalMethod, () -> {
                CEntryPointData data = CEntryPointData.create((ResolvedJavaMethod)originalMethod);
                if (asNotPublished) {
                    data = data.copyWithPublishAs(CEntryPoint.Publish.NotPublished);
                }
                return data;
            });
            return true;
        }
        if (wrappedMethod.isWrappedMember()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Reader wm = wrappedMethod.getWrappedMember();
            Executable member = this.getWrappedMember(wm);
            if (member == null) {
                return false;
            }
            if (wm.isReflectionExpandSignature()) {
                ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(member);
            } else if (wm.isJavaCallVariantWrapper()) {
                JNIAccessFeature.singleton().addMethod(member, (FeatureImpl.DuringAnalysisAccessImpl)this.universe.getConcurrentAnalysisAccess());
            }
            return true;
        }
        if (wrappedMethod.isPolymorphicSignature()) {
            int id = methodData.getId();
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.PolymorphicSignature.Reader ps = wrappedMethod.getPolymorphicSignature();
            PrimitiveList.Int.Reader callers = ps.getCallers();
            for (int i = 0; i < callers.size(); ++i) {
                this.loadMethodHandleTargets(this.getAnalysisMethodForBaseLayerId((int)callers.get((int)i)).wrapped, this.universe.getBigbang());
                if (!this.methods.containsKey(id)) continue;
                return true;
            }
            LogUtils.warning((String)"The PolymorphicSignature method %s.%s could not get loaded", (Object[])new Object[]{methodData.getClassName().toString(), methodData.getName().toString()});
            return false;
        }
        return false;
    }

    private Executable getWrappedMember(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.WrappedMethod.WrappedMember.Reader memberData) {
        String className = memberData.getDeclaringClassName().toString();
        Class<?> declaringClass = this.imageLayerBuildingSupport.lookupClass(true, className);
        if (declaringClass == null) {
            return null;
        }
        String name = memberData.getName().toString();
        Class[] parameters = CapnProtoAdapters.toArray(memberData.getArgumentTypeNames(), c -> this.imageLayerBuildingSupport.lookupClass(false, (String)c), Class[]::new);
        return SVMImageLayerLoader.lookupMethodByReflection(name, declaringClass, parameters);
    }

    private static Executable lookupMethodByReflection(String name, Class<?> clazz, Class<?>[] argumentClasses) {
        try {
            Executable method = name.equals("<init>") ? ReflectionUtil.lookupConstructor((boolean)true, clazz, (Class[])argumentClasses) : ReflectionUtil.lookupMethod((boolean)true, clazz, (String)name, (Class[])argumentClasses);
            return method;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private void createBaseLayerMethod(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader md, int mid, String name, AnalysisType[] parameterTypes, AnalysisType returnType) {
        AnalysisType type = this.getAnalysisTypeForBaseLayerId(md.getDeclaringTypeId());
        ResolvedSignature signature = ResolvedSignature.fromArray((ResolvedJavaType[])parameterTypes, (ResolvedJavaType)returnType);
        byte[] code = md.hasBytecode() ? md.getBytecode().toArray() : null;
        MethodHandleAccessProvider.IntrinsicMethod methodHandleIntrinsic = !md.hasMethodHandleIntrinsicName() ? null : MethodHandleAccessProvider.IntrinsicMethod.valueOf((String)md.getMethodHandleIntrinsicName().toString());
        Annotation[] annotations = this.getAnnotations(md.getAnnotationList());
        this.baseLayerMethods.computeIfAbsent(mid, methodId -> new BaseLayerMethod(mid, type, name, md.getIsVarArgs(), md.getIsBridge(), signature, md.getCanBeStaticallyBound(), md.getIsConstructor(), md.getModifiers(), md.getIsSynthetic(), code, md.getBytecodeSize(), methodHandleIntrinsic, annotations));
        BaseLayerMethod baseLayerMethod = this.baseLayerMethods.get(mid);
        this.universe.lookup((JavaMethod)baseLayerMethod);
    }

    public int lookupHostedMethodInBaseLayer(AnalysisMethod analysisMethod) {
        return this.getBaseLayerMethodId(analysisMethod);
    }

    private int getBaseLayerMethodId(AnalysisMethod analysisMethod) {
        ResolvedJavaMethod resolvedJavaMethod = analysisMethod.getWrapped();
        if (resolvedJavaMethod instanceof BaseLayerMethod) {
            BaseLayerMethod baseLayerMethod = (BaseLayerMethod)resolvedJavaMethod;
            return baseLayerMethod.getBaseLayerId();
        }
        if (this.methods.containsKey(analysisMethod.getId())) {
            return -1;
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.getMethodData(analysisMethod);
        if (methodData == null) {
            return -1;
        }
        return methodData.getId();
    }

    public void addBaseLayerMethod(AnalysisMethod analysisMethod) {
        this.methods.putIfAbsent(analysisMethod.getId(), analysisMethod);
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader md = this.getMethodData(analysisMethod);
        this.registerFlag(md.getIsVirtualRootMethod(), debug -> analysisMethod.registerAsVirtualRootMethod((Object)"persisted"));
        this.registerFlag(md.getIsDirectRootMethod(), debug -> analysisMethod.registerAsDirectRootMethod((Object)"persisted"));
        this.registerFlag(md.getIsInvoked(), debug -> analysisMethod.registerAsInvoked((Object)"persisted"));
        this.registerFlag(md.getIsImplementationInvoked(), debug -> analysisMethod.registerAsImplementationInvoked((Object)"persisted"));
        this.registerFlag(md.getIsIntrinsicMethod(), debug -> analysisMethod.registerAsIntrinsicMethod((Object)"persisted"));
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader getMethodData(AnalysisMethod analysisMethod) {
        ResolvedJavaMethod resolvedJavaMethod = analysisMethod.getWrapped();
        if (resolvedJavaMethod instanceof BaseLayerMethod) {
            BaseLayerMethod m = (BaseLayerMethod)resolvedJavaMethod;
            return this.findMethod(m.getBaseLayerId());
        }
        String descriptor = this.imageLayerSnapshotUtil.getMethodDescriptor(analysisMethod);
        Integer id = (Integer)this.methodDescriptorToBaseLayerId.get((Object)descriptor);
        return id != null ? this.findMethod(id) : null;
    }

    public StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader> getDynamicHubInfos() {
        return this.snapshot.getDynamicHubInfos();
    }

    public SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader getDynamicHubInfo(AnalysisType aType) {
        SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader result = CapnProtoAdapters.binarySearchUnique(SVMImageLayerLoader.getBaseLayerTypeId(aType), this.snapshot.getDynamicHubInfos(), SharedLayerSnapshotCapnProtoSchemaHolder.DynamicHubInfo.Reader::getTypeId);
        assert (result != null) : aType;
        return result;
    }

    public StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader> getHostedMethods() {
        return this.snapshot.getHostedMethods();
    }

    public SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader getHostedMethodData(int hMethodIndex) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader reader = (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader)((Object)this.snapshot.getHostedMethods().get(hMethodIndex));
        assert (reader.getIndex() == hMethodIndex);
        return reader;
    }

    public SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader getHostedMethodData(AnalysisMethod aMethod) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader aMethodData = this.getMethodData(aMethod);
        return this.getHostedMethodData(aMethodData.getHostedMethodIndex());
    }

    public boolean hasAnalysisParsedGraph(AnalysisMethod analysisMethod) {
        if (!this.useSharedLayerGraphs) {
            return false;
        }
        return this.hasGraph(analysisMethod, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader::hasAnalysisGraphLocation);
    }

    public AnalysisParsedGraph getAnalysisParsedGraph(AnalysisMethod analysisMethod) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.getMethodData(analysisMethod);
        boolean intrinsic = methodData.getAnalysisGraphIsIntrinsic();
        EncodedGraph analyzedGraph = this.getEncodedGraph(analysisMethod, methodData.getAnalysisGraphLocation());
        return new AnalysisParsedGraph(analyzedGraph, intrinsic);
    }

    public boolean hasStrengthenedGraph(AnalysisMethod analysisMethod) {
        return this.hasGraph(analysisMethod, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader::hasStrengthenedGraphLocation);
    }

    public EncodedGraph getStrengthenedGraph(AnalysisMethod analysisMethod) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.getMethodData(analysisMethod);
        return this.getEncodedGraph(analysisMethod, methodData.getStrengthenedGraphLocation());
    }

    private boolean hasGraph(AnalysisMethod analysisMethod, Function<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader, Boolean> hasGraphFunction) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.getMethodData(analysisMethod);
        if (methodData == null) {
            return false;
        }
        return hasGraphFunction.apply(methodData);
    }

    private EncodedGraph getEncodedGraph(AnalysisMethod analysisMethod, Text.Reader location) {
        byte[] encodedAnalyzedGraph = this.readEncodedObject(location.toString());
        SVMImageLayerSnapshotUtil.AbstractSVMGraphDecoder decoder = this.imageLayerSnapshotUtil.getGraphDecoder(this, analysisMethod, this.universe.getSnippetReflection(), this.nodeClassMap);
        EncodedGraph encodedGraph = (EncodedGraph)ObjectCopier.decode((ObjectCopier.Decoder)decoder, (byte[])encodedAnalyzedGraph);
        for (int i = 0; i < encodedGraph.getNumObjects(); ++i) {
            Object obj = encodedGraph.getObject(i);
            if (obj instanceof CGlobalDataInfo) {
                CGlobalDataInfo cGlobalDataInfo = (CGlobalDataInfo)obj;
                encodedGraph.setObject(i, (Object)CGlobalDataFeature.singleton().registerAsAccessedOrGet(cGlobalDataInfo.getData()));
                continue;
            }
            if (!this.buildingApplicationLayer || !(obj instanceof LoadImageSingletonDataImpl)) continue;
            LoadImageSingletonDataImpl data = (LoadImageSingletonDataImpl)obj;
            data.setApplicationLayerConstant();
        }
        return encodedGraph;
    }

    private byte[] readEncodedObject(String location) {
        long nbytes;
        long offset;
        int closingBracketAt = location.length() - 1;
        AnalysisError.guarantee((location.charAt(0) == '@' && location.charAt(closingBracketAt) == ']' ? 1 : 0) != 0, (String)"Location must start with '@' and end with ']': %s", (Object[])new Object[]{location});
        int openingBracketAt = location.indexOf(91, 1, closingBracketAt);
        AnalysisError.guarantee((openingBracketAt < closingBracketAt ? 1 : 0) != 0, (String)"Location does not contain '[' at expected location: %s", (Object[])new Object[]{location});
        try {
            offset = Long.parseUnsignedLong(location.substring(1, openingBracketAt));
            nbytes = Long.parseUnsignedLong(location.substring(openingBracketAt + 1, closingBracketAt));
        }
        catch (NumberFormatException e) {
            throw AnalysisError.shouldNotReachHere((String)("Location contains invalid positive integer(s): " + location));
        }
        ByteBuffer bb = ByteBuffer.allocate(NumUtil.safeToInt((long)nbytes));
        try {
            this.graphsChannel.read(bb, offset);
        }
        catch (IOException e) {
            throw AnalysisError.shouldNotReachHere((String)("Failed reading a graph from location: " + location), (Throwable)e);
        }
        return bb.array();
    }

    public void loadPriorStrengthenedGraphAnalysisElements(AnalysisMethod analysisMethod) {
        if (this.hasStrengthenedGraph(analysisMethod)) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisMethod.Reader methodData = this.getMethodData(analysisMethod);
            byte[] encodedAnalyzedGraph = this.readEncodedObject(methodData.getStrengthenedGraphLocation().toString());
            SnippetReflectionProvider snippetReflection = this.universe.getSnippetReflection();
            SVMImageLayerSnapshotUtil.AbstractSVMGraphDecoder decoder = this.imageLayerSnapshotUtil.getGraphHostedToAnalysisElementsDecoder(this, analysisMethod, snippetReflection, this.nodeClassMap);
            EncodedGraph graph = (EncodedGraph)ObjectCopier.decode((ObjectCopier.Decoder)decoder, (byte[])encodedAnalyzedGraph);
            for (Object o : graph.getObjects()) {
                if (o instanceof AnalysisMethod) {
                    AnalysisMethod m = (AnalysisMethod)o;
                    m.setReachableInCurrentLayer();
                    continue;
                }
                if (o instanceof JavaMethodProfile) {
                    JavaMethodProfile javaMethodProfile = (JavaMethodProfile)o;
                    for (JavaMethodProfile.ProfiledMethod m : javaMethodProfile.getMethods()) {
                        ResolvedJavaMethod resolvedJavaMethod = m.getMethod();
                        if (!(resolvedJavaMethod instanceof AnalysisMethod)) continue;
                        AnalysisMethod aMethod = (AnalysisMethod)resolvedJavaMethod;
                        aMethod.setReachableInCurrentLayer();
                    }
                    continue;
                }
                if (!(o instanceof ImageHeapConstant)) continue;
                ImageHeapConstant constant = (ImageHeapConstant)o;
                this.loadMaterializedChildren(constant);
            }
        }
    }

    private void loadMaterializedChildren(ImageHeapConstant constant) {
        if (constant instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)constant;
            this.loadMaterializedChildren(constant, arg_0 -> ((ImageHeapInstance)imageHeapInstance).getFieldValue(arg_0), imageHeapInstance.getFieldValuesSize());
        } else if (constant instanceof ImageHeapObjectArray) {
            ImageHeapObjectArray imageHeapObjectArray = (ImageHeapObjectArray)constant;
            this.loadMaterializedChildren(constant, arg_0 -> ((ImageHeapObjectArray)imageHeapObjectArray).getElement(arg_0), imageHeapObjectArray.getLength());
        }
    }

    private void loadMaterializedChildren(ImageHeapConstant constant, IntFunction<Object> valuesFunction, int size) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader baseLayerConstant = this.findConstant(ImageHeapConstant.getConstantID((ImageHeapConstant)constant));
        if (baseLayerConstant != null) {
            StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> data = baseLayerConstant.getObject().getData();
            assert (size == data.size()) : "The size of the constant in the base layer does not match the size in the application: %d != %d".formatted(data.size(), size);
            for (int i = 0; i < data.size(); ++i) {
                SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader childConstant = (SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader)((Object)data.get(i));
                if (!childConstant.isObjectConstant() || childConstant.isNotMaterialized()) continue;
                this.loadMaterializedChild(valuesFunction.apply(i));
            }
        }
    }

    private void loadMaterializedChild(Object child) {
        AnalysisFuture analysisFuture;
        Object object;
        if (child instanceof AnalysisFuture && (object = (analysisFuture = (AnalysisFuture)child).ensureDone()) instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)object;
            this.loadMaterializedChildren(imageHeapConstant);
        }
    }

    public AnalysisField getAnalysisFieldForBaseLayerId(int fid) {
        AnalysisField analysisField;
        if (!this.fields.containsKey(fid)) {
            this.loadField(this.findField(fid));
        }
        AnalysisError.guarantee(((analysisField = this.fields.get(fid)) != null ? 1 : 0) != 0, (String)"Field with id %d was not correctly loaded.", (Object[])new Object[]{fid});
        return analysisField;
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader findField(int fid) {
        return CapnProtoAdapters.binarySearchUnique(fid, this.snapshot.getFields(), SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader::getId);
    }

    private void loadField(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData) {
        Field field;
        Class clazz;
        AnalysisType declaringClass = this.getAnalysisTypeForBaseLayerId(fieldData.getDeclaringTypeId());
        String className = fieldData.hasClassName() ? fieldData.getClassName().toString() : null;
        int id = fieldData.getId();
        Class clazz2 = clazz = className != null ? this.lookupBaseLayerTypeInHostVM(className) : declaringClass.getJavaClass();
        if (clazz == null) {
            clazz = declaringClass.getJavaClass();
        }
        try {
            field = ReflectionUtil.lookupField((boolean)true, (Class)clazz, (String)fieldData.getName().toString());
        }
        catch (Throwable e) {
            field = null;
        }
        if (field == null && !(declaringClass.getWrapped() instanceof BaseLayerType)) {
            if (fieldData.getIsStatic()) {
                declaringClass.getStaticFields();
            } else {
                declaringClass.getInstanceFields(true);
            }
            if (this.fields.containsKey(id)) {
                return;
            }
        }
        if (field == null) {
            AnalysisType type = this.getAnalysisTypeForBaseLayerId(fieldData.getTypeId());
            BaseLayerField baseLayerField = this.getBaseLayerField(fieldData, id, declaringClass.getWrapped(), type.getWrapped());
            this.universe.lookup((JavaField)baseLayerField);
        } else {
            this.metaAccess.lookupJavaField(field);
        }
    }

    private BaseLayerField getBaseLayerField(int id) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData = this.findField(id);
        BaseLayerType declaringClass = this.getBaseLayerType(fieldData.getDeclaringTypeId());
        ResolvedJavaType type = this.getResolvedJavaTypeForBaseLayerId(fieldData.getTypeId());
        return this.getBaseLayerField(fieldData, id, (ResolvedJavaType)declaringClass, type);
    }

    private BaseLayerField getBaseLayerField(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fd, int id, ResolvedJavaType declaringClass, ResolvedJavaType type) {
        return this.baseLayerFields.computeIfAbsent(id, fid -> new BaseLayerField(id, fd.getName().toString(), declaringClass, type, fd.getIsInternal(), fd.getIsSynthetic(), fd.getModifiers(), this.getAnnotations(fd.getAnnotationList())));
    }

    public int lookupHostedFieldInBaseLayer(AnalysisField analysisField) {
        return this.getBaseLayerFieldId(analysisField);
    }

    private int getBaseLayerFieldId(AnalysisField analysisField) {
        ResolvedJavaField resolvedJavaField = analysisField.wrapped;
        if (resolvedJavaField instanceof BaseLayerField) {
            BaseLayerField baseLayerField = (BaseLayerField)resolvedJavaField;
            return baseLayerField.getBaseLayerId();
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData = this.getFieldData(analysisField);
        if (fieldData == null) {
            return -1;
        }
        return fieldData.getId();
    }

    public void addBaseLayerField(AnalysisField analysisField) {
        this.fields.putIfAbsent(analysisField.getId(), analysisField);
        if (analysisField.isStatic()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData = this.getFieldData(analysisField);
            assert (fieldData != null) : "The field should be in the base layer";
            this.layeredStaticFieldSupport.ensureInitializedFromFieldData(analysisField, fieldData);
        }
    }

    public void initializeBaseLayerField(AnalysisField analysisField) {
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData = this.getFieldData(analysisField);
        assert (fieldData != null) : "The field should be in the base layer";
        boolean isAccessed = fieldData.getIsAccessed();
        boolean isRead = fieldData.getIsRead();
        if (!analysisField.isStatic() && (isAccessed || isRead)) {
            analysisField.getDeclaringClass().getInstanceFields(true);
        }
        this.registerFlag(isAccessed, debug -> {
            analysisField.injectDeclaredType();
            analysisField.registerAsAccessed((Object)"persisted");
        });
        this.registerFlag(isRead, debug -> analysisField.registerAsRead((Object)"persisted"));
        this.registerFlag(fieldData.getIsWritten(), debug -> {
            analysisField.injectDeclaredType();
            analysisField.registerAsWritten((Object)"persisted");
        });
        this.registerFlag(fieldData.getIsFolded(), debug -> analysisField.registerAsFolded((Object)"persisted"));
        this.registerFlag(fieldData.getIsUnsafeAccessed(), debug -> analysisField.registerAsUnsafeAccessed((Object)"persisted"));
    }

    private SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader getFieldData(AnalysisField analysisField) {
        ResolvedJavaField resolvedJavaField = analysisField.wrapped;
        if (resolvedJavaField instanceof BaseLayerField) {
            BaseLayerField baseLayerField = (BaseLayerField)resolvedJavaField;
            return this.findField(baseLayerField.getBaseLayerId());
        }
        String declTypeDescriptor = this.imageLayerSnapshotUtil.getTypeDescriptor(analysisField.getDeclaringClass());
        Integer declTypeId = (Integer)this.typeDescriptorToBaseLayerId.get((Object)declTypeDescriptor);
        if (declTypeId == null) {
            return null;
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData = this.findType(declTypeId);
        PrimitiveList.Int.Reader fieldIds = analysisField.isStatic() ? typeData.getStaticFieldIds() : typeData.getInstanceFieldIds();
        for (int i = 0; i < fieldIds.size(); ++i) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData = this.findField(fieldIds.get(i));
            if (fieldData == null || !analysisField.getName().equals(fieldData.getName().toString())) continue;
            return fieldData;
        }
        return null;
    }

    public void postFutureBigbangTasks() {
        BigBang bigbang = this.universe.getBigbang();
        AnalysisError.guarantee((bigbang != null ? 1 : 0) != 0, (String)"Those tasks should only be executed when the bigbang is not null.", (Object[])new Object[0]);
        for (CompletionExecutor.DebugContextRunnable task : this.futureBigbangTasks) {
            bigbang.postTask(task);
        }
    }

    public boolean hasValueForConstant(JavaConstant javaConstant) {
        Object object = this.hostedValuesProvider.asObject(Object.class, javaConstant);
        return this.hasValueForObject(object);
    }

    @SuppressFBWarnings(value={"ES"}, justification="Reference equality check needed to detect intern status")
    private boolean hasValueForObject(Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicHub.class, String.class, Enum.class}, (Object)object3, n)) {
            case 0 -> {
                DynamicHub dynamicHub = (DynamicHub)object3;
                yield this.typeToConstant.containsKey(((SVMHost)this.universe.hostVM()).lookupType(dynamicHub).getId());
            }
            case 1 -> {
                String string = (String)object3;
                if (this.stringToConstant.containsKey(string) && string.intern() == string) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Enum e = (Enum)object3;
                yield this.enumToConstant.containsKey(e);
            }
            default -> false;
        };
    }

    public ImageHeapConstant getValueForConstant(JavaConstant javaConstant) {
        Object object = this.hostedValuesProvider.asObject(Object.class, javaConstant);
        return this.getValueForObject(object);
    }

    private ImageHeapConstant getValueForObject(Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicHub.class, String.class, Enum.class}, (Object)object3, n)) {
            case 0 -> {
                DynamicHub dynamicHub = (DynamicHub)object3;
                yield this.getOrCreateConstant(this.typeToConstant.get(((SVMHost)this.universe.hostVM()).lookupType(dynamicHub).getId()));
            }
            case 1 -> {
                String string = (String)object3;
                yield this.getOrCreateConstant(this.stringToConstant.get(string));
            }
            case 2 -> {
                Enum e = (Enum)object3;
                yield this.getOrCreateConstant(this.enumToConstant.get(e));
            }
            default -> throw AnalysisError.shouldNotReachHere((String)"The constant was not in the persisted heap.");
        };
    }

    public Set<Integer> getRelinkedFields(AnalysisType type) {
        return this.imageLayerSnapshotUtil.getRelinkedFields(type, this.metaAccess);
    }

    public ImageHeapConstant getOrCreateConstant(int id) {
        return this.getOrCreateConstant(id, null);
    }

    private ImageHeapConstant getOrCreateConstant(int id, JavaConstant parentReachableHostedObjectCandidate) {
        JavaConstant parentReachableHostedObject;
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.Reader relinking;
        if (this.constants.containsKey(id)) {
            return this.constants.get(id);
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader baseLayerConstant = this.findConstant(id);
        if (baseLayerConstant == null) {
            throw GraalError.shouldNotReachHere((String)"The constant was not reachable in the base image");
        }
        if (baseLayerConstant.isObject() && !baseLayerConstant.getIsSimulated() && (relinking = baseLayerConstant.getObject().getRelinking()).isFieldConstant()) {
            AnalysisField analysisField = this.getAnalysisFieldForBaseLayerId(relinking.getFieldConstant().getOriginFieldId());
            VMError.guarantee(analysisField.getDeclaringClass().isInitialized());
        }
        AnalysisType type = this.getAnalysisTypeForBaseLayerId(baseLayerConstant.getTypeId());
        long objectOffset = baseLayerConstant.getObjectOffset();
        int identityHashCode = baseLayerConstant.getIdentityHashCode();
        if (parentReachableHostedObjectCandidate == null) {
            int parentConstantId = baseLayerConstant.getParentConstantId();
            if (parentConstantId != 0) {
                ImageHeapConstant parentConstant = this.getOrCreateConstant(parentConstantId);
                int index = baseLayerConstant.getParentIndex();
                parentReachableHostedObject = this.getReachableHostedValue(parentConstant, index);
            } else {
                parentReachableHostedObject = null;
            }
        } else {
            parentReachableHostedObject = parentReachableHostedObjectCandidate;
        }
        if (parentReachableHostedObject != null && !type.getJavaClass().equals(Class.class)) {
            SVMImageLayerLoader.injectIdentityHashCode(this.hostedValuesProvider.asObject(Object.class, parentReachableHostedObject), identityHashCode);
        }
        block0 : switch (baseLayerConstant.which()) {
            case OBJECT: {
                switch (baseLayerConstant.getObject().which()) {
                    case INSTANCE: {
                        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> instanceData = baseLayerConstant.getObject().getData();
                        JavaConstant foundHostedObject = this.lookupHostedObject(baseLayerConstant, type);
                        if (foundHostedObject != null && parentReachableHostedObject != null) {
                            Object reachableObject;
                            Object foundObject = this.hostedValuesProvider.asObject(Object.class, foundHostedObject);
                            AnalysisError.guarantee((foundObject == (reachableObject = this.hostedValuesProvider.asObject(Object.class, parentReachableHostedObject)) ? 1 : 0) != 0, (String)"Found discrepancy between recipe-found hosted value %s and parent-reachable hosted value %s.", (Object[])new Object[]{foundObject, reachableObject});
                        }
                        this.addBaseLayerObject(id, objectOffset, () -> {
                            ImageHeapInstance imageHeapInstance = new ImageHeapInstance(type, foundHostedObject == null ? parentReachableHostedObject : foundHostedObject, identityHashCode, id);
                            if (instanceData != null) {
                                Object[] fieldValues = this.getReferencedValues((ImageHeapConstant)imageHeapInstance, instanceData, this.imageLayerSnapshotUtil.getRelinkedFields(type, this.metaAccess));
                                imageHeapInstance.setFieldValues(fieldValues);
                            }
                            return imageHeapInstance;
                        });
                        break block0;
                    }
                    case OBJECT_ARRAY: {
                        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> arrayData = baseLayerConstant.getObject().getData();
                        this.addBaseLayerObject(id, objectOffset, () -> {
                            ImageHeapObjectArray imageHeapObjectArray = new ImageHeapObjectArray(type, null, arrayData.size(), identityHashCode, id);
                            Object[] elementsValues = this.getReferencedValues((ImageHeapConstant)imageHeapObjectArray, arrayData, Set.of());
                            imageHeapObjectArray.setElementValues(elementsValues);
                            return imageHeapObjectArray;
                        });
                        break block0;
                    }
                }
                throw GraalError.shouldNotReachHere((String)("Unknown object  type: " + String.valueOf((Object)baseLayerConstant.getObject().which())));
            }
            case PRIMITIVE_DATA: {
                Object array = CapnProtoAdapters.toArray(baseLayerConstant.getPrimitiveData());
                this.addBaseLayerObject(id, objectOffset, () -> new ImageHeapPrimitiveArray(type, null, array, Array.getLength(array), identityHashCode, id));
                break;
            }
            case RELOCATABLE: {
                String key = baseLayerConstant.getRelocatable().getKey().toString();
                this.addBaseLayerObject(id, objectOffset, () -> ImageHeapRelocatableConstant.create((AnalysisType)type, (String)key, (int)id));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Unknown constant type: " + String.valueOf((Object)baseLayerConstant.which())));
            }
        }
        return this.constants.get(id);
    }

    private Object[] getReferencedValues(ImageHeapConstant parentConstant, StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> data, Set<Integer> positionsToRelink) {
        Object[] values = new Object[data.size()];
        for (int position = 0; position < data.size(); ++position) {
            SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader constantData = (SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader)((Object)data.get(position));
            if (this.delegateProcessing(constantData, values, position)) continue;
            int finalPosition = position;
            values[position] = switch (constantData.which()) {
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.OBJECT_CONSTANT -> {
                    int constantId = constantData.getObjectConstant().getConstantId();
                    boolean relink = positionsToRelink.contains(position);
                    yield new AnalysisFuture(() -> {
                        this.ensureHubInitialized(parentConstant);
                        JavaConstant hostedConstant = relink ? this.getReachableHostedValue(parentConstant, finalPosition) : null;
                        ImageHeapConstant baseLayerConstant = this.getOrCreateConstant(constantId, hostedConstant);
                        this.ensureHubInitialized(baseLayerConstant);
                        if (hostedConstant != null) {
                            this.addBaseLayerValueToImageHeap(baseLayerConstant, parentConstant, finalPosition);
                        }
                        values[finalPosition] = baseLayerConstant;
                        return baseLayerConstant;
                    });
                }
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.NULL_POINTER -> JavaConstant.NULL_POINTER;
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.NOT_MATERIALIZED -> new AnalysisFuture(() -> {
                    Object errorMessage = "Reading the value of a base layer constant which was not materialized in the base image, ";
                    if (parentConstant instanceof ImageHeapInstance) {
                        ImageHeapInstance instance = (ImageHeapInstance)parentConstant;
                        AnalysisField field = SVMImageLayerLoader.getFieldFromIndex(instance, finalPosition);
                        errorMessage = (String)errorMessage + "reachable by reading field " + String.valueOf(field) + " of parent object constant: " + String.valueOf(parentConstant);
                    } else {
                        errorMessage = (String)errorMessage + "reachable by indexing at position " + finalPosition + " into parent array constant: " + String.valueOf(parentConstant);
                    }
                    throw AnalysisError.shouldNotReachHere((String)errorMessage);
                });
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.PRIMITIVE_VALUE -> {
                    SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader pv = constantData.getPrimitiveValue();
                    yield JavaConstant.forPrimitive((char)((char)pv.getTypeChar()), (long)pv.getRawValue());
                }
                default -> throw GraalError.shouldNotReachHere((String)("Unexpected constant reference: " + String.valueOf((Object)constantData.which())));
            };
        }
        return values;
    }

    private boolean delegateProcessing(SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader constantRef, Object[] values, int i) {
        if (constantRef.isMethodPointer()) {
            AnalysisFuture task = new AnalysisFuture(() -> {
                AnalysisType methodPointerType = this.metaAccess.lookupJavaType(MethodPointer.class);
                int mid = constantRef.getMethodPointer().getMethodId();
                AnalysisMethod method = this.getAnalysisMethodForBaseLayerId(mid);
                PatchedWordConstant constant = new PatchedWordConstant((WordBase)new MethodPointer((ResolvedJavaMethod)method), methodPointerType);
                values[i] = constant;
                return constant;
            });
            values[i] = task;
            return true;
        }
        if (constantRef.isCEntryPointLiteralCodePointer()) {
            AnalysisType cEntryPointerLiteralPointerType = this.metaAccess.lookupJavaType(CEntryPointLiteralCodePointer.class);
            SharedLayerSnapshotCapnProtoSchemaHolder.CEntryPointLiteralReference.Reader ref = constantRef.getCEntryPointLiteralCodePointer();
            String methodName = ref.getMethodName().toString();
            Class<?> definingClass = this.lookupBaseLayerTypeInHostVM(ref.getDefiningClass().toString());
            Class[] parameterTypes = CapnProtoAdapters.toArray(ref.getParameterNames(), this::lookupBaseLayerTypeInHostVM, Class[]::new);
            values[i] = new PatchedWordConstant((WordBase)new CEntryPointLiteralCodePointer(definingClass, methodName, parameterTypes), cEntryPointerLiteralPointerType);
            return true;
        }
        if (constantRef.isCGlobalDataBasePointer()) {
            values[i] = new AnalysisFuture(() -> {
                throw AnalysisError.shouldNotReachHere((String)"Reading the CGlobalData base address of the base image is not implemented.");
            });
            return true;
        }
        return false;
    }

    private JavaConstant getReachableHostedValue(ImageHeapConstant parentConstant, int index) {
        if (parentConstant instanceof ImageHeapObjectArray) {
            ImageHeapObjectArray array = (ImageHeapObjectArray)parentConstant;
            return this.getHostedElementValue(array, index);
        }
        if (parentConstant instanceof ImageHeapInstance) {
            ImageHeapInstance instance = (ImageHeapInstance)parentConstant;
            AnalysisField field = SVMImageLayerLoader.getFieldFromIndex(instance, index);
            return this.getHostedFieldValue(instance, field);
        }
        throw AnalysisError.shouldNotReachHere((String)("unexpected constant: " + String.valueOf(parentConstant)));
    }

    private JavaConstant getHostedElementValue(ImageHeapObjectArray array, int idx) {
        JavaConstant hostedArray = array.getHostedObject();
        JavaConstant rawElementValue = null;
        if (hostedArray != null) {
            rawElementValue = this.hostedValuesProvider.readArrayElement(hostedArray, idx);
        }
        return rawElementValue;
    }

    private JavaConstant getHostedFieldValue(ImageHeapInstance instance, AnalysisField field) {
        ValueSupplier rawFieldValue;
        try {
            JavaConstant hostedInstance = instance.getHostedObject();
            AnalysisError.guarantee((hostedInstance != null ? 1 : 0) != 0);
            rawFieldValue = this.hostedValuesProvider.readFieldValue(field, hostedInstance);
        }
        catch (InternalError | LinkageError | TypeNotPresentException e) {
            return null;
        }
        return (JavaConstant)rawFieldValue.get();
    }

    private static AnalysisField getFieldFromIndex(ImageHeapInstance instance, int i) {
        return (AnalysisField)instance.getType().getInstanceFields(true)[i];
    }

    private void addBaseLayerObject(int id, long objectOffset, Supplier<ImageHeapConstant> imageHeapConstantSupplier) {
        this.constants.computeIfAbsent(id, key -> {
            ImageHeapConstant heapObj = (ImageHeapConstant)imageHeapConstantSupplier.get();
            heapObj.markInBaseLayer();
            if (heapObj.getType().getJavaClass().equals(Package.class)) {
                this.universe.getHeapScanner().doScan((JavaConstant)heapObj);
            }
            if (objectOffset != -1L) {
                this.objectOffsets.put(ImageHeapConstant.getConstantID((ImageHeapConstant)heapObj), objectOffset);
                heapObj.markWrittenInPreviousLayer();
            }
            return heapObj;
        });
    }

    private JavaConstant lookupHostedObject(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader baseLayerConstant, AnalysisType analysisType) {
        if (!baseLayerConstant.getIsSimulated()) {
            Class clazz = analysisType.getJavaClass();
            return this.lookupHostedObject(baseLayerConstant, clazz);
        }
        return null;
    }

    private JavaConstant lookupHostedObject(SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Reader baseLayerConstant, Class<?> clazz) {
        if (!baseLayerConstant.isObject()) {
            return null;
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.Reader relinking = baseLayerConstant.getObject().getRelinking();
        if (relinking.isNotRelinked()) {
            return null;
        }
        if (relinking.isFieldConstant()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.FieldConstant.Reader fieldConstant = relinking.getFieldConstant();
            AnalysisField analysisField = this.getAnalysisFieldForBaseLayerId(fieldConstant.getOriginFieldId());
            if (SVMImageLayerLoader.shouldRelinkField(analysisField)) {
                VMError.guarantee(!baseLayerConstant.getIsSimulated(), "Cannot relink simulated constants.");
                VMError.guarantee(analysisField.getDeclaringClass().isInitialized());
                JavaConstant javaConstant = this.hostedValuesProvider.readFieldValueWithReplacement(analysisField, null);
                VMError.guarantee(javaConstant.isNonNull(), "Found NULL_CONSTANT when reading the hosted value of relinked field %s. Since relinked fields should have a concrete non-null value there may be a class initialization mismatch.", analysisField);
                return javaConstant;
            }
        } else if (clazz.equals(Class.class)) {
            if (baseLayerConstant.isObject() && relinking.isClassConstant()) {
                int typeId = relinking.getClassConstant().getTypeId();
                return this.getDynamicHub(typeId);
            }
        } else if (clazz.equals(String.class)) {
            assert (relinking.isStringConstant());
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.StringConstant.Reader stringConstant = relinking.getStringConstant();
            if (stringConstant.hasValue()) {
                String value = stringConstant.getValue().toString();
                String object = value.intern();
                return this.hostedValuesProvider.forObject((Object)object);
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            assert (relinking.isEnumConstant());
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedConstant.Object.Relinking.EnumConstant.Reader enumConstant = relinking.getEnumConstant();
            Enum<?> enumValue = this.getEnumValue(enumConstant.getEnumClass(), enumConstant.getEnumName());
            return this.hostedValuesProvider.forObject(enumValue);
        }
        return null;
    }

    private static boolean shouldRelinkField(AnalysisField field) {
        VMError.guarantee(field.isInBaseLayer());
        return !(field.getWrapped() instanceof BaseLayerField) && !AnnotationAccess.isAnnotationPresent((AnnotatedElement)field, Delete.class);
    }

    private Enum<?> getEnumValue(Text.Reader className, Text.Reader name) {
        Class<?> enumClass = this.imageLayerBuildingSupport.lookupClass(false, className.toString());
        return Enum.valueOf(enumClass.asSubclass(Enum.class), name.toString());
    }

    private void addBaseLayerValueToImageHeap(ImageHeapConstant constant, ImageHeapConstant parentConstant, int i) {
        if (parentConstant instanceof ImageHeapInstance) {
            ImageHeapInstance imageHeapInstance = (ImageHeapInstance)parentConstant;
            this.universe.getHeapScanner().registerBaseLayerValue(constant, (Object)SVMImageLayerLoader.getFieldFromIndex(imageHeapInstance, i));
        } else if (parentConstant instanceof ImageHeapObjectArray) {
            this.universe.getHeapScanner().registerBaseLayerValue(constant, (Object)i);
        } else {
            throw AnalysisError.shouldNotReachHere((String)("unexpected constant: " + String.valueOf(constant)));
        }
    }

    private void ensureHubInitialized(ImageHeapConstant constant) {
        JavaConstant javaConstant = constant.getHostedObject();
        if (constant.getType().getJavaClass().equals(Class.class)) {
            DynamicHub hub = (DynamicHub)this.universe.getHostedValuesProvider().asObject(DynamicHub.class, javaConstant);
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(hub);
            SVMImageLayerLoader.ensureHubInitialized(type);
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData = this.findType(SVMImageLayerLoader.getBaseLayerTypeId(type));
            if (typeData != null && typeData.getHasArrayType()) {
                AnalysisType arrayClass = type.getArrayClass();
                SVMImageLayerLoader.ensureHubInitialized(arrayClass);
            }
        }
    }

    private static void ensureHubInitialized(AnalysisType type) {
        type.registerAsReachable((Object)"persisted");
        type.getInitializeMetaDataTask().ensureDone();
    }

    public Long getObjectOffset(JavaConstant javaConstant) {
        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)javaConstant;
        return this.objectOffsets.get(ImageHeapConstant.getConstantID((ImageHeapConstant)imageHeapConstant));
    }

    public ImageHeapConstant getBaseLayerStaticPrimitiveFields() {
        return this.getOrCreateConstant(this.snapshot.getStaticPrimitiveFieldsConstantId());
    }

    public ImageHeapConstant getBaseLayerStaticObjectFields() {
        return this.getOrCreateConstant(this.snapshot.getStaticObjectFieldsConstantId());
    }

    public long getImageHeapSize() {
        return this.snapshot.getImageHeapSize();
    }

    public boolean hasDynamicHubIdentityHashCode(int tid) {
        return this.typeToHubIdentityHashCode.containsKey(tid);
    }

    public int getDynamicHubIdentityHashCode(int tid) {
        return this.typeToHubIdentityHashCode.get(tid);
    }

    private JavaConstant getDynamicHub(int tid) {
        AnalysisType type = this.getAnalysisTypeForBaseLayerId(tid);
        DynamicHub hub = ((SVMHost)this.universe.hostVM()).dynamicHub((ResolvedJavaType)type);
        return this.hostedValuesProvider.forObject((Object)hub);
    }

    private static void injectIdentityHashCode(Object object, Integer identityHashCode) {
        if (object == null || identityHashCode == null) {
            return;
        }
        boolean result = IdentityHashCodeUtil.injectIdentityHashCode(object, identityHashCode);
        if (!result && SubstrateOptions.LoggingHashCodeInjection.getValue().booleanValue()) {
            LogUtils.warning((String)"Object of type %s already had an hash code: %s", (Object[])new Object[]{object.getClass(), object});
        }
    }

    public void rescanHub(AnalysisType type, DynamicHub hub) {
        if (this.hasValueForObject(hub)) {
            this.universe.getHeapScanner().rescanObject((Object)hub);
            this.scanCompanionField(hub);
            this.universe.getHeapScanner().rescanField((Object)hub.getCompanion(), SVMImageLayerSnapshotUtil.classInitializationInfo);
            if (type.getJavaKind() == JavaKind.Object) {
                if (type.isArray()) {
                    DynamicHub componentHub = hub.getComponentHub();
                    this.scanCompanionField(componentHub);
                    this.universe.getHeapScanner().rescanField((Object)componentHub.getCompanion(), SVMImageLayerSnapshotUtil.arrayHub);
                }
                this.universe.getHeapScanner().rescanField((Object)hub.getCompanion(), SVMImageLayerSnapshotUtil.interfacesEncoding);
                if (type.isEnum()) {
                    this.universe.getHeapScanner().rescanField((Object)hub.getCompanion(), SVMImageLayerSnapshotUtil.enumConstantsReference);
                }
            }
        }
    }

    private void scanCompanionField(DynamicHub hub) {
        ImageHeapInstance instance = (ImageHeapInstance)this.getValueForObject(hub);
        instance.readFieldValue(this.metaAccess.lookupJavaField(this.dynamicHubCompanionField));
    }

    public ClassInitializationInfo getClassInitializationInfo(AnalysisType aType) {
        ClassInitializationInfo.InitState initState;
        SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisType.Reader typeData = this.findType(SVMImageLayerLoader.getBaseLayerTypeId(aType));
        SharedLayerSnapshotCapnProtoSchemaHolder.ClassInitializationInfo.Reader initInfo = typeData.getClassInitializationInfo();
        if (initInfo.getIsNoInitializerNoTracking()) {
            return ClassInitializationInfo.forNoInitializerInfo(false);
        }
        if (initInfo.getIsInitializedNoTracking()) {
            return ClassInitializationInfo.forInitializedInfo(false);
        }
        if (initInfo.getIsFailedNoTracking()) {
            return ClassInitializationInfo.forFailedInfo(false);
        }
        boolean isTracked = initInfo.getIsTracked();
        if (initInfo.getIsInitialized()) {
            initState = ClassInitializationInfo.InitState.FullyInitialized;
        } else if (initInfo.getIsInErrorState()) {
            initState = ClassInitializationInfo.InitState.InitializationError;
        } else {
            assert (initInfo.getIsLinked()) : "Invalid state";
            int classInitializerId = initInfo.getInitializerMethodId();
            MethodPointer classInitializer = classInitializerId == 0 ? null : new MethodPointer((ResolvedJavaMethod)this.getAnalysisMethodForBaseLayerId(classInitializerId));
            return new ClassInitializationInfo(classInitializer, isTracked);
        }
        return new ClassInitializationInfo(initState, initInfo.getHasInitializer(), initInfo.getIsBuildTimeInitialized(), isTracked);
    }

    public static JavaConstantSupplier getConstant(SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader constantReference) {
        return new JavaConstantSupplier(constantReference);
    }

    public static class JavaConstantSupplier {
        private final SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader constantReference;

        JavaConstantSupplier(SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader constantReference) {
            this.constantReference = constantReference;
        }

        public JavaConstant get(SVMImageLayerLoader imageLayerLoader) {
            return switch (this.constantReference.which()) {
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.OBJECT_CONSTANT -> {
                    int id = this.constantReference.getObjectConstant().getConstantId();
                    if (id == 0) {
                        yield null;
                    }
                    yield imageLayerLoader.getOrCreateConstant(id);
                }
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.NULL_POINTER -> JavaConstant.NULL_POINTER;
                case SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Which.PRIMITIVE_VALUE -> {
                    SharedLayerSnapshotCapnProtoSchemaHolder.PrimitiveValue.Reader pv = this.constantReference.getPrimitiveValue();
                    yield JavaConstant.forPrimitive((char)((char)pv.getTypeChar()), (long)pv.getRawValue());
                }
                default -> throw GraalError.shouldNotReachHere((String)("Unexpected constant reference: " + String.valueOf((Object)this.constantReference.which())));
            };
        }
    }
}

