/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.LoadImageSingletonFactory;
import com.oracle.svm.core.layeredimagesingleton.ApplicationLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredAllowNullEntries;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.imagelayer.CrossLayerSingletonMappingInfo;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredImageHeapObjectAdder;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.imagelayer.SlotInfo;
import com.oracle.svm.hosted.imagelayer.SlotRecordKind;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InvocationPluginHelper;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class LoadImageSingletonFeature
implements InternalFeature,
FeatureSingleton,
UnsavedSingleton {
    public static final String CROSS_LAYER_SINGLETON_TABLE_SYMBOL = "__layered_singleton_table_start";
    private final Map<Class<?>, JavaConstant> keyToMultiLayerConstantMap = new ConcurrentHashMap();
    private SVMImageLayerLoader loader;
    private Map<JavaConstant, Integer> constantToTableSlotMap;

    static CrossLayerSingletonMappingInfo getCrossLayerSingletonMappingInfo() {
        return (CrossLayerSingletonMappingInfo)ImageSingletons.lookup(LoadImageSingletonFactory.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        final BiFunction<GraphBuilderContext, ValueNode, ValueNode> loadMultiLayeredImageSingleton = (b, classNode) -> {
            Class key = (Class)b.getSnippetReflection().asObject(Class.class, classNode.asJavaConstant());
            if (ImageLayerBuildingSupport.buildingSharedLayer()) {
                return LoadImageSingletonFactory.loadLayeredImageSingleton(key, b.getMetaAccess());
            }
            JavaConstant multiLayerArray = this.getMultiLayerConstant(key, b.getMetaAccess(), b.getSnippetReflection());
            return ConstantNode.forConstant((JavaConstant)multiLayerArray, (int)1, (boolean)true, (MetaAccessProvider)b.getMetaAccess());
        };
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), MultiLayeredImageSingleton.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getAllLayers", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                b.addPush(JavaKind.Object, (ValueNode)loadMultiLayeredImageSingleton.apply(b, classNode));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getForLayer", new Type[]{Class.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode, ValueNode indexNode) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode layerArray = (ValueNode)b.add((Node)((ValueNode)loadMultiLayeredImageSingleton.apply(b, classNode)));
                    helper.intrinsicArrayRangeCheck(layerArray, indexNode, (ValueNode)ConstantNode.forInt((int)1));
                    ValueNode arrayElem = LoadIndexedNode.create(null, (ValueNode)layerArray, (ValueNode)indexNode, null, (JavaKind)JavaKind.Object, (MetaAccessProvider)b.getMetaAccess(), (ConstantReflectionProvider)b.getConstantReflection());
                    helper.emitFinalReturn(JavaKind.Object, arrayElem);
                    boolean bl = true;
                    return bl;
                }
            }
        });
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        LayeredImageHeapObjectAdder.singleton().registerObjectAdder(this::addInitialObjects);
    }

    static void checkAllowNullEntries(Class<?> key) {
        boolean nullEntriesAllowed = AnnotationAccess.isAnnotationPresent(key, MultiLayeredAllowNullEntries.class);
        UserError.guarantee(nullEntriesAllowed, "This MultiLayeredSingleton requires an entry to be installed in every layer. Please see the javadoc within MultiLayeredAllowNullEntries for more details.", new Object[0]);
    }

    public void processRegisteredSingletons(AnalysisUniverse universe) {
        AnalysisMetaAccess metaAccess = universe.getBigbang().getMetaAccess();
        this.loader = (SVMImageLayerLoader)universe.getImageLayerLoader();
        LayeredImageSingletonSupport layeredImageSingletonSupport = LayeredImageSingletonSupport.singleton();
        layeredImageSingletonSupport.freezeLayeredImageSingletonMetadata();
        Consumer<Object[]> multiLayerEmbeddedRootsRegistration = objArray -> {
            AnalysisMethod method = metaAccess.lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(MultiLayeredImageSingleton.class, (String)"getAllLayers", (Class[])new Class[]{Class.class}));
            JavaConstant javaConstant = universe.getSnippetReflection().forObject(objArray);
            universe.registerEmbeddedRoot(javaConstant, new BytecodePosition(null, (ResolvedJavaMethod)method, -5));
        };
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            Object[] multiLayeredSingletons = layeredImageSingletonSupport.getMultiLayeredImageSingletonKeys().stream().map(key -> layeredImageSingletonSupport.lookup(key, true, true)).toArray();
            if (multiLayeredSingletons.length != 0) {
                multiLayerEmbeddedRootsRegistration.accept(multiLayeredSingletons);
            }
            for (Class<?> clazz : layeredImageSingletonSupport.getFutureLayerAccessibleImageSingletonKeys()) {
                Object singleton = layeredImageSingletonSupport.lookup(clazz, true, false);
                ImageHeapConstant constant = (ImageHeapConstant)universe.getSnippetReflection().forObject(singleton);
                SVMImageLayerSnapshotUtil.forcePersistConstant(constant);
            }
        }
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LoadImageSingletonFactory.class, (Object)new CrossLayerSingletonMappingInfo());
        } else if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            ArrayList applicationLayerEmbeddedRoots = new ArrayList();
            ArrayList multiLayerEmbeddedRoots = new ArrayList();
            for (SlotInfo slotInfo : LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().getPriorKeyToSlotInfoMap().values()) {
                switch (slotInfo.recordKind()) {
                    case APPLICATION_LAYER_SINGLETON: {
                        Class<?> key3 = slotInfo.keyClass();
                        Object singleton = layeredImageSingletonSupport.lookup(key3, true, false);
                        assert (singleton.getClass().equals(key3)) : String.format("We currently require %s to match their key. Key %s, Singleton: %s", ApplicationLayerOnlyImageSingleton.class, key3, singleton);
                        applicationLayerEmbeddedRoots.add(singleton);
                        break;
                    }
                    case MULTI_LAYERED_SINGLETON: {
                        Class<?> key2 = slotInfo.keyClass();
                        if (ImageSingletons.contains(key2)) {
                            multiLayerEmbeddedRoots.add(layeredImageSingletonSupport.lookup(key2, true, true));
                        } else {
                            LoadImageSingletonFeature.checkAllowNullEntries(key2);
                        }
                        metaAccess.lookupJavaType((Class)slotInfo.keyClass().arrayType()).registerAsInstantiated((Object)"Array holding multi-layered image singletons");
                        if (!LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().getPriorLayerObjectIDs(slotInfo.keyClass()).isEmpty()) {
                            metaAccess.lookupJavaType(slotInfo.keyClass()).registerAsInstantiated((Object)"Refers to a prior singleton");
                        }
                        for (int priorId : LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().getPriorLayerObjectIDs(slotInfo.keyClass())) {
                            HostedImageLayerBuildingSupport.singleton().getLoader().getOrCreateConstant(priorId);
                        }
                        break;
                    }
                }
            }
            if (!applicationLayerEmbeddedRoots.isEmpty()) {
                AnalysisMethod analysisMethod = metaAccess.lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(ImageSingletons.class, (String)"lookup", (Class[])new Class[]{Class.class}));
                JavaConstant javaConstant = universe.getSnippetReflection().forObject((Object)applicationLayerEmbeddedRoots.toArray());
                universe.registerEmbeddedRoot(javaConstant, new BytecodePosition(null, (ResolvedJavaMethod)analysisMethod, -5));
            }
            if (!multiLayerEmbeddedRoots.isEmpty()) {
                multiLayerEmbeddedRootsRegistration.accept(multiLayerEmbeddedRoots.toArray());
            }
        } else {
            throw GraalError.unimplemented((String)"More work needed for 3+ layer support");
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl config = (FeatureImpl.BeforeCompilationAccessImpl)access;
        LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().assignSlots(config.getMetaAccess());
    }

    private static AnalysisType getAnalysisType(ResolvedJavaType type) {
        if (type instanceof HostedType) {
            HostedType hostedType = (HostedType)type;
            return hostedType.getWrapped();
        }
        return (AnalysisType)type;
    }

    JavaConstant getMultiLayerConstant(Class<?> key, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflectionProvider) {
        return this.keyToMultiLayerConstantMap.computeIfAbsent(key, k -> this.createMultiLayerArray(key, LoadImageSingletonFeature.getAnalysisType(metaAccess.lookupJavaType((Class)k.arrayType())), snippetReflectionProvider));
    }

    private ImageHeapObjectArray createMultiLayerArray(Class<?> key, AnalysisType arrayType, SnippetReflectionProvider snippetReflectionProvider) {
        List<Integer> priorIds = LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().getPriorLayerObjectIDs(key);
        DynamicImageLayerInfo layerInfo = DynamicImageLayerInfo.singleton();
        Object[] elements = new JavaConstant[layerInfo.numLayers];
        BiConsumer<JavaConstant, Integer> installElement = (arg_0, arg_1) -> LoadImageSingletonFeature.lambda$createMultiLayerArray$0((JavaConstant[])elements, arg_0, arg_1);
        priorIds.forEach(priorId -> {
            ImageHeapConstant priorConstant = this.loader.getOrCreateConstant((int)priorId);
            int index = 0;
            assert (layerInfo.numLayers == 2) : "incompatible with 3+ layers";
            installElement.accept((JavaConstant)priorConstant, index);
        });
        if (ImageSingletons.contains(key)) {
            Object singleton = LayeredImageSingletonSupport.singleton().lookup(key, true, true);
            JavaConstant singletonConstant = snippetReflectionProvider.forObject(singleton);
            installElement.accept(singletonConstant, DynamicImageLayerInfo.getCurrentLayerNumber());
        }
        boolean holesPresent = false;
        for (int i = 0; i < layerInfo.numLayers; ++i) {
            if (elements[i] != null) continue;
            holesPresent = true;
            installElement.accept(JavaConstant.NULL_POINTER, i);
        }
        if (holesPresent) {
            LoadImageSingletonFeature.checkAllowNullEntries(key);
        }
        return ImageHeapObjectArray.createUnbackedImageHeapArray((AnalysisType)arrayType, (Object[])elements);
    }

    public Map<JavaConstant, Integer> getConstantToTableSlotMap() {
        assert (this.constantToTableSlotMap != null);
        return this.constantToTableSlotMap;
    }

    private void addInitialObjects(NativeImageHeap heap, HostedUniverse hUniverse) {
        String addReason = "Read via the layered image singleton support";
        LayeredImageSingletonSupport layeredImageSingletonSupport = LayeredImageSingletonSupport.singleton();
        for (Class<?> keyClass : layeredImageSingletonSupport.getMultiLayeredImageSingletonKeys()) {
            Object singleton = layeredImageSingletonSupport.lookup(keyClass, true, true);
            ImageHeapConstant singletonConstant = (ImageHeapConstant)hUniverse.getSnippetReflection().forObject(singleton);
            heap.addConstant((JavaConstant)singletonConstant, false, addReason);
            int id = ImageHeapConstant.getConstantID((ImageHeapConstant)singletonConstant);
            LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().recordConstantID(keyClass, id);
        }
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            HashMap<JavaConstant, Integer> mappingInfo = new HashMap<JavaConstant, Integer>();
            for (SlotInfo slotInfo : LoadImageSingletonFeature.getCrossLayerSingletonMappingInfo().getCurrentKeyToSlotInfoMap().values()) {
                JavaConstant createdConstant = switch (slotInfo.recordKind()) {
                    default -> throw new MatchException(null, null);
                    case SlotRecordKind.APPLICATION_LAYER_SINGLETON -> {
                        Object singleton = layeredImageSingletonSupport.lookup(slotInfo.keyClass(), true, false);
                        JavaConstant singletonConstant = hUniverse.getSnippetReflection().forObject(singleton);
                        heap.addConstant(singletonConstant, false, addReason);
                        yield singletonConstant;
                    }
                    case SlotRecordKind.MULTI_LAYERED_SINGLETON -> {
                        JavaConstant multiLayerArray = this.getMultiLayerConstant(slotInfo.keyClass(), (MetaAccessProvider)heap.hMetaAccess, hUniverse.getSnippetReflection());
                        heap.addConstant(multiLayerArray, true, addReason);
                        yield multiLayerArray;
                    }
                };
                Integer previous = mappingInfo.put(createdConstant, slotInfo.slotNum());
                assert (previous == null) : previous;
            }
            this.constantToTableSlotMap = Map.copyOf(mappingInfo);
        } else {
            this.constantToTableSlotMap = Map.of();
        }
    }

    private static /* synthetic */ void lambda$createMultiLayerArray$0(JavaConstant[] elements, JavaConstant priorConstant, Integer index) {
        assert (elements[index] == null) : elements[index];
        elements[index.intValue()] = priorConstant;
    }
}

