/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.LayeredClassInitialization;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class LayeredStaticFieldSupportBaseLayerFeature
implements InternalFeature {
    LayeredStaticFieldSupportBaseLayerFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingInitialLayer();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        AnalysisMetaAccess metaAccess = config.getMetaAccess();
        for (String className : SubstrateOptions.ApplicationLayerInitializedClasses.getValue().values()) {
            LayeredClassInitialization.singleton().initializeClassInAppLayer(config.getImageClassLoader().findClassOrFail(className), (MetaAccessProvider)metaAccess);
        }
    }
}

