/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.hosted.imagelayer.LayeredStaticFieldSupport;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class LayeredStaticFieldSupportAppLayerFeature
implements InternalFeature {
    LayeredStaticFieldSupportAppLayerFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingApplicationLayer();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        LayeredStaticFieldSupport.singleton().loadAllAppLayerFields();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        CrossLayerConstantRegistry singleton = CrossLayerConstantRegistry.singletonOrNull();
        if (singleton.constantExists("APPLAYER_PRIMITIVE_STATICFIELDSBASE")) {
            singleton.finalizeFutureHeapConstant("APPLAYER_PRIMITIVE_STATICFIELDSBASE", StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields());
        }
        if (singleton.constantExists("APPLAYER_OBJECT_STATICFIELDSBASE")) {
            singleton.finalizeFutureHeapConstant("APPLAYER_OBJECT_STATICFIELDSBASE", StaticFieldsSupport.getCurrentLayerStaticObjectFields());
        }
    }
}

