/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LayerVerifiedOption;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.driver.IncludeOptionsSupport;
import com.oracle.svm.hosted.driver.LayerOptionsSupport;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.imagelayer.LoadLayerArchiveSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.imagelayer.WriteLayerArchiveSupport;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.shaded.org.capnproto.FromPointerReader;
import com.oracle.svm.shaded.org.capnproto.ReaderOptions;
import com.oracle.svm.shaded.org.capnproto.Serialize;
import com.oracle.svm.util.TypeResult;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsContainer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public final class HostedImageLayerBuildingSupport
extends ImageLayerBuildingSupport {
    private SVMImageLayerLoader loader;
    private SVMImageLayerWriter writer;
    private SVMImageLayerSingletonLoader singletonLoader;
    private final ImageClassLoader imageClassLoader;
    private final SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot;
    private final List<FileChannel> graphsChannels;
    private final WriteLayerArchiveSupport writeLayerArchiveSupport;
    private final LoadLayerArchiveSupport loadLayerArchiveSupport;

    private static String layerCreatePossibleOptions() {
        return "[" + IncludeOptionsSupport.possibleExtendedOptions() + "]";
    }

    private HostedImageLayerBuildingSupport(ImageClassLoader imageClassLoader, SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot, List<FileChannel> graphsChannels, boolean buildingImageLayer, boolean buildingInitialLayer, boolean buildingApplicationLayer, WriteLayerArchiveSupport writeLayerArchiveSupport, LoadLayerArchiveSupport loadLayerArchiveSupport) {
        super(buildingImageLayer, buildingInitialLayer, buildingApplicationLayer);
        this.imageClassLoader = imageClassLoader;
        this.snapshot = snapshot;
        this.graphsChannels = graphsChannels;
        this.writeLayerArchiveSupport = writeLayerArchiveSupport;
        this.loadLayerArchiveSupport = loadLayerArchiveSupport;
    }

    public static HostedImageLayerBuildingSupport singleton() {
        return (HostedImageLayerBuildingSupport)ImageSingletons.lookup(ImageLayerBuildingSupport.class);
    }

    public SVMImageLayerSingletonLoader getSingletonLoader() {
        return this.singletonLoader;
    }

    public void setSingletonLoader(SVMImageLayerSingletonLoader singletonLoader) {
        this.singletonLoader = singletonLoader;
    }

    public SVMImageLayerLoader getLoader() {
        return this.loader;
    }

    public void setLoader(SVMImageLayerLoader loader) {
        this.loader = loader;
    }

    public SVMImageLayerWriter getWriter() {
        return this.writer;
    }

    public void setWriter(SVMImageLayerWriter writer) {
        this.writer = writer;
    }

    public LoadLayerArchiveSupport getLoadLayerArchiveSupport() {
        return this.loadLayerArchiveSupport;
    }

    public WriteLayerArchiveSupport getWriteLayerArchiveSupport() {
        return this.writeLayerArchiveSupport;
    }

    public void archiveLayer() {
        this.writer.dumpFiles();
        this.writeLayerArchiveSupport.write();
    }

    public SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader getSnapshot() {
        return this.snapshot;
    }

    public FileChannel getGraphsChannel() {
        return this.graphsChannels.getFirst();
    }

    public Class<?> lookupClass(boolean optional, String className) {
        TypeResult<Class<?>> typeResult = this.imageClassLoader.findClass(className);
        if (!typeResult.isPresent()) {
            if (optional) {
                return null;
            }
            throw AnalysisError.shouldNotReachHere((String)("Class not found: " + className));
        }
        return (Class)typeResult.get();
    }

    public static void processLayerOptions(EconomicMap<OptionKey<?>, Object> values, NativeImageClassLoaderSupport classLoaderSupport) {
        OptionValues hostedOptions = new OptionValues(values);
        if (HostedImageLayerBuildingSupport.isLayerCreateOptionEnabled(hostedOptions)) {
            LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin = HostedImageLayerBuildingSupport.getLayerCreateValueWithOrigin(hostedOptions);
            String layerCreateValue = HostedImageLayerBuildingSupport.getLayerCreateValue(valueWithOrigin);
            LayerOptionsSupport.LayerOption layerOption = LayerOptionsSupport.LayerOption.parse(layerCreateValue);
            String layerCreateArg = SubstrateOptionsParser.commandArgument(SubstrateOptions.LayerCreate, layerCreateValue);
            Path layerFileName = layerOption.fileName();
            if (layerFileName.toString().isEmpty()) {
                layerFileName = Path.of((String)SubstrateOptions.Name.getValue(hostedOptions) + ".nil", new String[0]);
            }
            if (layerFileName.getParent() != null) {
                throw UserError.abort("The given layer file '%s' in layer creation option '%s' from %s must be a simple file name, i.e., no path separators are allowed.", layerFileName, layerCreateArg, valueWithOrigin.origin());
            }
            Path layerFile = SubstrateOptions.getImagePath(hostedOptions).resolve(layerFileName);
            classLoaderSupport.setLayerFile(layerFile);
            NativeImageClassLoaderSupport.IncludeSelectors layerSelectors = classLoaderSupport.getLayerSelectors();
            for (IncludeOptionsSupport.ExtendedOption option : layerOption.extendedOptions()) {
                IncludeOptionsSupport.parseIncludeSelector(layerCreateArg, valueWithOrigin, layerSelectors, option, HostedImageLayerBuildingSupport.layerCreatePossibleOptions());
            }
            SubstrateOptions.UseBaseLayerInclusionPolicy.update(values, true);
            SubstrateOptions.ClosedTypeWorld.update(values, false);
            if (SubstrateOptions.imageLayerEnabledHandler != null) {
                SubstrateOptions.imageLayerEnabledHandler.onOptionEnabled(values);
            }
            if (SubstrateOptions.imageLayerCreateEnabledHandler != null) {
                SubstrateOptions.imageLayerCreateEnabledHandler.onOptionEnabled(values);
            }
            SubstrateOptions.UseContainerSupport.update(values, false);
            HostedImageLayerBuildingSupport.enableConservativeUnsafeAccess(values);
            SubstrateOptions.ApplicationLayerInitializedClasses.update(values, Module.class.getName());
        }
        if (HostedImageLayerBuildingSupport.isLayerUseOptionEnabled(hostedOptions)) {
            SubstrateOptions.ClosedTypeWorldHubLayout.update(values, false);
            SubstrateOptions.ParseRuntimeOptions.update(values, false);
            if (SubstrateOptions.imageLayerEnabledHandler != null) {
                SubstrateOptions.imageLayerEnabledHandler.onOptionEnabled(values);
            }
            HostedImageLayerBuildingSupport.enableConservativeUnsafeAccess(values);
            SubstrateOptions.ApplicationLayerInitializedClasses.update(values, Module.class.getName());
        }
    }

    private static Path getLayerUseValue(OptionValues hostedOptions) {
        return (Path)((AccumulatingLocatableMultiOptionValue.Paths)SubstrateOptions.LayerUse.getValue(hostedOptions)).lastValue().orElseThrow();
    }

    private static void enableConservativeUnsafeAccess(EconomicMap<OptionKey<?>, Object> values) {
        PointstoOptions.UseConservativeUnsafeAccess.update(values, (Object)true);
    }

    private static LocatableMultiOptionValue.ValueWithOrigin<String> getLayerCreateValueWithOrigin(OptionValues hostedOptions) {
        return ((AccumulatingLocatableMultiOptionValue.Strings)SubstrateOptions.LayerCreate.getValue(hostedOptions)).lastValueWithOrigin().orElseThrow();
    }

    public static boolean isLayerCreateOptionEnabled(OptionValues values) {
        if (SubstrateOptions.LayerCreate.hasBeenSet(values)) {
            return !HostedImageLayerBuildingSupport.getLayerCreateValue(HostedImageLayerBuildingSupport.getLayerCreateValueWithOrigin(values)).isEmpty();
        }
        return false;
    }

    private static String getLayerCreateValue(LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin) {
        return String.join((CharSequence)",", OptionUtils.resolveOptionValuesRedirection(SubstrateOptions.LayerCreate, valueWithOrigin));
    }

    private static boolean isLayerUseOptionEnabled(OptionValues values) {
        if (SubstrateOptions.LayerUse.hasBeenSet(values)) {
            return !HostedImageLayerBuildingSupport.getLayerUseValue(values).toString().isEmpty();
        }
        return false;
    }

    public static HostedImageLayerBuildingSupport initialize(HostedOptionValues values, ImageClassLoader imageClassLoader, Path builderTempDir) {
        boolean buildingFinalLayer;
        boolean buildingSharedLayer = HostedImageLayerBuildingSupport.isLayerCreateOptionEnabled(values);
        boolean buildingExtensionLayer = HostedImageLayerBuildingSupport.isLayerUseOptionEnabled(values);
        boolean buildingImageLayer = buildingSharedLayer || buildingExtensionLayer;
        boolean buildingInitialLayer = buildingImageLayer && !buildingExtensionLayer;
        boolean bl = buildingFinalLayer = buildingImageLayer && !buildingSharedLayer;
        if (buildingImageLayer) {
            ImageLayerBuildingSupport.openModules();
        }
        WriteLayerArchiveSupport writeLayerArchiveSupport = null;
        ArchiveSupport archiveSupport = new ArchiveSupport(false);
        String layerName = (String)SubstrateOptions.Name.getValue(values);
        if (buildingSharedLayer) {
            writeLayerArchiveSupport = new WriteLayerArchiveSupport(layerName, imageClassLoader.classLoaderSupport, builderTempDir, archiveSupport);
        }
        LoadLayerArchiveSupport loadLayerArchiveSupport = null;
        SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshot = null;
        List<FileChannel> graphs = List.of();
        if (buildingExtensionLayer) {
            Path layerFileName = HostedImageLayerBuildingSupport.getLayerUseValue(values);
            loadLayerArchiveSupport = new LoadLayerArchiveSupport(layerName, layerFileName, builderTempDir, archiveSupport);
            boolean strict = (Boolean)SubstrateOptions.LayerOptionVerification.getValue(values);
            boolean verbose = (Boolean)SubstrateOptions.LayerOptionVerificationVerbose.getValue(values);
            loadLayerArchiveSupport.verifyCompatibility(imageClassLoader.classLoaderSupport, HostedImageLayerBuildingSupport.collectLayerVerifications(imageClassLoader), strict, verbose);
            try {
                graphs = List.of(FileChannel.open(loadLayerArchiveSupport.getSnapshotGraphsPath(), new OpenOption[0]));
            }
            catch (IOException e) {
                throw AnalysisError.shouldNotReachHere((String)("Error during image layer snapshot graphs loading " + String.valueOf(loadLayerArchiveSupport.getSnapshotGraphsPath())), (Throwable)e);
            }
            try (FileChannel ch = FileChannel.open(loadLayerArchiveSupport.getSnapshotPath(), new OpenOption[0]);){
                MappedByteBuffer bb = ch.map(FileChannel.MapMode.READ_ONLY, ch.position(), ch.size());
                ReaderOptions opt = new ReaderOptions(Long.MAX_VALUE, ReaderOptions.DEFAULT_READER_OPTIONS.nestingLimit);
                snapshot = (SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader)((Object)Serialize.read((ByteBuffer)bb, (ReaderOptions)opt).getRoot((FromPointerReader)SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.factory));
            }
            catch (IOException e) {
                throw AnalysisError.shouldNotReachHere((String)("Error during image layer snapshot loading " + String.valueOf(loadLayerArchiveSupport.getSnapshotPath())), (Throwable)e);
            }
        }
        HostedImageLayerBuildingSupport imageLayerBuildingSupport = new HostedImageLayerBuildingSupport(imageClassLoader, snapshot, graphs, buildingImageLayer, buildingInitialLayer, buildingFinalLayer, writeLayerArchiveSupport, loadLayerArchiveSupport);
        if (buildingExtensionLayer) {
            imageLayerBuildingSupport.setSingletonLoader(new SVMImageLayerSingletonLoader(imageLayerBuildingSupport, snapshot));
        }
        return imageLayerBuildingSupport;
    }

    public static Map<String, OptionLayerVerificationRequests> collectLayerVerifications(ImageClassLoader loader) {
        Iterable optionDescriptors = OptionsContainer.getDiscoverableOptions((ClassLoader)loader.getClassLoader());
        EconomicMap hostedOptions = EconomicMap.create();
        EconomicMap runtimeOptions = EconomicMap.create();
        HostedOptionParser.collectOptions(optionDescriptors, (EconomicMap<String, OptionDescriptor>)hostedOptions, (EconomicMap<String, OptionDescriptor>)runtimeOptions);
        HashMap<String, OptionLayerVerificationRequests> result = new HashMap<String, OptionLayerVerificationRequests>();
        for (OptionDescriptor optionDescriptor : hostedOptions.getValues()) {
            for (LayerVerifiedOption layerVerification : OptionUtils.getAnnotationsByType(optionDescriptor, LayerVerifiedOption.class)) {
                result.computeIfAbsent((String)optionDescriptor.getName(), (Function<String, OptionLayerVerificationRequests>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$collectLayerVerifications$0(jdk.graal.compiler.options.OptionDescriptor java.lang.String ), (Ljava/lang/String;)Lcom/oracle/svm/hosted/imagelayer/HostedImageLayerBuildingSupport$OptionLayerVerificationRequests;)((OptionDescriptor)optionDescriptor)).requests.put((Object)layerVerification.kind(), (Object)layerVerification);
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP"}, justification="FB reports null pointer dereferencing because it doesn't see through UserError.guarantee.")
    public static void setupSharedLayerLibrary(NativeLibraries nativeLibs) {
        Path sharedLibPath = HostedImageLayerBuildingSupport.singleton().getLoadLayerArchiveSupport().getSharedLibraryPath();
        Path parent = sharedLibPath.getParent();
        VMError.guarantee(parent != null, "Shared layer library path doesn't have a parent.");
        nativeLibs.getLibraryPaths().add(parent.toString());
        Path fileName = sharedLibPath.getFileName();
        VMError.guarantee(fileName != null, "Cannot determine shared layer library file name.");
        String fullLibName = fileName.toString();
        VMError.guarantee(fullLibName.startsWith("lib") && fullLibName.endsWith(".so"), "Expecting that shared layer library file starts with lib and ends with .so. Found: %s", fullLibName);
        String libName = fullLibName.substring("lib".length(), fullLibName.length() - ".so".length());
        HostedDynamicLayerInfo.singleton().registerLibName(libName);
        nativeLibs.addDynamicNonJniLibrary(libName);
    }

    private static /* synthetic */ OptionLayerVerificationRequests lambda$collectLayerVerifications$0(OptionDescriptor optionDescriptor, String key) {
        return new OptionLayerVerificationRequests(optionDescriptor);
    }

    record OptionLayerVerificationRequests(OptionDescriptor option, EconomicMap<LayerVerifiedOption.Kind, LayerVerifiedOption> requests) {
        OptionLayerVerificationRequests(OptionDescriptor option) {
            this(option, (EconomicMap<LayerVerifiedOption.Kind, LayerVerifiedOption>)EconomicMap.create());
        }
    }
}

