/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.imagelayer.BuildingImageLayerPredicate;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedMethodNameFactory;
import com.oracle.svm.shaded.org.capnproto.StructList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton(value={DynamicImageLayerInfo.class}, onlyWith={BuildingImageLayerPredicate.class})
public class HostedDynamicLayerInfo
extends DynamicImageLayerInfo
implements LayeredImageSingleton {
    private final CGlobalData<PointerBase> cGlobalData;
    private final Set<String> priorLayerMethodSymbols = new HashSet<String>();
    private final List<String> libNames;
    private final Map<AnalysisMethod, Integer> priorInstalledOffsetCache = ImageLayerBuildingSupport.buildingExtensionLayer() ? new ConcurrentHashMap() : null;

    HostedDynamicLayerInfo() {
        this(0, null, new ArrayList<String>());
    }

    public static HostedDynamicLayerInfo singleton() {
        return (HostedDynamicLayerInfo)ImageSingletons.lookup(DynamicImageLayerInfo.class);
    }

    private HostedDynamicLayerInfo(int layerNumber, String codeSectionStartSymbol, List<String> libNames) {
        super(layerNumber);
        this.libNames = new ArrayList<String>(libNames);
        this.cGlobalData = codeSectionStartSymbol == null ? null : CGlobalDataFactory.forSymbol(codeSectionStartSymbol);
    }

    @Override
    public DynamicImageLayerInfo.PriorLayerMethodLocation getPriorLayerMethodLocation(SharedMethod sMethod) {
        assert (ImageLayerBuildingSupport.buildingExtensionLayer()) : "This should only be called within extension images. Within the initial layer the direct calls can be performed";
        HostedMethod hMethod = (HostedMethod)sMethod;
        int compiledOffset = this.getPriorInstalledOffset(hMethod.getWrapped());
        assert (hMethod.wrapped.isInBaseLayer() && compiledOffset != -1);
        CGlobalDataInfo basePointer = CGlobalDataFeature.singleton().registerAsAccessedOrGet(this.cGlobalData);
        return new DynamicImageLayerInfo.PriorLayerMethodLocation(basePointer, compiledOffset);
    }

    public boolean compiledInPriorLayer(AnalysisMethod aMethod) {
        assert (!BuildPhaseProvider.isCompileQueueFinished());
        return this.getPriorInstalledOffset(aMethod) != -1;
    }

    private int getPriorInstalledOffset(AnalysisMethod aMethod) {
        if (aMethod.isInBaseLayer()) {
            return this.priorInstalledOffsetCache.computeIfAbsent(aMethod, method -> {
                SVMImageLayerLoader methodData = HostedImageLayerBuildingSupport.singleton().getLoader();
                return methodData.getHostedMethodData(aMethod).getInstalledOffset();
            });
        }
        return -1;
    }

    public static HostedMethodNameFactory.MethodNameInfo loadMethodNameInfo(AnalysisMethod aMethod) {
        if (aMethod.isInBaseLayer()) {
            SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
            SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader methodData = loader.getHostedMethodData(aMethod);
            return new HostedMethodNameFactory.MethodNameInfo(methodData.getHostedMethodName().toString(), methodData.getHostedMethodUniqueName().toString());
        }
        return null;
    }

    public Set<String> getReservedNames() {
        HashSet<String> reservedNames = new HashSet<String>();
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader> methods = HostedImageLayerBuildingSupport.singleton().getLoader().getHostedMethods();
        for (SharedLayerSnapshotCapnProtoSchemaHolder.PersistedHostedMethod.Reader methodData : methods) {
            if (methodData.getMethodId() == -1) continue;
            reservedNames.add(methodData.getHostedMethodUniqueName().toString());
        }
        return Collections.unmodifiableSet(reservedNames);
    }

    public void registerHostedMethod(HostedMethod hMethod) {
        assert (!BuildPhaseProvider.isHostedUniverseBuilt());
        AnalysisMethod aMethod = hMethod.getWrapped();
        if (this.compiledInPriorLayer(aMethod)) {
            assert (aMethod.isInBaseLayer()) : hMethod;
            this.priorLayerMethodSymbols.add(NativeImage.localSymbolNameForMethod(hMethod));
            hMethod.setCompiledInPriorLayer();
        }
    }

    public void defineSymbolsForPriorLayerMethods(ObjectFile objectFile) {
        assert (BuildPhaseProvider.isHeapLayoutFinished());
        this.priorLayerMethodSymbols.forEach(symbol -> objectFile.createUndefinedSymbol(symbol, 0, true));
    }

    public void registerLibName(String lib) {
        this.libNames.add(lib);
    }

    public boolean isImageLayerLib(String lib) {
        return this.libNames.contains(lib);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        assert (ImageLayerBuildingSupport.buildingInitialLayer()) : "This code must be adjusted to support multiple shared layers";
        SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder snapshotBuilder = ((SVMImageLayerWriter.ImageSingletonWriterImpl)writer).getSnapshotBuilder();
        snapshotBuilder.setNextLayerNumber(this.nextLayerNumber);
        writer.writeString("codeSectionStartSymbol", NativeImage.getTextSectionStartSymbol());
        writer.writeStringList("libNames", this.libNames);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshotReader = ((SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl)loader).getSnapshotReader();
        int layerNumber = snapshotReader.getNextLayerNumber();
        String codeSectionStartSymbol = loader.readString("codeSectionStartSymbol");
        List<String> libNames = loader.readStringList("libNames");
        return new HostedDynamicLayerInfo(layerNumber, codeSectionStartSymbol, libNames);
    }
}

