/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.imagelayer.PriorLayerMarker;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.hosted.imagelayer.FutureTrackingInfo;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.ImageLayerIdTrackingSingleton;
import com.oracle.svm.hosted.imagelayer.LayeredImageHeapObjectAdder;
import com.oracle.svm.hosted.imagelayer.PriorTrackingInfo;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.TrackingInfo;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class CrossLayerConstantRegistryFeature
implements InternalFeature,
FeatureSingleton,
CrossLayerConstantRegistry {
    static final int INVALID = -1;
    private static final Object NULL_CONSTANT_MARKER = new Object();
    ImageLayerIdTrackingSingleton tracker;
    boolean candidateRegistrySealed = false;
    boolean patchingSealed = false;
    SVMImageLayerLoader loader;
    Map<String, Object> constantCandidates;
    Map<String, Object> requiredConstants;
    Map<String, Object> finalizedFutureConstants;
    private int[] relocationPatches;
    int relocationPatchesLength = -1;

    public static CrossLayerConstantRegistryFeature singleton() {
        return (CrossLayerConstantRegistryFeature)ImageSingletons.lookup(CrossLayerConstantRegistry.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            this.tracker = new ImageLayerIdTrackingSingleton();
            ImageSingletons.add(ImageLayerIdTrackingSingleton.class, (Object)this.tracker);
        } else {
            this.tracker = (ImageLayerIdTrackingSingleton)ImageSingletons.lookup(ImageLayerIdTrackingSingleton.class);
        }
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            this.constantCandidates = new ConcurrentHashMap<String, Object>();
            this.requiredConstants = ObservableImageHeapMapProvider.create();
        } else {
            this.constantCandidates = Map.of();
            this.requiredConstants = Map.of();
        }
        this.finalizedFutureConstants = ImageLayerBuildingSupport.buildingExtensionLayer() ? ObservableImageHeapMapProvider.create() : Map.of();
        ImageSingletons.add(CrossLayerConstantRegistry.class, (Object)this);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        this.loader = HostedImageLayerBuildingSupport.singleton().getLoader();
        LayeredImageHeapObjectAdder.singleton().registerObjectAdder(this::addInitialObjects);
        CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
        config.registerObjectToConstantReplacer(obj -> this.replacePriorMarkersWithConstant(registry, obj));
    }

    ImageHeapConstant replacePriorMarkersWithConstant(CrossLayerConstantRegistry registry, Object object) {
        if (object instanceof PriorLayerMarker) {
            PriorLayerMarker priorLayerMarker = (PriorLayerMarker)object;
            return (ImageHeapConstant)registry.getConstant(priorLayerMarker.getKey());
        }
        return null;
    }

    private void addInitialObjects(NativeImageHeap heap, HostedUniverse hUniverse) {
        ImageHeapConstant singletonConstant;
        String addReason = "Registered as a required heap constant within the CrossLayerConstantRegistry";
        for (Object constant : this.requiredConstants.values()) {
            singletonConstant = (ImageHeapConstant)hUniverse.getSnippetReflection().forObject(constant);
            heap.addConstant((JavaConstant)singletonConstant, false, addReason);
        }
        for (Object futureConstant : this.finalizedFutureConstants.values()) {
            singletonConstant = futureConstant == NULL_CONSTANT_MARKER ? JavaConstant.NULL_POINTER : (ImageHeapConstant)hUniverse.getSnippetReflection().forObject(futureConstant);
            heap.addConstant((JavaConstant)singletonConstant, false, addReason);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        this.candidateRegistrySealed = true;
        this.constantCandidates.entrySet().stream().filter(e -> e.getValue() instanceof FutureConstantCandidateInfo).forEach(entry -> {
            String key = (String)entry.getKey();
            FutureConstantCandidateInfo futureConstant = (FutureConstantCandidateInfo)entry.getValue();
            ImageHeapRelocatableConstant constant = futureConstant.constant();
            AnalysisType type = constant.getType();
            this.tracker.registerFutureTrackingInfo(new FutureTrackingInfo(key, FutureTrackingInfo.State.Type, type.getId(), -1));
        });
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        this.patchingSealed = true;
        FeatureImpl.BeforeImageWriteAccessImpl config = (FeatureImpl.BeforeImageWriteAccessImpl)access;
        NativeImageHeap heap = config.getImage().getHeap();
        SnippetReflectionProvider snippetReflection = config.getHostedUniverse().getSnippetReflection();
        this.constantCandidates.entrySet().stream().filter(e -> !(e.getValue() instanceof FutureConstantCandidateInfo)).forEach(entry -> {
            ImageHeapConstant constant;
            NativeImageHeap.ObjectInfo objectInfo;
            Object object = entry.getValue();
            Optional<HostedType> optional = config.getHostedMetaAccess().optionalLookupJavaType(object.getClass());
            if (optional.isPresent() && (objectInfo = heap.getConstantInfo((JavaConstant)(constant = (ImageHeapConstant)snippetReflection.forObject(object)))) != null && objectInfo.getOffset() >= 0L) {
                int id = ImageHeapConstant.getConstantID((ImageHeapConstant)constant);
                this.tracker.registerPriorTrackingInfo((String)entry.getKey(), id);
            }
        });
        assert (this.verifyConstantsInstalled(config));
        for (Map.Entry<String, Object> entry2 : this.finalizedFutureConstants.entrySet()) {
            Object value = entry2.getValue();
            if (value == NULL_CONSTANT_MARKER) {
                FutureTrackingInfo info = (FutureTrackingInfo)this.tracker.getTrackingInfo(entry2.getKey());
                this.tracker.updateFutureTrackingInfo(new FutureTrackingInfo(info.key(), FutureTrackingInfo.State.Final, -1, -1));
                continue;
            }
            ImageHeapConstant futureConstant = (ImageHeapConstant)snippetReflection.forObject(value);
            NativeImageHeap.ObjectInfo objectInfo = heap.getConstantInfo((JavaConstant)futureConstant);
            int id = ImageHeapConstant.getConstantID((ImageHeapConstant)futureConstant);
            FutureTrackingInfo info = (FutureTrackingInfo)this.tracker.getTrackingInfo(entry2.getKey());
            this.tracker.updateFutureTrackingInfo(new FutureTrackingInfo(info.key(), FutureTrackingInfo.State.Final, id, NumUtil.safeToInt((long)objectInfo.getOffset())));
        }
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            this.generateRelocationPatchArray();
        }
    }

    private void generateRelocationPatchArray() {
        int shift = ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).getShift();
        ArrayList<Integer> patchArray = new ArrayList<Integer>();
        int heapBeginOffset = this.tracker.getImageHeapBeginOffset();
        assert (heapBeginOffset >= 0) : "invalid image heap begin offset " + heapBeginOffset;
        for (Map.Entry<String, List<Integer>> entry : this.tracker.futureKeyToPatchingOffsetsMap.entrySet()) {
            List<Integer> offsetsToPatch = entry.getValue();
            FutureTrackingInfo info = (FutureTrackingInfo)this.tracker.getTrackingInfo(entry.getKey());
            VMError.guarantee(info.state() == FutureTrackingInfo.State.Final, "Invalid future %s", info);
            int offset = info.offset();
            int referenceEncoding = offset == -1 ? 0 : offset >>> shift;
            for (int heapOffset : offsetsToPatch) {
                patchArray.add(heapOffset - heapBeginOffset);
                patchArray.add(referenceEncoding);
            }
        }
        this.relocationPatches = patchArray.stream().mapToInt(Integer::intValue).toArray();
        VMError.guarantee(this.relocationPatchesLength == this.relocationPatches.length, "%s %s", this.relocationPatchesLength, this.relocationPatches);
    }

    private boolean verifyConstantsInstalled(FeatureImpl.BeforeImageWriteAccessImpl config) {
        SnippetReflectionProvider snippetReflection = config.getHostedUniverse().getSnippetReflection();
        NativeImageHeap heap = config.getImage().getHeap();
        for (Object requiredConstant : this.requiredConstants.values()) {
            ImageHeapConstant constant = (ImageHeapConstant)snippetReflection.forObject(requiredConstant);
            NativeImageHeap.ObjectInfo objectInfo = heap.getConstantInfo((JavaConstant)constant);
            assert (objectInfo != null && objectInfo.getOffset() >= 0L) : "Constant is required to be in heap " + String.valueOf(requiredConstant);
        }
        return true;
    }

    @Override
    public boolean constantExists(String keyName) {
        return this.tracker.getTrackingInfo(keyName) != null;
    }

    @Override
    public JavaConstant getConstant(String keyName) {
        TrackingInfo idInfo = this.tracker.getTrackingInfo(keyName);
        if (idInfo instanceof PriorTrackingInfo) {
            PriorTrackingInfo prior = (PriorTrackingInfo)idInfo;
            return this.loader.getOrCreateConstant(prior.constantId());
        }
        Object obj = this.constantCandidates.get(keyName);
        if (obj instanceof FutureConstantCandidateInfo) {
            FutureConstantCandidateInfo info = (FutureConstantCandidateInfo)obj;
            return info.constant();
        }
        if (idInfo instanceof FutureTrackingInfo) {
            FutureTrackingInfo future = (FutureTrackingInfo)idInfo;
            VMError.guarantee(!this.finalizedFutureConstants.containsKey(keyName), "Future was finalized in this layer: %s", future);
            if (future.loaderId() == -1) {
                return JavaConstant.NULL_POINTER;
            }
            if (future.state() != FutureTrackingInfo.State.Type) {
                return this.loader.getOrCreateConstant(future.loaderId());
            }
            FutureConstantCandidateInfo info = (FutureConstantCandidateInfo)this.constantCandidates.computeIfAbsent(keyName, k -> {
                AnalysisType type = this.loader.getAnalysisTypeForBaseLayerId(future.loaderId());
                return new FutureConstantCandidateInfo(ImageHeapRelocatableConstant.create((AnalysisType)type, (String)k));
            });
            return info.constant();
        }
        throw VMError.shouldNotReachHere("Missing key: %s", keyName);
    }

    private void checkCandidateRegistry() {
        VMError.guarantee(!this.candidateRegistrySealed, "cross layer registry is sealed");
    }

    @Override
    public void registerConstantCandidate(String keyName, Object obj) {
        VMError.guarantee(keyName != null && obj != null, "CrossLayer constants are expected to be non-null. %s %s", keyName, obj);
        this.checkCandidateRegistry();
        Object previous = this.constantCandidates.putIfAbsent(keyName, obj);
        VMError.guarantee(previous == null && !this.constantExists(keyName), "This key has been registered before: %s", keyName);
    }

    public boolean isConstantRegistered(Object obj) {
        return this.constantCandidates.containsValue(obj);
    }

    @Override
    public void registerHeapConstant(String keyName, Object obj) {
        this.registerConstantCandidate(keyName, obj);
        Object previous = this.requiredConstants.putIfAbsent(keyName, obj);
        VMError.guarantee(previous == null, "This key has been registered before: %s", keyName);
    }

    @Override
    public ImageHeapConstant registerFutureHeapConstant(String keyName, AnalysisType futureType) {
        assert (futureType != null);
        ImageHeapRelocatableConstant imageHeapConstant = ImageHeapRelocatableConstant.create((AnalysisType)futureType, (String)keyName);
        FutureConstantCandidateInfo constantInfo = new FutureConstantCandidateInfo(imageHeapConstant);
        this.registerConstantCandidate(keyName, constantInfo);
        return constantInfo.constant();
    }

    @Override
    public void finalizeFutureHeapConstant(String keyName, Object obj) {
        this.checkCandidateRegistry();
        VMError.guarantee(this.tracker.getTrackingInfo(keyName) instanceof FutureTrackingInfo, "This key was not registered as a future constant %s", keyName);
        Object object = obj == null ? NULL_CONSTANT_MARKER : obj;
        Object previous = this.finalizedFutureConstants.putIfAbsent(keyName, object);
        VMError.guarantee(previous == null, "This key has been registered before: %s", keyName);
    }

    public void markFutureHeapConstantPatchSite(ImageHeapRelocatableConstant constant, int heapOffset) {
        VMError.guarantee(!this.patchingSealed, "Cross layer patching is sealed");
        ImageHeapRelocatableConstant.RelocatableConstantData data = constant.getConstantData();
        this.tracker.registerPatchSite(data.key, heapOffset);
        this.tracker.updateFutureTrackingInfo(new FutureTrackingInfo(data.key, FutureTrackingInfo.State.Relocatable, ImageHeapConstant.getConstantID((ImageHeapConstant)constant), -1));
    }

    public int computeRelocationPatchesLength() {
        this.patchingSealed = true;
        VMError.guarantee(this.relocationPatchesLength == -1, "called multiple times");
        int numRelocations = 0;
        for (List<Integer> offsetsToPatch : this.tracker.futureKeyToPatchingOffsetsMap.values()) {
            numRelocations += offsetsToPatch.size() * 2;
        }
        this.relocationPatchesLength = numRelocations;
        return this.relocationPatchesLength;
    }

    public int[] getRelocationPatches() {
        VMError.guarantee(this.relocationPatches != null);
        return this.relocationPatches;
    }

    private record FutureConstantCandidateInfo(ImageHeapRelocatableConstant constant) {
    }
}

