/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.image.ExecutableImageViaCC;
import com.oracle.svm.hosted.image.ImageLayerViaCC;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.SharedLibraryImageViaCC;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;

public abstract class AbstractImage {
    protected final HostedMetaAccess metaAccess;
    protected final HostedUniverse universe;
    protected final NativeLibraries nativeLibs;
    protected final NativeImageHeap heap;
    protected final ClassLoader imageClassLoader;
    protected final NativeImageCodeCache codeCache;
    protected final List<HostedMethod> entryPoints;
    protected int imageFileSize = -1;
    protected int debugInfoSize = -1;
    protected final NativeImageKind imageKind;

    protected AbstractImage(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        this.imageKind = k;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.nativeLibs = nativeLibs;
        this.heap = heap;
        this.codeCache = codeCache;
        this.entryPoints = entryPoints;
        this.imageClassLoader = imageClassLoader;
    }

    public NativeImageKind getImageKind() {
        return this.imageKind;
    }

    public int getImageFileSize() {
        assert (this.imageFileSize > 0) : "imageFileSize read before being set; cannot be zero";
        return this.imageFileSize;
    }

    public int getDebugInfoSize() {
        assert (this.debugInfoSize >= 0) : "debugInfoSize read before being set";
        return this.debugInfoSize;
    }

    public NativeLibraries getNativeLibs() {
        return this.nativeLibs;
    }

    public abstract void build(String var1, DebugContext var2);

    public abstract LinkerInvocation write(DebugContext var1, Path var2, Path var3, String var4, FeatureImpl.BeforeImageWriteAccessImpl var5);

    public static AbstractImage create(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader classLoader) {
        return switch (k.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> new SharedLibraryImageViaCC(universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
            case 0 -> new ImageLayerViaCC(universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
            case 2, 3 -> new ExecutableImageViaCC(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
        };
    }

    public abstract String[] makeLaunchCommand(NativeImageKind var1, String var2, Path var3, Path var4, Method var5);

    public NativeImageCodeCache getCodeCache() {
        return this.codeCache;
    }

    public NativeImageHeap getHeap() {
        return this.heap;
    }

    public abstract long getImageHeapSize();

    public abstract ObjectFile getObjectFile();

    public static enum NativeImageKind {
        IMAGE_LAYER(false, true){

            @Override
            protected String getFilenameSuffix() {
                return ".so";
            }
        }
        ,
        SHARED_LIBRARY(false){

            @Override
            protected String getFilenameSuffix() {
                return switch (ObjectFile.getNativeFormat()) {
                    case ObjectFile.Format.ELF -> ".so";
                    case ObjectFile.Format.MACH_O -> ".dylib";
                    case ObjectFile.Format.PECOFF -> ".dll";
                    default -> throw new AssertionError((Object)"Unreachable");
                };
            }
        }
        ,
        EXECUTABLE(true),
        STATIC_EXECUTABLE(true);

        public final boolean isExecutable;
        public final boolean isImageLayer;
        public final String mainEntryPointName;

        private NativeImageKind(boolean executable) {
            this(executable, false);
        }

        private NativeImageKind(boolean executable, boolean imageLayer) {
            this.isExecutable = executable;
            this.isImageLayer = imageLayer;
            this.mainEntryPointName = executable ? "main" : "run_main";
        }

        public final String getOutputFilename(String imageName) {
            return imageName + this.getFilenameSuffix();
        }

        protected String getFilenameSuffix() {
            return ObjectFile.getNativeFormat() == ObjectFile.Format.PECOFF ? ".exe" : "";
        }
    }
}

