/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingNodePlugin;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingSingleton;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class StaticFinalFieldFoldingFeature
implements InternalFeature,
FeatureSingleton {
    BigBang bb;
    private final Set<AnalysisMethod> analyzedMethods = ConcurrentHashMap.newKeySet();

    public static StaticFinalFieldFoldingFeature singleton() {
        return (StaticFinalFieldFoldingFeature)ImageSingletons.lookup(StaticFinalFieldFoldingFeature.class);
    }

    static boolean isAvailable() {
        return ImageSingletons.contains(StaticFinalFieldFoldingFeature.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.OptStaticFinalFieldFolding.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            ImageSingletons.add(StaticFinalFieldFoldingSingleton.class, (Object)new StaticFinalFieldFoldingSingleton());
        }
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.getHostVM().addMethodAfterBytecodeParsedListener(this::methodAfterBytecodeParsedListener);
        access.getHostVM().addMethodAfterParsingListener(this::methodAfterParsingListener);
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (reason != ParsingReason.JITCompilation) {
            plugins.appendNodePlugin((NodePlugin)new StaticFinalFieldFoldingNodePlugin());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.bb = access.getBigBang();
        StaticFinalFieldFoldingSingleton singleton = StaticFinalFieldFoldingSingleton.singleton();
        SVMImageLayerLoader imageLayerLoader = HostedImageLayerBuildingSupport.singleton().getLoader();
        for (Map.Entry<Integer, StaticFinalFieldFoldingSingleton.PriorLayerFinalFieldFoldingInfo> entry : singleton.baseLayerFieldFoldingInfos.entrySet()) {
            StaticFinalFieldFoldingFeature.addFoldedValue(imageLayerLoader, entry.getKey(), entry.getValue().bytecodeParsedFoldedFieldValue(), singleton.bytecodeParsedFoldedFieldValues);
            StaticFinalFieldFoldingFeature.addFoldedValue(imageLayerLoader, entry.getKey(), entry.getValue().afterParsingHooksDoneFoldedFieldValue(), singleton.afterParsingHooksDoneFoldedFieldValues);
        }
    }

    private static void addFoldedValue(SVMImageLayerLoader imageLayerLoader, int fid, SVMImageLayerLoader.JavaConstantSupplier javaConstantSupplier, Map<AnalysisField, JavaConstant> singleton) {
        JavaConstant javaConstant = javaConstantSupplier.get(imageLayerLoader);
        if (javaConstant != null) {
            singleton.put(imageLayerLoader.getAnalysisFieldForBaseLayerId(fid), javaConstant);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.bb = null;
        StaticFinalFieldFoldingSingleton singleton = StaticFinalFieldFoldingSingleton.singleton();
        ArrayList<AnalysisField> foldedFields = new ArrayList<AnalysisField>(singleton.getFoldedFieldValues(AnalysisParsedGraph.Stage.finalStage()).keySet());
        VMError.guarantee(singleton.getFoldedFieldValues(AnalysisParsedGraph.Stage.finalStage()).keySet().containsAll(singleton.getFoldedFieldValues(AnalysisParsedGraph.Stage.firstStage()).keySet()), "All fields folded in earlier stages must be present in the final stage.");
        foldedFields.sort(Comparator.comparing(AnalysisField::getId));
        int fieldCheckIndex = singleton.baseLayerFieldFoldingInfos.size();
        for (AnalysisField field : foldedFields) {
            if (singleton.baseLayerFieldFoldingInfos.containsKey(field.getId())) continue;
            singleton.fieldCheckIndexMap.put(field, fieldCheckIndex);
            ++fieldCheckIndex;
        }
        SVMImageLayerLoader imageLayerLoader = HostedImageLayerBuildingSupport.singleton().getLoader();
        for (Map.Entry<Integer, StaticFinalFieldFoldingSingleton.PriorLayerFinalFieldFoldingInfo> entry : singleton.baseLayerFieldFoldingInfos.entrySet()) {
            singleton.fieldCheckIndexMap.put(imageLayerLoader.getAnalysisFieldForBaseLayerId(entry.getKey()), entry.getValue().fieldCheckIndex());
        }
        singleton.fieldInitializationStatus = new boolean[fieldCheckIndex];
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        StaticFinalFieldFoldingSingleton singleton = StaticFinalFieldFoldingSingleton.singleton();
        for (Map.Entry<AnalysisField, Integer> entry : singleton.fieldCheckIndexMap.entrySet()) {
            AnalysisField key = entry.getKey();
            if (key.getDeclaringClass().isInitialized()) {
                singleton.fieldInitializationStatus[entry.getValue().intValue()] = true;
            }
            if (!singleton.baseLayerFieldFoldingInfos.containsKey(key.getId())) continue;
            boolean priorLayerStatus = singleton.baseLayerFieldFoldingInfos.get(key.getId()).initializationStatus();
            boolean currentLayerStatus = singleton.fieldInitializationStatus[entry.getValue()];
            assert (priorLayerStatus == currentLayerStatus) : "Field %s initialization status was %s in the base layer, but is %s in the application".formatted(key, priorLayerStatus, currentLayerStatus);
        }
    }

    private void methodAfterBytecodeParsedListener(AnalysisMethod method, StructuredGraph graph) {
        assert (AnalysisParsedGraph.Stage.isRequiredStage((AnalysisParsedGraph.Stage)AnalysisParsedGraph.Stage.BYTECODE_PARSED, (AnalysisMethod)method));
        this.analyzeParsedMethod(AnalysisParsedGraph.Stage.BYTECODE_PARSED, method, graph);
    }

    private void methodAfterParsingListener(AnalysisMethod method, StructuredGraph graph) {
        this.analyzeParsedMethod(AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED, method, graph);
    }

    private void analyzeParsedMethod(AnalysisParsedGraph.Stage stage, AnalysisMethod method, StructuredGraph graph) {
        StaticFinalFieldFoldingSingleton singleton = StaticFinalFieldFoldingSingleton.singleton();
        boolean isClassInitializer = method.isClassInitializer();
        HashMap<AnalysisField, JavaConstant> optimizableFields = isClassInitializer ? new HashMap<AnalysisField, JavaConstant>() : null;
        HashSet<AnalysisField> ineligibleFields = isClassInitializer ? new HashSet<AnalysisField>() : null;
        for (Node n : graph.getNodes()) {
            StoreFieldNode node;
            AnalysisField field;
            if (!(n instanceof StoreFieldNode) || !(field = (AnalysisField)(node = (StoreFieldNode)n).field()).isStatic() || !field.isFinal() || !field.installableInLayer()) continue;
            if (isClassInitializer && field.getDeclaringClass().equals((Object)method.getDeclaringClass())) {
                StaticFinalFieldFoldingFeature.analyzeStoreInClassInitializer(node, field, optimizableFields, ineligibleFields);
                continue;
            }
            this.analyzeStoreOutsideClassInitializer(singleton, stage, method, field);
        }
        if (optimizableFields != null && !optimizableFields.isEmpty()) {
            this.verifyOptimizableFields(singleton, stage, method, optimizableFields);
            singleton.getFoldedFieldValues(stage).putAll(optimizableFields);
        }
        this.analyzedMethods.add(method);
    }

    private void verifyOptimizableFields(StaticFinalFieldFoldingSingleton singleton, AnalysisParsedGraph.Stage stage, AnalysisMethod method, Map<AnalysisField, JavaConstant> optimizableFields) {
        if (!this.analyzedMethods.contains(method)) {
            return;
        }
        for (Map.Entry<AnalysisField, JavaConstant> entry : optimizableFields.entrySet()) {
            for (AnalysisParsedGraph.Stage curStage = stage; curStage != null; curStage = curStage.previous()) {
                JavaConstant javaConstant = singleton.getFoldedFieldValue(stage, entry.getKey());
                UserError.guarantee(javaConstant == null || javaConstant.equals((Object)entry.getValue()), "The static final field optimization found a static final field %s which is initialized multiple times with different constant values. You can use %s to disable the optimization.", entry.getKey().format("%H.%n"), SubstrateOptionsParser.commandArgument(Options.OptStaticFinalFieldFolding, "-"));
            }
        }
    }

    private static void analyzeStoreInClassInitializer(StoreFieldNode node, AnalysisField field, Map<AnalysisField, JavaConstant> optimizableFields, Set<AnalysisField> ineligibleFields) {
        if (field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            return;
        }
        if (node.value().isJavaConstant() && !ineligibleFields.contains(field)) {
            JavaConstant existingValue = optimizableFields.get(field);
            JavaConstant newValue = node.value().asJavaConstant();
            if (existingValue == null || existingValue.equals((Object)newValue)) {
                optimizableFields.put(field, newValue);
                return;
            }
        }
        ineligibleFields.add(field);
        optimizableFields.remove(field);
    }

    private void analyzeStoreOutsideClassInitializer(StaticFinalFieldFoldingSingleton singleton, AnalysisParsedGraph.Stage stage, AnalysisMethod method, AnalysisField field) {
        if (field.getDeclaringClass().getClassInitializer() != null) {
            field.getDeclaringClass().getClassInitializer().ensureGraphParsed(this.bb);
        }
        if (singleton.getFoldedFieldValues(stage).containsKey(field)) {
            throw UserError.abort("The static final field optimization found a static final field that is initialized both inside and outside of its class initializer. Field %s is stored in method %s. This violates the Java bytecode specification. You can use %s to disable the optimization.", field.format("%H.%n"), method.format("%H.%n(%p)"), SubstrateOptionsParser.commandArgument(Options.OptStaticFinalFieldFolding, "-"));
        }
    }

    static boolean isOptimizationCandidate(AnalysisField aField, AnalysisMethod definingClassInitializer, FieldValueInterceptionSupport fieldValueInterceptionSupport) {
        if (definingClassInitializer == null) {
            return false;
        }
        return fieldValueInterceptionSupport.isValueAvailable(aField);
    }

    static boolean isAllowedTargetMethod(ResolvedJavaMethod method) {
        return !SubstrateCompilationDirectives.isRuntimeCompiledMethod(method) && !SubstrateCompilationDirectives.isDeoptTarget(method);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> OptStaticFinalFieldFolding = new HostedOptionKey<Boolean>(true);
    }
}

