/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingSingleton;
import com.oracle.svm.hosted.meta.HostedField;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@NodeInfo(size=NodeSize.SIZE_1, cycles=NodeCycles.CYCLES_1)
public final class IsStaticFinalFieldInitializedNode
extends FixedWithNextNode
implements Simplifiable {
    public static final NodeClass<IsStaticFinalFieldInitializedNode> TYPE = NodeClass.create(IsStaticFinalFieldInitializedNode.class);
    private final ResolvedJavaField field;

    protected IsStaticFinalFieldInitializedNode(ResolvedJavaField field) {
        super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Boolean));
        this.field = field;
    }

    public ResolvedJavaField getField() {
        return this.field;
    }

    public void simplify(SimplifierTool tool) {
        ConstantNode replacementNode;
        if (this.field instanceof AnalysisField) {
            return;
        }
        assert (this.field instanceof HostedField);
        if (this.field.getDeclaringClass().isInitialized()) {
            replacementNode = ConstantNode.forBoolean((boolean)true, (StructuredGraph)this.graph());
        } else {
            StaticFinalFieldFoldingSingleton singleton = StaticFinalFieldFoldingSingleton.singleton();
            Integer fieldCheckIndex = singleton.getFieldCheckIndex(this.field);
            assert (fieldCheckIndex != null) : "Field must be optimizable: " + String.valueOf(this.field);
            ConstantNode fieldInitializationStatusNode = ConstantNode.forConstant((JavaConstant)tool.getSnippetReflection().forObject((Object)singleton.fieldInitializationStatus), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph());
            ConstantNode fieldCheckIndexNode = ConstantNode.forInt((int)fieldCheckIndex, (StructuredGraph)this.graph());
            replacementNode = (ValueNode)this.graph().addOrUniqueWithInputs((Node)LoadIndexedNode.create((Assumptions)this.graph().getAssumptions(), (ValueNode)fieldInitializationStatusNode, (ValueNode)fieldCheckIndexNode, null, (JavaKind)JavaKind.Boolean, (MetaAccessProvider)tool.getMetaAccess(), (ConstantReflectionProvider)tool.getConstantReflection()));
        }
        this.graph().replaceFixed((FixedWithNextNode)this, (Node)replacementNode);
    }
}

