/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.code.IsolateLeaveStub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.code.CEntryPointCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CEntryPointJavaCallStubMethod;
import java.lang.reflect.Executable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public final class CEntryPointCallStubSupport {
    private final BigBang bb;
    private final Map<AnalysisMethod, AnalysisMethod> methodToStub = new ConcurrentHashMap<AnalysisMethod, AnalysisMethod>();
    private final Map<AnalysisMethod, AnalysisMethod> methodToJavaStub = new ConcurrentHashMap<AnalysisMethod, AnalysisMethod>();
    private final ConcurrentHashMap<CFunctionPointer, BoxedRelocatedPointer> cFunctionPointerCache = new ConcurrentHashMap();

    public static CEntryPointCallStubSupport singleton() {
        return (CEntryPointCallStubSupport)ImageSingletons.lookup(CEntryPointCallStubSupport.class);
    }

    CEntryPointCallStubSupport(BigBang bb) {
        this.bb = bb;
    }

    public AnalysisMethod getStubForMethod(Executable reflectionMethod) {
        AnalysisMethod method = this.bb.getMetaAccess().lookupJavaMethod(reflectionMethod);
        return this.getStubForMethod(method);
    }

    public AnalysisMethod registerStubForMethod(Executable reflectionMethod, Supplier<CEntryPointData> entryPointDataSupplier) {
        AnalysisMethod method = this.bb.getMetaAccess().lookupJavaMethod(reflectionMethod);
        return this.registerStubForMethod(method, entryPointDataSupplier);
    }

    public AnalysisMethod getStubForMethod(AnalysisMethod method) {
        return this.methodToStub.get(method);
    }

    public AnalysisMethod getMethodForStub(CEntryPointCallStubMethod method) {
        return method.lookupTargetMethod(this.bb.getMetaAccess());
    }

    public AnalysisMethod registerStubForMethod(AnalysisMethod method, Supplier<CEntryPointData> entryPointDataSupplier) {
        return this.methodToStub.compute(method, (key, existingValue) -> {
            AnalysisMethod value = existingValue;
            if (value == null) {
                assert (!this.bb.getUniverse().sealed());
                CEntryPointData entryPointData = (CEntryPointData)entryPointDataSupplier.get();
                CEntryPointCallStubMethod stub = CEntryPointCallStubMethod.create(this.bb, method, entryPointData);
                AnalysisMethod wrapped = this.bb.getUniverse().lookup((JavaMethod)stub);
                this.bb.addRootMethod(wrapped, true, (Object)("Registered in " + String.valueOf(CEntryPointCallStubSupport.class)), new MultiMethod.MultiMethodKey[0]).registerAsNativeEntryPoint((Object)entryPointData);
                value = wrapped;
            }
            return value;
        });
    }

    public AnalysisMethod registerJavaStubForMethod(AnalysisMethod method) {
        return this.methodToJavaStub.compute(method, (key, existingValue) -> {
            AnalysisMethod value = existingValue;
            if (value == null) {
                assert (!this.bb.getUniverse().sealed());
                AnalysisMethod nativeStub = this.registerStubForMethod(method, () -> CEntryPointData.create((ResolvedJavaMethod)method));
                MethodPointer nativeStubAddress = new MethodPointer((ResolvedJavaMethod)nativeStub);
                String stubName = SubstrateUtil.uniqueStubName((ResolvedJavaMethod)method);
                ResolvedJavaType holderClass = this.bb.getMetaAccess().lookupJavaType(IsolateLeaveStub.class).getWrapped();
                CEntryPointJavaCallStubMethod stub = new CEntryPointJavaCallStubMethod(method.getWrapped(), stubName, holderClass, nativeStubAddress);
                value = this.bb.getUniverse().lookup((JavaMethod)stub);
            }
            return value;
        });
    }

    public BoxedRelocatedPointer getBoxedRelocatedPointer(CFunctionPointer cFunctionPointer) {
        return this.cFunctionPointerCache.computeIfAbsent(cFunctionPointer, BoxedRelocatedPointer::new);
    }
}

