/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.collections.EconomicSet;

public class AnalysisMethodCalleeWalker {
    private final EconomicSet<AnalysisMethod> path = EconomicSet.create();

    public boolean walkMethod(AnalysisMethod method, CallPathVisitor visitor) {
        if (visitor.prologue() != CallPathVisitor.VisitResult.CONTINUE) {
            return false;
        }
        this.path.clear();
        this.walkMethodAndCallees(method, null, null, visitor);
        CallPathVisitor.VisitResult epilogueResult = visitor.epilogue();
        return epilogueResult != CallPathVisitor.VisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallPathVisitor.VisitResult walkMethodAndCallees(AnalysisMethod method, AnalysisMethod caller, BytecodePosition invokePosition, CallPathVisitor visitor) {
        if (!this.path.add((Object)method)) {
            return CallPathVisitor.VisitResult.CUT;
        }
        try {
            CallPathVisitor.VisitResult directResult = visitor.visitMethod(method, caller, invokePosition, this.path.size());
            if (directResult != CallPathVisitor.VisitResult.CONTINUE) {
                CallPathVisitor.VisitResult visitResult = directResult;
                return visitResult;
            }
            for (InvokeInfo invoke : method.getInvokes()) {
                for (AnalysisMethod target : invoke.getOriginalCallees()) {
                    this.walkMethodAndCallees(target, method, invoke.getPosition(), visitor);
                }
            }
            Object object = CallPathVisitor.VisitResult.CONTINUE;
            return object;
        }
        finally {
            this.path.remove((Object)method);
        }
    }

    static abstract class CallPathVisitor {
        CallPathVisitor() {
        }

        public VisitResult prologue() {
            return VisitResult.CONTINUE;
        }

        public abstract VisitResult visitMethod(AnalysisMethod var1, AnalysisMethod var2, BytecodePosition var3, int var4);

        public VisitResult epilogue() {
            return VisitResult.CONTINUE;
        }

        public static enum VisitResult {
            CONTINUE,
            CUT,
            QUIT;

        }
    }
}

