/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationValue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;

public final class TypeAnnotationValue {
    private final byte[] targetInfo;
    private final byte[] locationInfo;
    private final AnnotationValue annotation;
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final byte LOCAL_VARIABLE = 64;
    private static final byte RESOURCE_VARIABLE = 65;
    private static final byte EXCEPTION_PARAMETER = 66;
    private static final byte INSTANCEOF = 67;
    private static final byte NEW = 68;
    private static final byte CONSTRUCTOR_REFERENCE = 69;
    private static final byte METHOD_REFERENCE = 70;
    private static final byte CAST = 71;
    private static final byte CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    private static final byte METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    private static final byte CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    private static final byte METHOD_REFERENCE_TYPE_ARGUMENT = 75;

    private static byte[] extractTargetInfo(ByteBuffer buf) {
        int startPos = buf.position();
        int posCode = buf.get() & 0xFF;
        switch (posCode) {
            case 0: 
            case 1: 
            case 22: 
            case 66: {
                buf.get();
                break;
            }
            case 16: 
            case 23: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                buf.getShort();
                break;
            }
            case 17: 
            case 18: {
                buf.get();
                buf.get();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 64: 
            case 65: {
                int length = buf.getShort();
                for (int i = 0; i < length; ++i) {
                    buf.getShort();
                    buf.getShort();
                    buf.getShort();
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                buf.getShort();
                buf.get();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid target info code");
            }
        }
        int endPos = buf.position();
        byte[] targetInfo = new byte[endPos - startPos];
        buf.position(startPos).get(targetInfo).position(endPos);
        return targetInfo;
    }

    private static byte[] extractLocationInfo(ByteBuffer buf) {
        int startPos = buf.position();
        int depth = buf.get() & 0xFF;
        for (int i = 0; i < depth; ++i) {
            buf.get();
            buf.get();
        }
        int endPos = buf.position();
        byte[] locationInfo = new byte[endPos - startPos];
        buf.position(startPos).get(locationInfo).position(endPos);
        return locationInfo;
    }

    static TypeAnnotationValue extract(ByteBuffer buf, ConstantPool cp, Class<?> container) {
        byte[] targetInfo = TypeAnnotationValue.extractTargetInfo(buf);
        byte[] locationInfo = TypeAnnotationValue.extractLocationInfo(buf);
        AnnotationValue annotation = AnnotationValue.extract(buf, cp, container, false, false);
        return new TypeAnnotationValue(targetInfo, locationInfo, annotation);
    }

    TypeAnnotationValue(byte[] targetInfo, byte[] locationInfo, AnnotationValue annotation) {
        this.targetInfo = targetInfo;
        this.locationInfo = locationInfo;
        this.annotation = annotation;
    }

    public byte[] getTargetInfo() {
        return this.targetInfo;
    }

    public byte[] getLocationInfo() {
        return this.locationInfo;
    }

    public AnnotationValue getAnnotationData() {
        return this.annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeAnnotationValue that = (TypeAnnotationValue)o;
        return Arrays.equals(this.targetInfo, that.targetInfo) && Arrays.equals(this.locationInfo, that.locationInfo) && Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        int result = Objects.hash(this.annotation);
        result = 31 * result + Arrays.hashCode(this.targetInfo);
        result = 31 * result + Arrays.hashCode(this.locationInfo);
        return result;
    }
}

