/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.Resource;
import jdk.internal.loader.URLClassPath;
import jdk.internal.module.Resources;

public final class NativeImageClassLoader
extends SecureClassLoader {
    private final ClassLoader parent;
    private final Map<String, ModuleReference> localNameToModule;
    private final Map<String, LoadedModule> localPackageToModule;
    private final Map<String, ClassLoader> remotePackageToLoader;
    private final ConcurrentHashMap<ModuleReference, ModuleReader> moduleToReader;
    private final URLClassPath ucp;

    NativeImageClassLoader(List<Path> classpath, Configuration configuration, ClassLoader parent) {
        super(parent);
        Objects.requireNonNull(parent);
        this.parent = parent;
        HashMap<String, ModuleReference> nameToModule = new HashMap<String, ModuleReference>();
        HashMap packageToModule = new HashMap();
        for (ResolvedModule resolvedModule : configuration.modules()) {
            ModuleReference mref = resolvedModule.reference();
            ModuleDescriptor descriptor = mref.descriptor();
            nameToModule.put(descriptor.name(), mref);
            descriptor.packages().forEach(pn -> {
                LoadedModule lm = new LoadedModule(mref);
                if (packageToModule.put(pn, lm) != null) {
                    throw new IllegalArgumentException("Package " + pn + " in more than one module");
                }
            });
        }
        this.localNameToModule = Collections.unmodifiableMap(nameToModule);
        this.localPackageToModule = Collections.unmodifiableMap(packageToModule);
        this.remotePackageToLoader = this.initRemotePackageMap(configuration, List.of(ModuleLayer.boot()));
        this.moduleToReader = new ConcurrentHashMap();
        this.ucp = new URLClassPath((URL[])classpath.stream().map(NativeImageClassLoader::toURL).toArray(URL[]::new), null);
    }

    public static URL toURL(Path p) {
        return NativeImageClassLoader.toURL(p.toUri());
    }

    public static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw UserError.abort(e, "Given URI '%s' cannot be expressed as URL.", uri);
        }
    }

    private Map<String, ClassLoader> initRemotePackageMap(Configuration cf, List<ModuleLayer> parentModuleLayers) {
        HashMap<String, ClassLoader> remotePackageMap = new HashMap<String, ClassLoader>();
        for (String name : this.localNameToModule.keySet()) {
            ResolvedModule resolvedModule = cf.findModule(name).get();
            assert (resolvedModule.configuration() == cf);
            for (ResolvedModule other : resolvedModule.reads()) {
                ModuleDescriptor descriptor;
                String mn = other.name();
                if (other.configuration() == cf) {
                    assert (this.localNameToModule.containsKey(mn));
                    continue;
                }
                ModuleLayer layer = (ModuleLayer)parentModuleLayers.stream().map(parentLayer -> NativeImageClassLoader.findModuleLayer(parentLayer, other.configuration())).flatMap(Optional::stream).findAny().orElseThrow(() -> new InternalError("Unable to find parent layer"));
                assert (layer.findModule(mn).isPresent());
                ClassLoader loader = layer.findLoader(mn);
                if (loader == null) {
                    loader = ClassLoaders.platformClassLoader();
                }
                if ((descriptor = other.reference().descriptor()).isAutomatic()) {
                    ClassLoader l = loader;
                    descriptor.packages().forEach(pn -> NativeImageClassLoader.remotePackage(remotePackageMap, pn, l));
                    continue;
                }
                String target = resolvedModule.name();
                for (ModuleDescriptor.Exports e : descriptor.exports()) {
                    boolean delegate = e.isQualified() ? other.configuration() == cf && e.targets().contains(target) : true;
                    if (!delegate) continue;
                    NativeImageClassLoader.remotePackage(remotePackageMap, e.source(), loader);
                }
            }
        }
        return Collections.unmodifiableMap(remotePackageMap);
    }

    private static void remotePackage(Map<String, ClassLoader> map, String pn, ClassLoader loader) {
        ClassLoader l = map.putIfAbsent(pn, loader);
        if (l != null && l != loader) {
            throw new IllegalStateException("Package " + pn + " cannot be imported from multiple loaders");
        }
    }

    private static Optional<ModuleLayer> findModuleLayer(ModuleLayer moduleLayer, Configuration cf) {
        return SharedSecrets.getJavaLangAccess().layers(moduleLayer).filter(l -> l.configuration() == cf).findAny();
    }

    @Override
    protected URL findResource(String mn, String name) throws IOException {
        if (mn == null) {
            return this.ucp.findResource(name);
        }
        ModuleReference mref = this.localNameToModule.get(mn);
        if (mref == null) {
            return null;
        }
        URL url = null;
        Optional<URI> ouri = this.moduleReaderFor(mref).find(name);
        if (ouri.isPresent()) {
            try {
                url = ouri.get().toURL();
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public URL findResource(String name) {
        String pn = Resources.toPackageName(name);
        URL urlOnClasspath = this.ucp.findResource(name);
        if (urlOnClasspath != null) {
            return urlOnClasspath;
        }
        LoadedModule module = this.localPackageToModule.get(pn);
        if (module != null) {
            try {
                URL url = this.findResource(module.name(), name);
                if (url != null && (name.endsWith(".class") || url.toString().endsWith("/") || NativeImageClassLoader.isOpen(module.mref(), pn))) {
                    return url;
                }
            }
            catch (IOException iOException) {}
        } else {
            for (ModuleReference mref : this.localNameToModule.values()) {
                try {
                    URL url = this.findResource(mref.descriptor().name(), name);
                    if (url == null) continue;
                    return url;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Collections.enumeration(this.findResourcesAsList(name));
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        final List<URL> urls = this.findResourcesAsList(name);
        final Enumeration<URL> e = this.parent.getResources(name);
        return new Enumeration<URL>(this){
            final Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext() || e.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return (URL)e.nextElement();
            }
        };
    }

    private List<URL> findResourcesAsList(String name) throws IOException {
        String pn = Resources.toPackageName(name);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration classPathResources = this.ucp.findResources(name);
        while (classPathResources.hasMoreElements()) {
            urls.add((URL)classPathResources.nextElement());
        }
        LoadedModule module = this.localPackageToModule.get(pn);
        if (module != null) {
            URL url = this.findResource(module.name(), name);
            if (url != null && (name.endsWith(".class") || url.toString().endsWith("/") || NativeImageClassLoader.isOpen(module.mref(), pn))) {
                urls.add(url);
            }
        } else {
            for (ModuleReference mref : this.localNameToModule.values()) {
                URL url = this.findResource(mref.descriptor().name(), name);
                if (url == null) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    @Override
    protected Class<?> findClass(String cn) throws ClassNotFoundException {
        LoadedModule loadedModule = this.findLoadedModule(cn);
        Class<?> c = loadedModule != null ? this.findClassInModuleOrNull(loadedModule, cn) : this.findClassViaClassPath(cn);
        if (c == null) {
            throw new ClassNotFoundException(cn);
        }
        return c;
    }

    private Class<?> findClassViaClassPath(String name) throws ClassNotFoundException {
        Class<?> result;
        String path = name.replace('.', '/').concat(".class");
        Resource res = this.ucp.getResource(path);
        if (res != null) {
            try {
                result = this.defineClass(name, res);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
            catch (ClassFormatError e2) {
                if (res.getDataError() != null) {
                    e2.addSuppressed(res.getDataError());
                }
                throw e2;
            }
        } else {
            return null;
        }
        return result;
    }

    private Class<?> defineClass(String name, Resource res) throws IOException {
        ByteBuffer bb;
        URL url;
        block6: {
            Manifest man;
            String pkgname;
            int i = name.lastIndexOf(46);
            url = res.getCodeSourceURL();
            if (i != -1 && this.getAndVerifyPackage(pkgname = name.substring(0, i), man = res.getManifest(), url) == null) {
                try {
                    if (man != null) {
                        this.definePackage(pkgname, man, url);
                    } else {
                        this.definePackage(pkgname, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (this.getAndVerifyPackage(pkgname, man, url) != null) break block6;
                    throw new AssertionError((Object)("Cannot find package " + pkgname));
                }
            }
        }
        if ((bb = res.getByteBuffer()) != null) {
            CodeSigner[] signers = res.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(name, bb, cs);
        }
        byte[] b = res.getBytes();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    private Package getAndVerifyPackage(String pkgname, Manifest man, URL url) {
        Package pkg = this.getDefinedPackage(pkgname);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("Sealing violation: package " + pkgname + " is sealed");
                }
            } else if (man != null && NativeImageClassLoader.isSealed(pkgname, man)) {
                throw new SecurityException("Sealing violation: can't seal package " + pkgname + ": already loaded");
            }
        }
        return pkg;
    }

    private Package definePackage(String name, Manifest man, URL url) {
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = SharedSecrets.javaUtilJarAccess().getTrustedAttributes(man, name.replace('.', '/').concat("/"));
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static boolean isSealed(String name, Manifest man) {
        Attributes attr = SharedSecrets.javaUtilJarAccess().getTrustedAttributes(man, name.replace('.', '/').concat("/"));
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    protected Class<?> findClass(String mn, String cn) {
        Class<?> c = null;
        LoadedModule loadedModule = this.findLoadedModule(cn);
        if (loadedModule != null && loadedModule.name().equals(mn)) {
            c = this.findClassInModuleOrNull(loadedModule, cn);
        } else {
            try {
                c = this.findClassViaClassPath(cn);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(cn);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(cn);
            if (c == null) {
                try {
                    c = this.parent.loadClass(cn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                LoadedModule loadedModule = this.findLoadedModule(cn);
                if (loadedModule != null) {
                    c = this.findClassInModuleOrNull(loadedModule, cn);
                } else {
                    c = this.findClassViaClassPath(cn);
                    if (c == null) {
                        String pn = NativeImageClassLoader.packageName(cn);
                        ClassLoader loader = this.remotePackageToLoader.get(pn);
                        if (loader == null) {
                            loader = this.parent;
                        }
                        c = loader.loadClass(cn);
                    }
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private Class<?> findClassInModuleOrNull(LoadedModule loadedModule, String cn) {
        return this.defineClass(cn, loadedModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String cn, LoadedModule loadedModule) {
        ModuleReader reader = this.moduleReaderFor(loadedModule.mref());
        String rn = cn.replace('.', '/').concat(".class");
        ByteBuffer bb = reader.read(rn).orElse(null);
        if (bb == null) {
            return null;
        }
        try {
            Class<?> clazz = this.defineClass(cn, bb, loadedModule.codeSource());
            reader.release(bb);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                reader.release(bb);
                throw throwable;
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    private LoadedModule findLoadedModule(String cn) {
        String pn = NativeImageClassLoader.packageName(cn);
        return pn.isEmpty() ? null : this.localPackageToModule.get(pn);
    }

    private static String packageName(String cn) {
        int pos = cn.lastIndexOf(46);
        return pos < 0 ? "" : cn.substring(0, pos);
    }

    private ModuleReader moduleReaderFor(ModuleReference mref) {
        return this.moduleToReader.computeIfAbsent(mref, m -> NativeImageClassLoader.createModuleReader(mref));
    }

    private static ModuleReader createModuleReader(ModuleReference mref) {
        try {
            return mref.open();
        }
        catch (IOException e) {
            return new NullModuleReader();
        }
    }

    private static boolean isOpen(ModuleReference mref, String pn) {
        ModuleDescriptor descriptor = mref.descriptor();
        if (descriptor.isOpen() || descriptor.isAutomatic()) {
            return true;
        }
        for (ModuleDescriptor.Opens opens : descriptor.opens()) {
            String source = opens.source();
            if (opens.isQualified() || !source.equals(pn)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class LoadedModule {
        private final ModuleReference mref;
        private final URL url;
        private final CodeSource cs;

        LoadedModule(ModuleReference mref) {
            URL urlVal = null;
            if (mref.location().isPresent()) {
                try {
                    urlVal = mref.location().get().toURL();
                }
                catch (IllegalArgumentException | MalformedURLException exception) {
                    // empty catch block
                }
            }
            this.mref = mref;
            this.url = urlVal;
            this.cs = new CodeSource(urlVal, (CodeSigner[])null);
        }

        ModuleReference mref() {
            return this.mref;
        }

        String name() {
            return this.mref.descriptor().name();
        }

        URL location() {
            return this.url;
        }

        CodeSource codeSource() {
            return this.cs;
        }
    }

    private static final class NullModuleReader
    implements ModuleReader {
        private NullModuleReader() {
        }

        @Override
        public Optional<URI> find(String name) {
            return Optional.empty();
        }

        @Override
        public Stream<String> list() {
            return Stream.empty();
        }

        @Override
        public void close() {
            throw new InternalError("Should not get here");
        }
    }
}

