/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ApplicationLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.LoadedLayeredImageSingletonInfo;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.RuntimeOnlyWrapper;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;

public final class ImageSingletonsSupportImpl
extends ImageSingletonsSupport
implements LayeredImageSingletonSupport {
    public <T> void add(Class<T> key, T value) {
        HostedManagement.getAndAssertExists().doAdd(key, value);
    }

    public <T> T lookup(Class<T> key) {
        return HostedManagement.getAndAssertExists().doLookup(key, false, false);
    }

    @Override
    public <T> T lookup(Class<T> key, boolean accessRuntimeOnly, boolean accessMultiLayer) {
        return HostedManagement.getAndAssertExists().doLookup(key, accessRuntimeOnly, accessMultiLayer);
    }

    @Override
    public Collection<Class<?>> getMultiLayeredImageSingletonKeys() {
        return HostedManagement.getAndAssertExists().getMultiLayeredImageSingletonKeys();
    }

    @Override
    public Collection<Class<?>> getFutureLayerAccessibleImageSingletonKeys() {
        return HostedManagement.getAndAssertExists().getFutureLayerAccessibleImageSingletonKeys();
    }

    @Override
    public void freezeLayeredImageSingletonMetadata() {
        HostedManagement.getAndAssertExists().freezeLayeredImageSingletonMetadata();
    }

    @Override
    public JavaConstant getInitialLayerOnlyImageSingleton(Class<?> key) {
        SVMImageLayerSingletonLoader loader = HostedImageLayerBuildingSupport.singleton().getSingletonLoader();
        return loader.loadInitialLayerOnlyImageSingleton(key);
    }

    public boolean contains(Class<?> key) {
        HostedManagement hm = HostedManagement.get();
        if (hm == null) {
            return false;
        }
        return hm.doContains(key);
    }

    public static final class HostedManagement {
        private static final Object SINGLETON_INSTALLATION_FORBIDDEN;
        private static HostedManagement singletonDuringImageBuild;
        private final Map<Class<?>, Object> configObjects = new ConcurrentHashMap();
        private final boolean checkUnsupported;
        private Set<Class<?>> multiLayeredImageSingletonKeys = ConcurrentHashMap.newKeySet();
        private Set<Class<?>> futureLayerAccessibleImageSingletonKeys = ConcurrentHashMap.newKeySet();

        private static HostedManagement getAndAssertExists() {
            HostedManagement result = HostedManagement.get();
            assert (result != null);
            return result;
        }

        public static HostedManagement get() {
            return singletonDuringImageBuild;
        }

        public static void install(HostedManagement vmConfig) {
            HostedManagement.install(vmConfig, null);
        }

        public static void install(HostedManagement vmConfig, HostedImageLayerBuildingSupport support) {
            UserError.guarantee(singletonDuringImageBuild == null, "Only one native image build can run at a time", new Object[0]);
            singletonDuringImageBuild = vmConfig;
            if (support != null) {
                singletonDuringImageBuild.doAddInternal(ImageLayerBuildingSupport.class, support);
            } else {
                singletonDuringImageBuild.doAddInternal(ImageLayerBuildingSupport.class, new ImageLayerBuildingSupport(false, false, false){});
            }
            if (support != null && support.getSingletonLoader() != null) {
                singletonDuringImageBuild.installPriorSingletonInfo(support.getSingletonLoader());
            } else {
                singletonDuringImageBuild.doAddInternal(LoadedLayeredImageSingletonInfo.class, new LoadedLayeredImageSingletonInfo(Set.of()));
            }
        }

        private void installPriorSingletonInfo(SVMImageLayerSingletonLoader info) {
            Map<Object, Set<Class<?>>> result = info.loadImageSingletons(SINGLETON_INSTALLATION_FORBIDDEN);
            HashSet installedKeys = new HashSet();
            for (Map.Entry<Object, Set<Class<?>>> entry : result.entrySet()) {
                Object singletonToInstall = entry.getKey();
                for (Class<?> key : entry.getValue()) {
                    this.doAddInternal(key, singletonToInstall);
                    installedKeys.add(key);
                }
            }
            this.doAddInternal(LoadedLayeredImageSingletonInfo.class, new LoadedLayeredImageSingletonInfo(Set.copyOf(installedKeys)));
        }

        public static void clear() {
            singletonDuringImageBuild = null;
        }

        private static Object stripRuntimeWrapper(Object singleton) {
            if (singleton instanceof RuntimeOnlyWrapper) {
                RuntimeOnlyWrapper r = (RuntimeOnlyWrapper)singleton;
                return r.wrappedObject();
            }
            return singleton;
        }

        public static void persist() {
            List<Map.Entry<Class<?>, Object>> list = HostedManagement.singletonDuringImageBuild.configObjects.entrySet().stream().filter(e -> HostedManagement.stripRuntimeWrapper(e.getValue()) instanceof LayeredImageSingleton).sorted(Comparator.comparing(e -> ((Class)e.getKey()).getName())).toList();
            HostedImageLayerBuildingSupport.singleton().getWriter().writeImageSingletonInfo(list);
        }

        public HostedManagement() {
            this(false);
        }

        public HostedManagement(boolean checkUnsupported) {
            this.checkUnsupported = checkUnsupported;
        }

        <T> void doAdd(Class<T> key, T value) {
            this.doAddInternal(key, value);
        }

        private void doAddInternal(Class<?> key, Object value) {
            Object prevValue;
            HostedManagement.checkKey(key);
            if (value == null) {
                throw UserError.abort("ImageSingletons do not allow null value for key %s", key.getTypeName());
            }
            Object storedValue = value;
            if (value instanceof LayeredImageSingleton) {
                InitialLayerOnlyImageSingleton initial;
                LayeredImageSingleton singleton = (LayeredImageSingleton)value;
                assert (LayeredImageSingletonBuilderFlags.verifyImageBuilderFlags(singleton));
                if (this.checkUnsupported && singleton.getImageBuilderFlags().contains((Object)LayeredImageSingletonBuilderFlags.UNSUPPORTED)) {
                    throw UserError.abort("Unsupported image singleton is being installed %s %s", key.getTypeName(), singleton);
                }
                if (singleton instanceof MultiLayeredImageSingleton || ApplicationLayerOnlyImageSingleton.isSingletonInstanceOf(singleton)) {
                    if (singleton instanceof MultiLayeredImageSingleton && ApplicationLayerOnlyImageSingleton.isSingletonInstanceOf(singleton)) {
                        throw UserError.abort("Singleton cannot implement both %s and %s. singleton: %s", MultiLayeredImageSingleton.class, ApplicationLayerOnlyImageSingleton.class, singleton);
                    }
                    if (ApplicationLayerOnlyImageSingleton.isSingletonInstanceOf(singleton) && !ImageLayerBuildingSupport.lastImageBuild()) {
                        throw UserError.abort("Application layer only image singleton can only be installed in the final layer: %s", singleton);
                    }
                    if (singleton instanceof MultiLayeredImageSingleton) {
                        this.multiLayeredImageSingletonKeys.add(key);
                    }
                }
                if (singleton instanceof InitialLayerOnlyImageSingleton && (initial = (InitialLayerOnlyImageSingleton)singleton).accessibleInFutureLayers()) {
                    this.futureLayerAccessibleImageSingletonKeys.add(key);
                }
                if (!singleton.getImageBuilderFlags().contains((Object)LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS)) {
                    storedValue = new RuntimeOnlyWrapper(singleton);
                }
            }
            if ((prevValue = this.configObjects.putIfAbsent(key, storedValue)) != null) {
                throw UserError.abort("ImageSingletons.add must not overwrite existing key %s%nExisting value: %s%nNew value: %s", key.getTypeName(), prevValue, value);
            }
        }

        Collection<Class<?>> getMultiLayeredImageSingletonKeys() {
            return this.multiLayeredImageSingletonKeys;
        }

        Collection<Class<?>> getFutureLayerAccessibleImageSingletonKeys() {
            return this.futureLayerAccessibleImageSingletonKeys;
        }

        void freezeLayeredImageSingletonMetadata() {
            this.multiLayeredImageSingletonKeys = Set.copyOf(this.multiLayeredImageSingletonKeys);
            this.futureLayerAccessibleImageSingletonKeys = Set.copyOf(this.futureLayerAccessibleImageSingletonKeys);
        }

        <T> T doLookup(Class<T> key, boolean stripRuntimeOnly, boolean allowMultiLayered) {
            HostedManagement.checkKey(key);
            Object result = this.configObjects.get(key);
            if (result == null) {
                List<String> others = this.configObjects.keySet().stream().filter(c -> c.getName().equals(key.getName())).map(c -> c.getClassLoader().getName() + "/" + c.getTypeName()).toList();
                if (others.isEmpty()) {
                    throw UserError.abort("ImageSingletons do not contain key %s", key.getTypeName());
                }
                throw UserError.abort("ImageSingletons do not contain key %s/%s but does contain the following key(s): %s", key.getClassLoader().getName(), key.getTypeName(), String.join((CharSequence)", ", others));
            }
            if (result == SINGLETON_INSTALLATION_FORBIDDEN) {
                throw UserError.abort("A LayeredImageSingleton was installed in a prior layer which forbids creating the singleton in a subsequent layer. Key %s", key.getTypeName());
            }
            if (result instanceof RuntimeOnlyWrapper) {
                RuntimeOnlyWrapper wrapper = (RuntimeOnlyWrapper)result;
                if (!stripRuntimeOnly) {
                    throw UserError.abort("A LayeredImageSingleton was accessed during image building which does not have %s access. Key: %s, object %s", new Object[]{LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS, key, wrapper.wrappedObject()});
                }
                result = wrapper.wrappedObject();
            }
            if (!allowMultiLayered && result instanceof MultiLayeredImageSingleton) {
                throw UserError.abort("Forbidden lookup of MultiLayeredImageSingleton. Use LayeredImageSingletonSupport.lookup if really necessary. Key: %s, object %s", key, result);
            }
            return key.cast(result);
        }

        boolean doContains(Class<?> key) {
            HostedManagement.checkKey(key);
            Object value = this.configObjects.get(key);
            return value != null && value != SINGLETON_INSTALLATION_FORBIDDEN;
        }

        private static void checkKey(Class<?> key) {
            if (key == null) {
                throw UserError.abort("ImageSingletons do not allow null keys", new Object[0]);
            }
        }

        static {
            ImageSingletonsSupportImpl.installSupport((ImageSingletonsSupport)new ImageSingletonsSupportImpl());
            SINGLETON_INSTALLATION_FORBIDDEN = new Object();
        }
    }
}

