/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.graal.meta.SubstrateMemoryAccessProvider;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordBase;

public final class SubstrateMemoryAccessProviderImpl
implements SubstrateMemoryAccessProvider {
    public static final SubstrateMemoryAccessProviderImpl SINGLETON = new SubstrateMemoryAccessProviderImpl();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private SubstrateMemoryAccessProviderImpl() {
    }

    public JavaConstant readObjectConstant(Constant baseConstant, long displacement) {
        return SubstrateMemoryAccessProviderImpl.readObjectChecked(baseConstant, displacement, null);
    }

    @Override
    public JavaConstant readNarrowObjectConstant(Constant baseConstant, long displacement, CompressEncoding encoding) {
        return SubstrateMemoryAccessProviderImpl.readObjectChecked(baseConstant, displacement, encoding);
    }

    private static JavaConstant readObjectChecked(Constant baseConstant, long displacement, CompressEncoding compressedEncoding) {
        if (compressedEncoding != null) {
            assert (ReferenceAccess.singleton().haveCompressedReferences());
            if (!compressedEncoding.equals((Object)ReferenceAccess.singleton().getCompressEncoding())) {
                return null;
            }
        }
        if (!(baseConstant instanceof SubstrateObjectConstant)) {
            return null;
        }
        Object baseObject = SubstrateObjectConstant.asObject(baseConstant);
        if (baseObject == null) {
            return null;
        }
        if (displacement <= 0L) {
            return null;
        }
        ResolvedJavaType baseObjectType = SubstrateMetaAccess.singleton().lookupJavaType((Class)baseObject.getClass());
        if (baseObjectType.isInstanceClass()) {
            SubstrateField field = baseObjectType.findInstanceFieldWithOffset(displacement, JavaKind.Object);
            if (field == null || field.getStorageKind() != JavaKind.Object) {
                return null;
            }
        } else if (baseObject instanceof Object[]) {
            int layoutEncoding = baseObjectType.getHub().getLayoutEncoding();
            assert (LayoutEncoding.isObjectArray(layoutEncoding));
            if (displacement < (long)LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding)) {
                return null;
            }
            if (Word.unsigned((long)displacement).aboveOrEqual(LayoutEncoding.getArrayElementOffset(layoutEncoding, ((Object[])baseObject).length))) {
                return null;
            }
            if ((displacement & (long)(LayoutEncoding.getArrayIndexScale(layoutEncoding) - 1)) != 0L) {
                return null;
            }
        } else {
            return null;
        }
        return SubstrateMemoryAccessProviderImpl.readObjectUnchecked(baseObject, displacement, compressedEncoding != null, false);
    }

    static JavaConstant readObjectUnchecked(Object baseObject, long displacement, boolean createCompressedConstant, boolean isVolatile) {
        Object rawValue = isVolatile ? BarrieredAccess.readObjectVolatile((Object)baseObject, (WordBase)Word.signed((long)displacement)) : BarrieredAccess.readObject((Object)baseObject, (WordBase)Word.signed((long)displacement));
        return SubstrateObjectConstant.forObject(rawValue, createCompressedConstant);
    }

    public JavaConstant readPrimitiveConstant(JavaKind kind, Constant baseConstant, long displacement, int bits) {
        return SubstrateMemoryAccessProviderImpl.readPrimitiveChecked(kind, baseConstant, displacement, bits);
    }

    private static JavaConstant readPrimitiveChecked(JavaKind kind, Constant baseConstant, long displacement, int bits) {
        if (!(baseConstant instanceof SubstrateObjectConstant)) {
            return null;
        }
        Object baseObject = SubstrateObjectConstant.asObject(baseConstant);
        if (baseObject == null) {
            return null;
        }
        if (displacement <= 0L) {
            return null;
        }
        if (Word.unsigned((long)(displacement + (long)(bits / 8))).aboveThan(LayoutEncoding.getMomentarySizeFromObject(baseObject))) {
            return null;
        }
        return SubstrateMemoryAccessProviderImpl.readPrimitiveUnchecked(kind, baseObject, displacement, bits, false);
    }

    static JavaConstant readPrimitiveUnchecked(JavaKind kind, Object baseObject, long displacement, int bits, boolean isVolatile) {
        SignedWord offset = Word.signed((long)displacement);
        return SubstrateMemoryAccessProviderImpl.toConstant(kind, switch (bits) {
            case 8 -> isVolatile ? (long)BarrieredAccess.readByteVolatile((Object)baseObject, (WordBase)offset) : (long)BarrieredAccess.readByte((Object)baseObject, (WordBase)offset);
            case 16 -> isVolatile ? (long)BarrieredAccess.readShortVolatile((Object)baseObject, (WordBase)offset) : (long)BarrieredAccess.readShort((Object)baseObject, (WordBase)offset);
            case 32 -> isVolatile ? (long)BarrieredAccess.readIntVolatile((Object)baseObject, (WordBase)offset) : (long)BarrieredAccess.readInt((Object)baseObject, (WordBase)offset);
            case 64 -> isVolatile ? BarrieredAccess.readLongVolatile((Object)baseObject, (WordBase)offset) : BarrieredAccess.readLong((Object)baseObject, (WordBase)offset);
            default -> throw VMError.shouldNotReachHereUnexpectedInput(bits);
        });
    }

    public static JavaConstant toConstant(JavaKind kind, long rawValue) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((rawValue != 0L ? 1 : 0) != 0);
            }
            case Byte: {
                return JavaConstant.forByte((byte)((byte)rawValue));
            }
            case Char: {
                return JavaConstant.forChar((char)((char)rawValue));
            }
            case Short: {
                return JavaConstant.forShort((short)((short)rawValue));
            }
            case Int: {
                return JavaConstant.forInt((int)((int)rawValue));
            }
            case Long: {
                return JavaConstant.forLong((long)rawValue);
            }
            case Float: {
                return JavaConstant.forFloat((float)Float.intBitsToFloat((int)rawValue));
            }
            case Double: {
                return JavaConstant.forDouble((double)Double.longBitsToDouble(rawValue));
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput(kind);
    }
}

