/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMemoryAccessProviderImpl;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.graal.meta.Target_java_lang_Integer_IntegerCache;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.SignedWord;

public class SubstrateConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final MetaAccessProvider metaAccess;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateConstantReflectionProvider(SubstrateMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public Integer identityHashCode(JavaConstant constant) {
        if (constant == null || constant.getJavaKind() != JavaKind.Object) {
            return null;
        }
        if (constant.isNull()) {
            return 0;
        }
        return ((SubstrateObjectConstant)constant).getIdentityHashCode();
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return SubstrateMemoryAccessProviderImpl.SINGLETON;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        Object obj;
        if (constant instanceof SubstrateObjectConstant && (obj = SubstrateObjectConstant.asObject(constant)) instanceof DynamicHub) {
            return ((SubstrateMetaAccess)this.metaAccess).lookupJavaTypeFromHub((DynamicHub)obj);
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return SubstrateObjectConstant.forObject(((SubstrateType)type).getHub());
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return SubstrateConstantReflectionProvider.readFieldValue((SubstrateField)field, receiver);
    }

    protected boolean canBoxPrimitive(JavaConstant source) {
        boolean result;
        boolean bl = result = source.getJavaKind().isPrimitive() && SubstrateConstantReflectionProvider.isCachedPrimitive(source);
        assert (!result || source.asBoxedPrimitive() == source.asBoxedPrimitive()) : "value must be cached";
        return result;
    }

    private static boolean isCachedPrimitive(JavaConstant source) {
        switch (source.getJavaKind()) {
            case Boolean: {
                return true;
            }
            case Char: {
                return source.asInt() <= 127;
            }
            case Byte: 
            case Short: {
                return source.asInt() >= -128 && source.asInt() <= 127;
            }
            case Int: {
                return source.asInt() >= -128 && source.asInt() <= Target_java_lang_Integer_IntegerCache.high;
            }
            case Long: {
                return source.asLong() >= -128L && source.asLong() <= 127L;
            }
            case Float: 
            case Double: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected kind " + String.valueOf(source.getJavaKind()));
    }

    public static JavaConstant readFieldValue(SubstrateField field, JavaConstant receiver) {
        Object baseObject;
        if (field.constantValue != null) {
            return field.constantValue;
        }
        int location = field.location;
        if (location < 0) {
            return null;
        }
        JavaKind kind = field.getStorageKind();
        if (field.isStatic()) {
            baseObject = kind.isObject() ? StaticFieldsSupport.getStaticObjectFieldsAtRuntime(field.getInstalledLayerNum()) : StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(field.getInstalledLayerNum());
        } else {
            if (receiver == null || !field.getDeclaringClass().isInstance(receiver)) {
                return null;
            }
            baseObject = SubstrateObjectConstant.asObject((Constant)receiver);
            if (baseObject == null) {
                return null;
            }
        }
        boolean isVolatile = field.isVolatile();
        JavaConstant result = kind.isObject() ? SubstrateMemoryAccessProviderImpl.readObjectUnchecked(baseObject, location, false, isVolatile) : SubstrateMemoryAccessProviderImpl.readPrimitiveUnchecked(kind, baseObject, location, kind.getByteCount() * 8, isVolatile);
        return result;
    }

    @Override
    public int getImageHeapOffset(JavaConstant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            return SubstrateConstantReflectionProvider.getImageHeapOffsetInternal((SubstrateObjectConstant)constant);
        }
        return 0;
    }

    protected static int getImageHeapOffsetInternal(SubstrateObjectConstant constant) {
        Object object = SubstrateObjectConstant.asObject((Constant)constant);
        assert (object != null);
        if (Heap.getHeap().isInPrimaryImageHeap(object)) {
            SignedWord base = (SignedWord)KnownIntrinsics.heapBase();
            Word offset = Word.objectToUntrackedPointer((Object)object).subtract(base);
            return NumUtil.safeToInt((long)offset.rawValue());
        }
        return 0;
    }
}

