/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalCompilerSupport;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.core.common.FieldIntrospection;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.graph.Edges;
import jdk.graal.compiler.graph.InputEdges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.SuccessorEdges;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class FieldsOffsetsFeature
implements Feature {
    protected static Map<long[], FieldsOffsetsReplacement> getReplacements() {
        return ((FieldsOffsetsReplacements)ImageSingletons.lookup(FieldsOffsetsReplacements.class)).replacements;
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageSingletons.add(FieldsOffsetsReplacements.class, (Object)new FieldsOffsetsReplacements());
        access.registerObjectReplacer(FieldsOffsetsFeature::replaceFieldsOffsets);
        access.registerClassReachabilityListener(FieldsOffsetsFeature::classReachabilityListener);
    }

    private static Object replaceFieldsOffsets(Object source) {
        FieldsOffsetsReplacement replacement;
        if (source instanceof Fields) {
            assert (!((FieldsOffsetsReplacements)ImageSingletons.lookup(FieldsOffsetsReplacements.class)).newValuesAvailable || FieldsOffsetsFeature.getReplacements().containsKey(((Fields)source).getOffsets())) : source;
        } else if (source instanceof long[] && (replacement = FieldsOffsetsFeature.getReplacements().get(source)) != null) {
            assert (source == replacement.fields.getOffsets());
            if (replacement.newOffsets != null) {
                return replacement.newOffsets;
            }
        }
        return source;
    }

    private static void classReachabilityListener(Feature.DuringAnalysisAccess a, Class<?> newlyReachableClass) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (BuildPhaseProvider.isAnalysisFinished()) {
            throw VMError.shouldNotReachHere("New class reachable after analysis: " + String.valueOf(newlyReachableClass));
        }
        if (Node.class.isAssignableFrom(newlyReachableClass) && newlyReachableClass != Node.class) {
            FieldsOffsetsFeature.registerClass(newlyReachableClass, GraalCompilerSupport.get().nodeClasses, NodeClass::get, false, access);
        } else if (LIRInstruction.class.isAssignableFrom(newlyReachableClass) && newlyReachableClass != LIRInstruction.class) {
            FieldsOffsetsFeature.registerClass(newlyReachableClass, GraalCompilerSupport.get().instructionClasses, LIRInstructionClass::get, true, access);
        }
    }

    private static <R extends FieldIntrospection<?>> void registerClass(Class<?> clazz, EconomicMap<Class<?>, R> registry, Function<Class<?>, R> lookup, boolean excludeAbstract, FeatureImpl.DuringAnalysisAccessImpl access) {
        assert (!registry.containsKey(clazz));
        if (!excludeAbstract || !Modifier.isAbstract(clazz.getModifiers())) {
            FieldIntrospection nodeClass = (FieldIntrospection)lookup.apply(clazz);
            registry.put(clazz, (Object)nodeClass);
            FieldsOffsetsFeature.registerFields(nodeClass, access);
            access.requireAnalysisIteration();
        }
    }

    private static void registerFields(FieldIntrospection<?> introspection, FeatureImpl.BeforeAnalysisAccessImpl config) {
        if (introspection instanceof NodeClass) {
            NodeClass nodeClass = (NodeClass)introspection;
            AnalysisType nodeType = config.getMetaAccess().lookupJavaType(nodeClass.getJavaClass());
            nodeType.registerInstantiatedCallback(unused -> config.registerAsUnsafeAllocated(nodeType));
            Fields dataFields = nodeClass.getData();
            FieldsOffsetsFeature.registerFields(dataFields, config, "Graal node data field");
            InputEdges inputEdges = nodeClass.getInputEdges();
            FieldsOffsetsFeature.registerFields((Fields)inputEdges, config, "Graal node input edge");
            SuccessorEdges successorEdges = nodeClass.getSuccessorEdges();
            FieldsOffsetsFeature.registerFields((Fields)successorEdges, config, "Graal node successor edge");
            nodeClass.shortName();
        } else {
            for (Fields fields : introspection.getAllFields()) {
                FieldsOffsetsFeature.registerFields(fields, config, "Graal field");
            }
        }
    }

    private static void registerFields(Fields fields, FeatureImpl.BeforeAnalysisAccessImpl config, Object reason) {
        FieldsOffsetsFeature.getReplacements().put(fields.getOffsets(), new FieldsOffsetsReplacement(fields));
        for (int i = 0; i < fields.getCount(); ++i) {
            AnalysisField aField = config.getMetaAccess().lookupJavaField(FieldsOffsetsFeature.findField(fields, i));
            aField.getType().registerAsReachable((Object)aField);
            config.registerAsUnsafeAccessed(aField, reason);
        }
    }

    private static Field findField(Fields fields, int index) {
        return fields.getField(index);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        for (FieldsOffsetsReplacement replacement : FieldsOffsetsFeature.getReplacements().values()) {
            Map.Entry e = replacement.fields.recomputeOffsetsAndIterationMask(arg_0 -> ((Feature.BeforeCompilationAccess)a).objectFieldOffset(arg_0));
            replacement.newOffsets = (long[])e.getKey();
            replacement.newIterationInitMask = (Long)e.getValue();
        }
        ((FieldsOffsetsReplacements)ImageSingletons.lookup(FieldsOffsetsReplacements.class)).newValuesAvailable = true;
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        access.registerAsImmutable((Object)GraalCompilerSupport.get().nodeClasses.getValues(), o -> true);
        access.registerAsImmutable((Object)GraalCompilerSupport.get().instructionClasses.getValues(), o -> true);
    }

    static class FieldsOffsetsReplacements {
        protected final Map<long[], FieldsOffsetsReplacement> replacements = new IdentityHashMap<long[], FieldsOffsetsReplacement>();
        protected boolean newValuesAvailable;

        FieldsOffsetsReplacements() {
        }
    }

    static class FieldsOffsetsReplacement {
        protected final Fields fields;
        protected long[] newOffsets;
        protected long newIterationInitMask;

        protected FieldsOffsetsReplacement(Fields fields) {
            this.fields = fields;
        }
    }

    public static class IterationMaskRecomputation
    implements FieldValueTransformerWithAvailability {
        @Override
        public boolean isAvailable() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }

        public Object transform(Object receiver, Object originalValue) {
            Edges edges = (Edges)receiver;
            FieldsOffsetsReplacement replacement = FieldsOffsetsFeature.getReplacements().get(edges.getOffsets());
            assert (replacement.fields == edges);
            assert (replacement.newOffsets != null) : "Cannot access iteration mask before field offsets are assigned";
            return replacement.newIterationInitMask;
        }
    }
}

