/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.PlatformTimeUtils;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;

@AutomaticallyRegisteredImageSingleton(value={PlatformTimeUtils.class})
public final class WindowsPlatformTimeUtils
extends PlatformTimeUtils {
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/os/windows/os_windows.cpp#L1123")
    private static final long OFFSET = 116444736000000000L;

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/os/windows/os_windows.cpp#L1153-L1155")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long offset() {
        return 116444736000000000L;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/os/windows/os_windows.cpp#L1158-L1161")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long windowsToTimeTicks(WinBase.FILETIME wt) {
        long a = Word.unsigned((int)wt.dwHighDateTime()).shiftLeft(32).or(Word.unsigned((int)wt.dwLowDateTime())).rawValue();
        return a - WindowsPlatformTimeUtils.offset();
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+3/src/hotspot/os/windows/os_windows.cpp#L1198-L1205")
    @Uninterruptible(reason="Must not migrate platform threads when executing on a virtual thread.")
    public PlatformTimeUtils.SecondsNanos javaTimeSystemUTC() {
        WinBase.FILETIME wt = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class);
        SysinfoAPI.GetSystemTimeAsFileTime(wt);
        long ticks = WindowsPlatformTimeUtils.windowsToTimeTicks(wt);
        long secs = ticks / 10000000L;
        long nanos = (ticks - secs * 10000000L) * 100L;
        return WindowsPlatformTimeUtils.allocateSecondsNanosInterruptibly(secs, nanos);
    }
}

