/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class NonmovableByteArrayReader {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer pointerTo(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            throw VMError.shouldNotReachHere("Returns a raw pointer and therefore must not be called at image build time.");
        }
        assert (byteIndex >= 0L && byteIndex == (long)((int)byteIndex));
        assert (byteIndex < (long)NonmovableArrays.lengthOf(data));
        Pointer result = ((Pointer)data).add(NonmovableByteArrayReader.getByteArrayBaseOffset()).add((int)byteIndex);
        assert (result.equal((UnsignedWord)NonmovableArrays.addressOf(data, (int)byteIndex))) : "sanity check that the optimized code above does the right thing";
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS1(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS1((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readByte(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS2(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS2((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readShort(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS4(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS4((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readInt(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getS8(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS8((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readLong(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getU1(NonmovableArray<Byte> data, long byteIndex) {
        return NonmovableByteArrayReader.getS1(data, byteIndex) & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getU2(NonmovableArray<Byte> data, long byteIndex) {
        return NonmovableByteArrayReader.getS2(data, byteIndex) & 0xFFFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getU4(NonmovableArray<Byte> data, long byteIndex) {
        return (long)NonmovableByteArrayReader.getS4(data, byteIndex) & 0xFFFFFFFFL;
    }

    @Fold
    protected static int getByteArrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
    }
}

