/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.riscv64;

import com.oracle.svm.core.CPUFeatureAccessImpl;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.riscv64.RISCV64LibCHelper;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;

public class RISCV64CPUFeatureAccess
extends CPUFeatureAccessImpl {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RISCV64CPUFeatureAccess(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        super(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }

    @Platforms(value={Platform.RISCV64.class})
    public EnumSet<RISCV64.CPUFeature> determineHostCPUFeatures() {
        EnumSet<RISCV64.CPUFeature> features = EnumSet.noneOf(RISCV64.CPUFeature.class);
        RISCV64LibCHelper.CPUFeatures cpuFeatures = UnsafeStackValue.get(RISCV64LibCHelper.CPUFeatures.class);
        UnmanagedMemoryUtil.fill((Pointer)cpuFeatures, SizeOf.unsigned(RISCV64LibCHelper.CPUFeatures.class), (byte)0);
        RISCV64LibCHelper.determineCPUFeatures(cpuFeatures);
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (RISCV64.CPUFeature feature : RISCV64.CPUFeature.values()) {
            if (!this.isFeaturePresent((Enum<?>)feature, (Pointer)cpuFeatures, (List<String>)unknownFeatures)) continue;
            features.add(feature);
        }
        if (!unknownFeatures.isEmpty()) {
            throw VMError.shouldNotReachHere("Native image does not support the following JVMCI CPU features: " + String.valueOf(unknownFeatures));
        }
        return features;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public int verifyHostSupportsArchitectureEarly() {
        return RISCV64LibCHelper.checkCPUFeatures((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get());
    }

    @Override
    @Uninterruptible(reason="Thread state not set up yet.")
    public void verifyHostSupportsArchitectureEarlyOrExit() {
        RISCV64LibCHelper.checkCPUFeaturesOrExit((CCharPointer)BUILDTIME_CPU_FEATURE_MASK.get(), (CCharPointer)IMAGE_CPU_FEATURE_ERROR_MSG.get());
    }

    @Override
    public void enableFeatures(Architecture runtimeArchitecture, LoweringProvider runtimeLowerer) {
        RISCV64 architecture = (RISCV64)runtimeArchitecture;
        EnumSet<RISCV64.CPUFeature> features = this.determineHostCPUFeatures();
        architecture.getFeatures().addAll(features);
    }
}

