/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.reflect.UnsafeFieldUtil;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Field;
import java.lang.reflect.Field;

@TargetClass(className="jdk.internal.misc.Unsafe")
public final class Target_jdk_internal_misc_Unsafe_Reflection {
    @Substitute
    public long objectFieldOffset(Target_java_lang_reflect_Field field) {
        return UnsafeFieldUtil.getFieldOffset(field);
    }

    @Substitute
    public long staticFieldOffset(Target_java_lang_reflect_Field field) {
        return UnsafeFieldUtil.getFieldOffset(field);
    }

    @Substitute
    public Object staticFieldBase(Target_java_lang_reflect_Field field) {
        int layerNumber;
        if (field == null) {
            throw new NullPointerException();
        }
        int n = layerNumber = ImageLayerBuildingSupport.buildingImageLayer() ? field.installedLayerNumber : -1;
        if (SubstrateUtil.cast(field, Field.class).getType().isPrimitive()) {
            return StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(layerNumber);
        }
        return StaticFieldsSupport.getStaticObjectFieldsAtRuntime(layerNumber);
    }

    @Substitute
    public long objectFieldOffset(Class<?> c, String name) {
        if (c == null || name == null) {
            throw new NullPointerException();
        }
        try {
            Field field = c.getDeclaredField(name);
            Target_java_lang_reflect_Field cast = SubstrateUtil.cast(field, Target_java_lang_reflect_Field.class);
            return this.objectFieldOffset(cast);
        }
        catch (NoSuchFieldException nse) {
            throw new InternalError();
        }
    }
}

