/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.posix.headers.Semaphore;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class LinuxVMSemaphore
extends VMSemaphore {
    private final CIsolateData<Semaphore.sem_t> structPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    LinuxVMSemaphore(String name) {
        super(name);
        this.structPointer = CIsolateDataFactory.createStruct("linuxSemaphore_" + name, Semaphore.sem_t.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Semaphore.sem_t getStructPointer() {
        return this.structPointer.get();
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        return Semaphore.NoTransitions.sem_init(this.getStructPointer(), Word.signed((int)0), Word.unsigned((int)0));
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        return Semaphore.NoTransitions.sem_destroy(this.getStructPointer());
    }

    @Override
    public void await() {
        PthreadVMLockSupport.checkResult(Semaphore.sem_wait(this.getStructPointer()), "sem_wait");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        PthreadVMLockSupport.checkResult(Semaphore.NoTransitions.sem_post(this.getStructPointer()), "sem_post");
    }
}

