/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.AllowNarrowingCast;
import org.graalvm.nativeimage.c.struct.AllowWideningCast;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class Time {
    @CConstant
    public static native int CLOCK_REALTIME();

    public static class NoTransitions {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int setitimer(TimerTypeEnum var0, itimerval var1, itimerval var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int gettimeofday(timeval var0, timezone var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native tm localtime_r(CLongPointer var0, tm var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int nanosleep(timespec var0, timespec var1);
    }

    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum TimerTypeEnum {
        ITIMER_REAL,
        ITIMER_VIRTUAL,
        ITIMER_PROF;


        @CEnumValue
        public native int getCValue();
    }

    @CStruct(addStructKeyword=true)
    public static interface tm
    extends PointerBase {
    }

    @CStruct(addStructKeyword=true)
    public static interface itimerval
    extends PointerBase {
        @CFieldAddress
        public timeval it_interval();

        @CFieldAddress
        public timeval it_value();
    }

    @CStruct(addStructKeyword=true)
    public static interface timespec
    extends PointerBase {
        @CField
        public long tv_sec();

        @CField
        public void set_tv_sec(long var1);

        @CField
        public long tv_nsec();

        @CField
        public void set_tv_nsec(long var1);
    }

    public static interface timezone
    extends PointerBase {
    }

    @CStruct(addStructKeyword=true)
    public static interface timeval
    extends PointerBase {
        @CField
        public long tv_sec();

        @CFieldAddress
        public CLongPointer addressOftv_sec();

        @CField
        public void set_tv_sec(long var1);

        @CField
        @AllowWideningCast
        public long tv_usec();

        @CField
        @AllowNarrowingCast
        public void set_tv_usec(long var1);

        public timeval addressOf(int var1);
    }
}

