/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.PosixSubstrateSigprofHandler;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.util.TimeUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class PosixSubstrateGlobalSigprofHandler
extends PosixSubstrateSigprofHandler {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixSubstrateGlobalSigprofHandler() {
    }

    @Override
    protected void updateInterval() {
        PosixSubstrateGlobalSigprofHandler.updateInterval(TimeUtils.millisToMicros(this.newIntervalMillis));
    }

    private static void updateInterval(long us) {
        Time.itimerval newValue = UnsafeStackValue.get(Time.itimerval.class);
        newValue.it_value().set_tv_sec(us / 1000000L);
        newValue.it_value().set_tv_usec(us % 1000000L);
        newValue.it_interval().set_tv_sec(us / 1000000L);
        newValue.it_interval().set_tv_usec(us % 1000000L);
        int status = Time.NoTransitions.setitimer(Time.TimerTypeEnum.ITIMER_PROF, newValue, (Time.itimerval)Word.nullPointer());
        PosixUtils.checkStatusIs0(status, "setitimer(which, newValue, oldValue): wrong arguments.");
    }

    @Override
    protected void installSignalHandler() {
        super.installSignalHandler();
        this.updateInterval();
    }

    @Override
    protected void uninstallSignalHandler() {
        PosixSubstrateGlobalSigprofHandler.updateInterval(0L);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void install0(IsolateThread thread) {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void uninstall0(IsolateThread thread) {
    }
}

