/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.BaseProcessPropertiesSupport;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Stdlib;
import com.oracle.svm.core.posix.headers.Unistd;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public abstract class PosixProcessPropertiesSupport
extends BaseProcessPropertiesSupport {
    public long getProcessID() {
        return PosixUtils.getpid();
    }

    public long getProcessID(Process process) {
        return PosixUtils.getpid(process);
    }

    public boolean destroy(long processID) {
        return Signal.kill(Math.toIntExact(processID), Signal.SignalEnum.SIGTERM.getCValue()) == 0;
    }

    public boolean destroyForcibly(long processID) {
        return Signal.kill(Math.toIntExact(processID), Signal.SignalEnum.SIGKILL.getCValue()) == 0;
    }

    public boolean isAlive(long processID) {
        return Signal.kill(Math.toIntExact(processID), 0) == 0;
    }

    public int waitForProcessExit(long processID) {
        return PosixUtils.waitForProcessExit(Math.toIntExact(processID));
    }

    public String getObjectFile(String symbol) {
        try (CTypeConversion.CCharPointerHolder symbolHolder = CTypeConversion.toCString((CharSequence)symbol);){
            Object symbolAddress = Dlfcn.dlsym(Dlfcn.RTLD_DEFAULT(), symbolHolder.get());
            if (symbolAddress.isNull()) {
                String string = null;
                return string;
            }
            String string = this.getObjectFile((PointerBase)symbolAddress);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectFile(PointerBase symbolAddress) {
        Dlfcn.Dl_info info = UnsafeStackValue.get(Dlfcn.Dl_info.class);
        if (Dlfcn.dladdr((WordBase)symbolAddress, info) == 0) {
            return null;
        }
        CCharPointer realpath = Stdlib.realpath(info.dli_fname(), (CCharPointer)Word.nullPointer());
        if (realpath.isNull()) {
            return null;
        }
        try {
            String string = CTypeConversion.toJavaString((CCharPointer)realpath);
            return string;
        }
        finally {
            LibC.free((PointerBase)realpath);
        }
    }

    public String setLocale(String category, String locale) {
        return PosixUtils.setLocale(category, locale);
    }

    public void exec(Path executable, String[] args) {
        if (!Files.isExecutable(executable)) {
            throw new RuntimeException("Path " + String.valueOf(executable) + " does not point to executable file");
        }
        try (CTypeConversion.CCharPointerHolder pathHolder = CTypeConversion.toCString((CharSequence)executable.toString());
             CTypeConversion.CCharPointerPointerHolder argvHolder = CTypeConversion.toCStrings((CharSequence[])args);){
            if (Unistd.execv(pathHolder.get(), argvHolder.get()) != 0) {
                String msg = PosixUtils.lastErrorString("Executing " + String.valueOf(executable) + " with arguments " + String.join((CharSequence)" ", args) + " failed");
                throw new RuntimeException(msg);
            }
        }
    }

    public void exec(Path executable, String[] args, Map<String, String> env) {
        if (!Files.isExecutable(executable)) {
            throw new RuntimeException("Path " + String.valueOf(executable) + " does not point to executable file");
        }
        CharSequence[] envArray = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e2 : env.entrySet()) {
            envArray[i++] = e2.getKey() + "=" + e2.getValue();
        }
        try (CTypeConversion.CCharPointerHolder pathHolder = CTypeConversion.toCString((CharSequence)executable.toString());
             CTypeConversion.CCharPointerPointerHolder argvHolder = CTypeConversion.toCStrings((CharSequence[])args);
             CTypeConversion.CCharPointerPointerHolder envpHolder = CTypeConversion.toCStrings((CharSequence[])envArray);){
            if (Unistd.execve(pathHolder.get(), argvHolder.get(), envpHolder.get()) != 0) {
                String envString = env.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" "));
                String msg = PosixUtils.lastErrorString("Executing " + String.valueOf(executable) + " with arguments " + String.join((CharSequence)" ", args) + " and environment " + envString + " failed");
                throw new RuntimeException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String realpath(String path) {
        try (CTypeConversion.CCharPointerHolder pathHolder = CTypeConversion.toCString((CharSequence)path);){
            String string;
            CCharPointer realpath = Stdlib.realpath(pathHolder.get(), (CCharPointer)Word.nullPointer());
            if (realpath.isNull()) {
                String string2 = null;
                return string2;
            }
            try {
                string = CTypeConversion.toJavaString((CCharPointer)realpath);
            }
            catch (Throwable throwable) {
                LibC.free((PointerBase)realpath);
                throw throwable;
            }
            LibC.free((PointerBase)realpath);
            return string;
        }
    }
}

