/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.jdk.LoadAverageSupport;
import com.oracle.svm.core.posix.headers.Stdlib;
import org.graalvm.nativeimage.c.type.CDoublePointer;

@AutomaticallyRegisteredImageSingleton(value={LoadAverageSupport.class})
class PosixLoadAverageSupport
implements LoadAverageSupport {
    PosixLoadAverageSupport() {
    }

    @Override
    public int getLoadAverage(double[] loadavg, int nelems) {
        try (PrimitiveArrayView refLoadavg = PrimitiveArrayView.createForReadingAndWriting(loadavg);){
            int n = Stdlib.getloadavg((CDoublePointer)refLoadavg.addressOfArrayElement(0), nelems);
            return n;
        }
    }
}

