/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.pltgot.aarch64;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.DeoptimizationSlotPacking;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.pltgot.ExitMethodAddressResolutionNode;
import com.oracle.svm.core.pltgot.MethodAddressResolutionDispatcher;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public final class AArch64MethodAddressResolutionDispatcher
extends MethodAddressResolutionDispatcher {
    @StubCallingConvention
    @Uninterruptible(reason="PLT/GOT method address resolution doesn't support interruptible code paths.")
    @NeverInline(value="This method must never be inlined or called directly because we only jump to it from the PLT stub.")
    public static void resolveMethodAddress() {
        Pointer paddingSlot = KnownIntrinsics.readCallerStackPointer();
        long gotEntry = DeoptimizationSlotPacking.decodeGOTIndex(paddingSlot.readWord(0).rawValue());
        long resolvedMethodAddress = MethodAddressResolutionDispatcher.resolveMethodAddress(gotEntry);
        ExitMethodAddressResolutionNode.exitMethodAddressResolution((CodePointer)Word.pointer((long)resolvedMethodAddress));
        throw UnreachableNode.unreachable();
    }
}

