/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;

public class OptionUtils {
    public static List<String> resolveOptionValuesRedirection(OptionKey<?> option, LocatableMultiOptionValue.ValueWithOrigin<String> valueWithOrigin) {
        return OptionUtils.resolveOptionValuesRedirection(option, valueWithOrigin.value(), valueWithOrigin.origin());
    }

    public static List<String> resolveOptionValuesRedirection(OptionKey<?> option, String optionValue, OptionOrigin origin) {
        return Arrays.stream(SubstrateUtil.split(optionValue, ",")).flatMap(entry -> OptionUtils.resolveOptionValueRedirection(option, optionValue, origin, entry)).collect(Collectors.toList());
    }

    private static Stream<? extends String> resolveOptionValueRedirection(OptionKey<?> option, String optionValue, OptionOrigin origin, String entry) {
        if (entry.trim().startsWith("@")) {
            Path valuesFile = Path.of(entry.substring(1), new String[0]);
            if (valuesFile.isAbsolute()) {
                throw new AssertionError((Object)("Option '" + SubstrateOptionsParser.commandArgument(option, optionValue) + "' provided by " + String.valueOf(origin) + " contains value redirection file '" + String.valueOf(valuesFile) + "' that is an absolute path."));
            }
            try {
                return origin.getRedirectionValues(valuesFile).stream();
            }
            catch (IOException e) {
                throw new AssertionError("Option '" + SubstrateOptionsParser.commandArgument(option, optionValue) + "' provided by " + String.valueOf(origin) + " contains invalid option value redirection.", e);
            }
        }
        return Stream.of(entry);
    }

    public static <T extends Annotation> List<T> getAnnotationsByType(OptionDescriptor optionDescriptor, Class<T> annotationClass) {
        try {
            Field field = optionDescriptor.getDeclaringClass().getDeclaredField(optionDescriptor.getFieldName());
            return List.of(field.getAnnotationsByType(annotationClass));
        }
        catch (NoSuchFieldException e) {
            return List.of();
        }
    }

    public static final class InvalidMacroException
    extends RuntimeException {
        public InvalidMacroException(String arg0) {
            super(arg0);
        }
    }

    public static enum MacroOptionKind {
        Language("languages", true),
        Tool("tools", true),
        Macro("macros", false);

        public static final String macroOptionPrefix = "--";
        public final String subdir;
        public final boolean allowAll;

        private MacroOptionKind(String subdir, boolean allowAll) {
            this.subdir = subdir;
            this.allowAll = allowAll;
        }

        public static MacroOptionKind fromSubdir(String subdir) {
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                if (!kind.subdir.equals(subdir)) continue;
                return kind;
            }
            throw new InvalidMacroException("No MacroOptionKind for subDir: " + subdir);
        }

        public static MacroOptionKind fromString(String kindName) {
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                if (!kind.toString().equals(kindName)) continue;
                return kind;
            }
            throw new InvalidMacroException("No MacroOptionKind for kindName: " + kindName);
        }

        public String getDescriptionPrefix(boolean commandLineStyle) {
            StringBuilder sb = new StringBuilder();
            if (commandLineStyle) {
                sb.append(macroOptionPrefix);
            }
            sb.append((Object)this).append(":");
            return sb.toString();
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

