/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class LocatableMultiOptionValue<T>
implements MultiOptionValue<T> {
    protected static final String NO_DELIMITER = "";
    private final String delimiter;
    protected final Class<T> valueType;
    protected final List<ValueWithOrigin<T>> values;

    protected LocatableMultiOptionValue(Class<T> valueType, String delimiter, List<T> defaults) {
        this.valueType = valueType;
        this.delimiter = delimiter;
        this.values = new ArrayList<ValueWithOrigin<T>>();
        this.values.addAll(defaults.stream().map(val -> new ValueWithOrigin<Object>(val, OptionOrigin.from(null))).collect(Collectors.toList()));
    }

    protected LocatableMultiOptionValue(LocatableMultiOptionValue<T> other) {
        this.valueType = other.valueType;
        this.delimiter = other.delimiter;
        this.values = new ArrayList<ValueWithOrigin<T>>(other.values);
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public List<T> values() {
        return this.getValuesWithOrigins().map(ValueWithOrigin::value).collect(Collectors.toList());
    }

    public Set<T> valuesAsSet() {
        return this.getValuesWithOrigins().map(ValueWithOrigin::value).collect(Collectors.toSet());
    }

    public Optional<T> lastValue() {
        return this.lastValueWithOrigin().map(ValueWithOrigin::value);
    }

    public Optional<ValueWithOrigin<T>> lastValueWithOrigin() {
        return this.values.isEmpty() ? Optional.empty() : Optional.of(this.values.getLast());
    }

    public Stream<ValueWithOrigin<T>> getValuesWithOrigins() {
        return this.values.stream();
    }

    public String toString() {
        return "<" + ClassUtil.getUnqualifiedName(this.valueType).toLowerCase(Locale.ROOT) + ">*";
    }

    public record ValueWithOrigin<T>(T value, OptionOrigin origin) {
    }
}

