/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nodes;

import com.oracle.svm.core.nodes.CFunctionPrologueMarker;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8, allowedUsageTypes={InputType.Memory})
public final class CFunctionPrologueNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill,
ControlFlowAnchored,
DeoptimizingNode.DeoptBefore,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<CFunctionPrologueNode> TYPE = NodeClass.create(CFunctionPrologueNode.class);
    private final int newThreadStatus;
    private CFunctionPrologueMarker marker;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;

    public CFunctionPrologueNode(int newThreadStatus) {
        super(TYPE, StampFactory.forVoid());
        this.newThreadStatus = newThreadStatus;
    }

    protected void afterClone(Node other) {
        super.afterClone(other);
        assert (this.marker == null) : "Marker must be unique";
    }

    public CFunctionPrologueMarker getMarker() {
        if (this.marker == null) {
            this.marker = new CFunctionPrologueMarker(this.newThreadStatus);
        }
        return this.marker;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public int getNewThreadStatus() {
        return this.newThreadStatus;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public void setStateBefore(FrameState x) {
        this.updateUsages((Node)this.stateBefore, (Node)x);
        this.stateBefore = x;
    }

    public boolean canDeoptimize() {
        return true;
    }

    @Node.NodeIntrinsic
    public static native void cFunctionPrologue(@Node.ConstantNodeParameter int var0);
}

