/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.JNIThreadLocalEnvironment;
import com.oracle.svm.core.jvmti.JvmtiEnv;
import com.oracle.svm.core.jvmti.JvmtiEnvUtil;
import com.oracle.svm.core.jvmti.JvmtiEnvs;
import com.oracle.svm.core.jvmti.headers.JThread;
import com.oracle.svm.core.jvmti.headers.JvmtiEvent;
import com.oracle.svm.core.jvmti.headers.JvmtiEventCallbacks;

public final class JvmtiEvents {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postVMInit() {
        JvmtiEnvs manager = JvmtiEnvs.singleton();
        manager.enterEnvIteration();
        try {
            JvmtiEnv cur = manager.getHead();
            while (cur.isNonNull()) {
                JvmtiEventCallbacks.JvmtiEventVMInitFunctionPointer callback;
                if (JvmtiEnvUtil.isEventEnabled(cur, JvmtiEvent.JVMTI_EVENT_VM_INIT) && (callback = JvmtiEnvUtil.getEventCallbacks(cur).getVMInit()).isNonNull()) {
                    JThread currentThread = (JThread)JNIObjectHandles.createLocal(Thread.currentThread());
                    try {
                        callback.invoke(JvmtiEnvUtil.toExternal(cur), JNIThreadLocalEnvironment.getAddress(), currentThread);
                    }
                    finally {
                        JNIObjectHandles.deleteLocalRef(currentThread);
                    }
                }
                cur = cur.getNext();
            }
        }
        finally {
            manager.leaveEnvIteration();
        }
    }

    public static void postVMStart() {
        JvmtiEnvs manager = JvmtiEnvs.singleton();
        manager.enterEnvIteration();
        try {
            JvmtiEnv cur = manager.getHead();
            while (cur.isNonNull()) {
                JvmtiEventCallbacks.JvmtiEventVMStartFunctionPointer callback;
                if (JvmtiEnvUtil.isEventEnabled(cur, JvmtiEvent.JVMTI_EVENT_VM_START) && (callback = JvmtiEnvUtil.getEventCallbacks(cur).getVMStart()).isNonNull()) {
                    callback.invoke(JvmtiEnvUtil.toExternal(cur), JNIThreadLocalEnvironment.getAddress());
                }
                cur = cur.getNext();
            }
        }
        finally {
            manager.leaveEnvIteration();
        }
    }

    public static void postVMDeath() {
        JvmtiEnvs manager = JvmtiEnvs.singleton();
        manager.enterEnvIteration();
        try {
            JvmtiEnv cur = manager.getHead();
            while (cur.isNonNull()) {
                JvmtiEventCallbacks.JvmtiEventVMDeathFunctionPointer callback;
                if (JvmtiEnvUtil.isEventEnabled(cur, JvmtiEvent.JVMTI_EVENT_VM_DEATH) && (callback = JvmtiEnvUtil.getEventCallbacks(cur).getVMDeath()).isNonNull()) {
                    callback.invoke(JvmtiEnvUtil.toExternal(cur), JNIThreadLocalEnvironment.getAddress());
                }
                cur = cur.getNext();
            }
        }
        finally {
            manager.leaveEnvIteration();
        }
    }
}

