/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jni.MissingJNIRegistrationUtils;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.core.util.VMError;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.util.SignatureUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class JNIReflectionDictionary
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    static final Equivalence WRAPPED_CSTRING_EQUIVALENCE = new Equivalence(){

        public boolean equals(Object a, Object b) {
            return CharSequence.compare((CharSequence)a, (CharSequence)b) == 0;
        }

        public int hashCode(Object o) {
            assert (o instanceof String || o instanceof Utf8.WrappedAsciiCString);
            return o.hashCode();
        }
    };
    private static final JNIAccessibleClass NEGATIVE_CLASS_LOOKUP = new JNIAccessibleClass();
    private final EconomicMap<CharSequence, JNIAccessibleClass> classesByName = ImageHeapMap.createNonLayeredMap(WRAPPED_CSTRING_EQUIVALENCE);
    private final EconomicMap<Class<?>, JNIAccessibleClass> classesByClassObject = ImageHeapMap.createNonLayeredMap();
    private final EconomicMap<JNINativeLinkage, JNINativeLinkage> nativeLinkages = ImageHeapMap.createNonLayeredMap();

    public static void create() {
        ImageSingletons.add(JNIReflectionDictionary.class, (Object)new JNIReflectionDictionary());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JNIReflectionDictionary currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(JNIReflectionDictionary.class, false, true);
    }

    private static JNIReflectionDictionary[] layeredSingletons() {
        return (JNIReflectionDictionary[])MultiLayeredImageSingleton.getAllLayers(JNIReflectionDictionary.class);
    }

    private JNIReflectionDictionary() {
    }

    private static void dump(boolean condition, String label) {
        if (SubstrateOptions.JNIVerboseLookupErrors.getValue().booleanValue() && condition) {
            int layerNum = 0;
            for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
                PrintStream ps = Log.logStream();
                ps.println("Layer " + layerNum);
                ps.println(label);
                ps.println(" classesByName:");
                MapCursor nameCursor = dictionary.classesByName.getEntries();
                while (nameCursor.advance()) {
                    ps.print("  ");
                    ps.println(nameCursor.getKey());
                    JNIAccessibleClass clazz = (JNIAccessibleClass)nameCursor.getValue();
                    ps.println("   methods:");
                    MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methodsCursor = clazz.getMethods();
                    while (methodsCursor.advance()) {
                        ps.print("      ");
                        ps.print(((JNIAccessibleMethodDescriptor)methodsCursor.getKey()).getName());
                        ps.println(((JNIAccessibleMethodDescriptor)methodsCursor.getKey()).getSignature());
                    }
                    ps.println("   fields:");
                    UnmodifiableMapCursor<CharSequence, JNIAccessibleField> fieldsCursor = clazz.getFields();
                    while (fieldsCursor.advance()) {
                        ps.print("      ");
                        ps.println(fieldsCursor.getKey());
                    }
                }
                ps.println(" classesByClassObject:");
                MapCursor cursor = dictionary.classesByClassObject.getEntries();
                while (cursor.advance()) {
                    ps.print("  ");
                    ps.println(cursor.getKey());
                }
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleClass addClassIfAbsent(Class<?> classObj, Function<Class<?>, JNIAccessibleClass> mappingFunction) {
        if (!this.classesByClassObject.containsKey(classObj)) {
            JNIAccessibleClass instance = mappingFunction.apply(classObj);
            this.classesByClassObject.put(classObj, (Object)instance);
            String name = instance.getJNIName();
            this.classesByName.put((Object)name, (Object)instance);
        }
        return (JNIAccessibleClass)this.classesByClassObject.get(classObj);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addNegativeClassLookupIfAbsent(String typeName) {
        this.classesByName.putIfAbsent((Object)typeName, (Object)NEGATIVE_CLASS_LOOKUP);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addLinkages(Map<JNINativeLinkage, JNINativeLinkage> linkages) {
        this.nativeLinkages.putAll(EconomicMap.wrapMap(linkages));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Iterable<JNIAccessibleClass> getClasses() {
        return this.classesByClassObject.getValues();
    }

    public static Class<?> getClassObjectByName(CharSequence name) {
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            JNIAccessibleClass clazz = (JNIAccessibleClass)dictionary.classesByName.get((Object)name);
            if (clazz == null && !ClassNameSupport.isValidJNIName((String)name.toString())) {
                clazz = NEGATIVE_CLASS_LOOKUP;
            } else if (MetadataTracer.enabled()) {
                MetadataTracer.singleton().traceJNIType(ClassNameSupport.jniNameToTypeName((String)name.toString()));
            }
            clazz = JNIReflectionDictionary.checkClass(clazz, name.toString());
            if (clazz == null) continue;
            return clazz.getClassObject();
        }
        JNIReflectionDictionary.dump(true, "getClassObjectByName");
        return null;
    }

    private static JNIAccessibleClass checkClass(JNIAccessibleClass clazz, String name) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && clazz == null) {
            MissingJNIRegistrationUtils.reportClassAccess(name);
        } else if (clazz != null && clazz.isNegative()) {
            return null;
        }
        return clazz;
    }

    public static JNINativeLinkage getLinkage(CharSequence declaringClass, CharSequence name, CharSequence descriptor) {
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            JNINativeLinkage linkage = (JNINativeLinkage)dictionary.nativeLinkages.get((Object)key);
            if (linkage == null) continue;
            return linkage;
        }
        return null;
    }

    public static void unsetEntryPoints(String declaringClass) {
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            for (JNINativeLinkage linkage : dictionary.nativeLinkages.getKeys()) {
                if (!declaringClass.equals(linkage.getDeclaringClassName())) continue;
                linkage.unsetEntryPoint();
            }
        }
    }

    private static JNIAccessibleMethod findMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        JNIAccessibleMethod method = JNIReflectionDictionary.getDeclaredMethod(clazz, descriptor, dumpLabel);
        if (descriptor.isConstructor() || descriptor.isClassInitializer()) {
            return method;
        }
        if (method == null && clazz.getSuperclass() != null) {
            method = JNIReflectionDictionary.findMethod(clazz.getSuperclass(), descriptor, null);
        }
        if (method == null) {
            method = JNIReflectionDictionary.findSuperinterfaceMethod(clazz, descriptor);
        }
        return method;
    }

    private static JNIAccessibleMethod findSuperinterfaceMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleMethod method = JNIReflectionDictionary.getDeclaredMethod(parent, descriptor, null);
            if (method == null) {
                method = JNIReflectionDictionary.findSuperinterfaceMethod(parent, descriptor);
            }
            if (method == null || !method.isPublic() || method.isStatic()) continue;
            return method;
        }
        return null;
    }

    public static JNIMethodId getDeclaredMethodID(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, boolean isStatic) {
        JNIAccessibleMethod method = JNIReflectionDictionary.getDeclaredMethod(classObject, descriptor, "getDeclaredMethodID");
        boolean match = method != null && method.isStatic() == isStatic;
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private static JNIAccessibleMethod getDeclaredMethod(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceJNIType(classObject);
            MetadataTracer.singleton().traceMethodAccess(classObject, descriptor.getNameConvertToString(), descriptor.getSignatureConvertToString(), ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
        }
        boolean foundClass = false;
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            JNIAccessibleClass clazz = (JNIAccessibleClass)dictionary.classesByClassObject.get(classObject);
            if (clazz == null) continue;
            foundClass = true;
            JNIAccessibleMethod method = clazz.getMethod(descriptor);
            if (method == null) continue;
            return method;
        }
        JNIReflectionDictionary.dump(!foundClass && dumpLabel != null, dumpLabel);
        return null;
    }

    public static JNIMethodId getMethodID(Class<?> classObject, CharSequence name, CharSequence signature, boolean isStatic) {
        JNIAccessibleMethod method = JNIReflectionDictionary.findMethod(classObject, new JNIAccessibleMethodDescriptor(name, signature), "getMethodID");
        boolean match = (method = JNIReflectionDictionary.checkMethod(method, classObject, name, signature)) != null && method.isStatic() == isStatic && method.isDiscoverableIn(classObject);
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private static JNIMethodId toMethodID(JNIAccessibleMethod method) {
        if (method == null) {
            return (JNIMethodId)Word.zero();
        }
        assert (Heap.getHeap().isInImageHeap(method));
        return (JNIMethodId)Word.objectToUntrackedPointer((Object)method).subtract((UnsignedWord)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JNIAccessibleMethod getMethodByID(JNIMethodId method) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue() && method == Word.zero()) {
            return null;
        }
        Pointer p = KnownIntrinsics.heapBase().add((UnsignedWord)((Pointer)method));
        JNIAccessibleMethod jniMethod = (JNIAccessibleMethod)p.toObject(JNIAccessibleMethod.class, false);
        VMError.guarantee(jniMethod == null || !jniMethod.isNegative(), "Existing methods can't correspond to a negative query");
        return jniMethod;
    }

    private static JNIAccessibleMethod checkMethod(JNIAccessibleMethod method, Class<?> clazz, CharSequence name, CharSequence signature) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && method == null && SignatureUtil.isSignatureValid((String)signature.toString(), (boolean)false)) {
            MissingJNIRegistrationUtils.reportMethodAccess(clazz, name.toString(), signature.toString());
        } else if (method != null && method.isNegative()) {
            return null;
        }
        return method;
    }

    private static JNIAccessibleField getDeclaredField(Class<?> classObject, CharSequence name, boolean isStatic, String dumpLabel) {
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceJNIType(classObject);
            MetadataTracer.singleton().traceFieldAccess(classObject, name.toString(), ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
        }
        boolean foundClass = false;
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            JNIAccessibleClass clazz = (JNIAccessibleClass)dictionary.classesByClassObject.get(classObject);
            if (clazz == null) continue;
            foundClass = true;
            JNIAccessibleField field = clazz.getField(name);
            if (field == null || field.isStatic() != isStatic && !field.isNegative()) continue;
            return field;
        }
        JNIReflectionDictionary.dump(!foundClass && dumpLabel != null, dumpLabel);
        return null;
    }

    public static JNIFieldId getDeclaredFieldID(Class<?> classObject, String name, boolean isStatic) {
        JNIAccessibleField field = JNIReflectionDictionary.getDeclaredField(classObject, name, isStatic, "getDeclaredFieldID");
        return (field = JNIReflectionDictionary.checkField(field, classObject, name)) != null ? field.getId() : (JNIFieldId)Word.nullPointer();
    }

    private static JNIAccessibleField findField(Class<?> clazz, CharSequence name, boolean isStatic, String dumpLabel) {
        JNIAccessibleField field = JNIReflectionDictionary.getDeclaredField(clazz, name, isStatic, dumpLabel);
        if (field == null && isStatic) {
            field = JNIReflectionDictionary.findSuperinterfaceField(clazz, name);
        }
        if (field == null && clazz.getSuperclass() != null) {
            field = JNIReflectionDictionary.findField(clazz.getSuperclass(), name, isStatic, null);
        }
        return field;
    }

    private static JNIAccessibleField findSuperinterfaceField(Class<?> clazz, CharSequence name) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleField field = JNIReflectionDictionary.getDeclaredField(parent, name, true, null);
            if (field == null) {
                field = JNIReflectionDictionary.findSuperinterfaceField(parent, name);
            }
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static JNIFieldId getFieldID(Class<?> clazz, CharSequence name, boolean isStatic) {
        JNIAccessibleField field = JNIReflectionDictionary.findField(clazz, name, isStatic, "getFieldID");
        return (field = JNIReflectionDictionary.checkField(field, clazz, name)) != null && field.isDiscoverableIn(clazz) ? field.getId() : (JNIFieldId)Word.nullPointer();
    }

    public static String getFieldNameByID(Class<?> classObject, JNIFieldId id) {
        for (JNIReflectionDictionary dictionary : JNIReflectionDictionary.layeredSingletons()) {
            JNIAccessibleClass clazz = (JNIAccessibleClass)dictionary.classesByClassObject.get(classObject);
            if (clazz == null) continue;
            UnmodifiableMapCursor<CharSequence, JNIAccessibleField> fieldsCursor = clazz.getFields();
            while (fieldsCursor.advance()) {
                JNIAccessibleField field = (JNIAccessibleField)fieldsCursor.getValue();
                if (!id.equal((ComparableWord)field.getId())) continue;
                VMError.guarantee(!field.isNegative(), "Existing fields can't correspond to a negative query");
                return (String)fieldsCursor.getKey();
            }
        }
        return null;
    }

    private static JNIAccessibleField checkField(JNIAccessibleField field, Class<?> clazz, CharSequence name) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && field == null) {
            MissingJNIRegistrationUtils.reportFieldAccess(clazz, name.toString());
        } else if (field != null && field.isNegative()) {
            return null;
        }
        return field;
    }

    public static JNIAccessibleMethodDescriptor getMethodDescriptor(JNIAccessibleMethod method) {
        if (method != null) {
            JNIAccessibleClass clazz = method.getDeclaringClass();
            MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> cursor = clazz.getMethods();
            while (cursor.advance()) {
                if (cursor.getValue() != method) continue;
                return (JNIAccessibleMethodDescriptor)cursor.getKey();
            }
        }
        return null;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

