/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleMember;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class JNIAccessibleField
extends JNIAccessibleMember {
    private static final UnsignedWord ID_STATIC_FLAG = Word.unsigned((long)-1L).unsignedShiftRight(1).add(1);
    private static final UnsignedWord ID_OBJECT_FLAG = ID_STATIC_FLAG.unsignedShiftRight(1);
    private static final UnsignedWord ID_NEGATIVE_FLAG = ID_OBJECT_FLAG.unsignedShiftRight(1);
    private static final UnsignedWord ID_LAYER_NUMBER_MASK = ID_NEGATIVE_FLAG.unsignedShiftRight(1);
    private static final int ID_LAYER_NUMBER_SHIFT = 60;
    private static final UnsignedWord ID_OFFSET_MASK = ID_LAYER_NUMBER_MASK.subtract(1);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final UnsignedWord flags;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private UnsignedWord id = (UnsignedWord)Word.zero();

    public static JNIAccessibleField negativeFieldQuery(JNIAccessibleClass jniClass) {
        return new JNIAccessibleField(jniClass, null, 0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static WordBase getOffsetFromId(JNIFieldId id) {
        UnsignedWord result = ((UnsignedWord)id).and(ID_OFFSET_MASK);
        assert (result.notEqual(0));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getStaticObjectFieldsAtRuntime(JNIFieldId fieldId) {
        int layerNumber = JNIAccessibleField.getLayerNumberFromId((UnsignedWord)fieldId);
        return StaticFieldsSupport.getStaticObjectFieldsAtRuntime(layerNumber);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Object getStaticPrimitiveFieldsAtRuntime(JNIFieldId fieldId) {
        int layerNumber = JNIAccessibleField.getLayerNumberFromId((UnsignedWord)fieldId);
        return StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(layerNumber);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getLayerNumberFromId(UnsignedWord id) {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            return (int)id.and(ID_LAYER_NUMBER_MASK).unsignedShiftRight(60).rawValue();
        }
        return -1;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleField(JNIAccessibleClass declaringClass, JavaKind kind, int modifiers) {
        super(declaringClass);
        UnsignedWord bits;
        UnsignedWord unsignedWord = bits = Modifier.isStatic(modifiers) ? ID_STATIC_FLAG : (UnsignedWord)Word.zero();
        if (kind == null) {
            bits = bits.or(ID_NEGATIVE_FLAG);
        } else if (kind.isObject()) {
            bits = bits.or(ID_OBJECT_FLAG);
        }
        this.flags = bits;
    }

    public JNIFieldId getId() {
        return (JNIFieldId)this.id;
    }

    public boolean isStatic() {
        assert (!this.id.equal(0));
        return this.id.and(ID_STATIC_FLAG).notEqual(0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isNegativeHosted() {
        return this.flags.and(ID_NEGATIVE_FLAG).notEqual(0);
    }

    public boolean isNegative() {
        assert (!this.id.equal(0));
        return this.id.and(ID_NEGATIVE_FLAG).notEqual(0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void finishBeforeCompilation(int offset, int layerNumber, EconomicSet<Class<?>> hidingSubclasses) {
        assert (this.id.equal(0));
        assert (this.isNegativeHosted() || ID_OFFSET_MASK.and(offset).equal(offset)) : "Offset is too large to be encoded in the JNIAccessibleField ID";
        UnsignedWord unsignedWord = this.id = this.isNegativeHosted() ? this.flags : this.flags.or(offset);
        if (layerNumber == 1 || layerNumber == 0) {
            this.id = this.id.or(Word.unsigned((int)layerNumber).shiftLeft(60));
            VMError.guarantee(JNIAccessibleField.getLayerNumberFromId(this.id) == layerNumber);
        } else assert (layerNumber == -1);
        this.setHidingSubclasses(hidingSubclasses);
    }
}

