/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.oldobject;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.locks.VMMutex;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.Pointer;

public final class JfrOldObjectRepository
implements JfrRepository {
    private static final int OBJECT_DESCRIPTION_MAX_LENGTH = 100;
    private final VMMutex mutex = new VMMutex("jfrOldObjectRepository");
    private final JfrOldObjectEpochData epochData0 = new JfrOldObjectEpochData();
    private final JfrOldObjectEpochData epochData1 = new JfrOldObjectEpochData();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrOldObjectRepository() {
    }

    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition and result is only valid until epoch changes.", callerMustBe=true)
    public long serializeOldObject(Object obj) {
        this.mutex.lockNoTransition();
        try {
            JfrOldObjectEpochData epochData = this.getEpochData(false);
            if (epochData.buffer.isNull()) {
                epochData.buffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
            }
            long id = JfrOldObjectEpochData.nextId++;
            Word pointer = Word.objectToUntrackedPointer((Object)obj);
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, epochData.buffer);
            JfrNativeEventWriter.putLong(data, id);
            JfrNativeEventWriter.putLong(data, pointer.rawValue());
            JfrNativeEventWriter.putLong(data, SubstrateJVM.getTypeRepository().getClassId(obj.getClass()));
            JfrOldObjectRepository.writeDescription(obj, data);
            JfrNativeEventWriter.putLong(data, 0L);
            if (!JfrNativeEventWriter.commit(data)) {
                long l = 0L;
                return l;
            }
            ++epochData.unflushedEntries;
            epochData.buffer = data.getJfrBuffer();
            long l = id;
            return l;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void writeDescription(Object obj, JfrNativeEventWriterData data) {
        if (obj instanceof ThreadGroup) {
            ThreadGroup group = (ThreadGroup)obj;
            JfrOldObjectRepository.writeDescription(data, "Thread Group: ", group.getName());
        } else if (obj instanceof Thread) {
            Thread thread = (Thread)obj;
            JfrOldObjectRepository.writeDescription(data, "Thread Name: ", thread.getName());
        } else if (obj instanceof Class) {
            Class clazz = (Class)obj;
            JfrOldObjectRepository.writeDescription(data, "Class Name: ", clazz.getName());
        } else {
            JfrNativeEventWriter.putString(data, null);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void writeDescription(JfrNativeEventWriterData data, String prefix, String text) {
        if (text == null || text.isEmpty()) {
            JfrNativeEventWriter.putString(data, text);
            return;
        }
        Pointer buffer = (Pointer)UnsafeStackValue.get(100);
        Pointer bufferEnd = buffer.add(100);
        int prefixLength = UninterruptibleUtils.String.modifiedUTF8Length(prefix, false);
        int textLength = UninterruptibleUtils.String.modifiedUTF8Length(text, false);
        assert (prefixLength < 97);
        boolean tooLong = false;
        int totalLength = prefixLength + textLength;
        if (totalLength > 100) {
            totalLength = 100;
            textLength = 100 - prefixLength - 3;
            tooLong = true;
        }
        Pointer pos = UninterruptibleUtils.String.toModifiedUTF8(prefix, buffer, bufferEnd, false);
        pos = UninterruptibleUtils.String.toModifiedUTF8(text, textLength, pos, bufferEnd, false, null);
        if (tooLong) {
            pos.writeByte(0, (byte)46);
            pos.writeByte(1, (byte)46);
            pos.writeByte(2, (byte)46);
        }
        JfrNativeEventWriter.putString(data, buffer, totalLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        this.mutex.lockNoTransition();
        try {
            JfrOldObjectEpochData epochData = this.getEpochData(!flushpoint);
            int count = epochData.unflushedEntries;
            if (count != 0) {
                writer.writeCompressedLong(JfrType.OldObject.getId());
                writer.writeCompressedInt(count);
                writer.write(epochData.buffer);
            }
            epochData.clear(flushpoint);
            int n = count == 0 ? 0 : 1;
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Result is only valid until epoch changes.", callerMustBe=true)
    private JfrOldObjectEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    private static class JfrOldObjectEpochData {
        private static long nextId = 1L;
        private int unflushedEntries = 0;
        private JfrBuffer buffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrOldObjectEpochData() {
        }

        @Uninterruptible(reason="May write current epoch data.")
        void clear(boolean flushpoint) {
            this.unflushedEntries = 0;
            JfrBufferAccess.reinitialize(this.buffer);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        void teardown() {
            this.unflushedEntries = 0;
            JfrBufferAccess.free(this.buffer);
            this.buffer = (JfrBuffer)Word.nullPointer();
        }
    }
}

