/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.oldobject;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.collections.UninterruptibleComparable;
import com.oracle.svm.core.collections.UninterruptibleLinkedList;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.jfr.JfrTicks;
import java.lang.ref.WeakReference;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.UnsignedWord;

public final class JfrOldObject
implements UninterruptibleComparable,
UninterruptibleLinkedList.Element {
    private final WeakReference<?> reference = new WeakReference<Object>(null);
    private JfrOldObject next;
    private UnsignedWord span;
    private UnsignedWord objectSize;
    private long allocationTicks;
    private long threadId;
    private long stackTraceId;
    private UnsignedWord heapUsedAfterLastGC;
    private int arrayLength;

    JfrOldObject() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void initialize(Object obj, UnsignedWord span, UnsignedWord allocatedSize, long threadId, long stackTraceId, UnsignedWord heapUsedAfterLastGC, int arrayLength) {
        ReferenceInternals.setReferent(this.reference, obj);
        this.span = span;
        this.objectSize = allocatedSize;
        this.allocationTicks = JfrTicks.elapsedTicks();
        this.threadId = threadId;
        this.stackTraceId = stackTraceId;
        this.heapUsedAfterLastGC = heapUsedAfterLastGC;
        this.arrayLength = arrayLength;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void reset() {
        ReferenceInternals.setReferent(this.reference, null);
        this.span = (UnsignedWord)Word.zero();
        this.objectSize = (UnsignedWord)Word.zero();
        this.allocationTicks = 0L;
        this.threadId = 0L;
        this.stackTraceId = 0L;
        this.heapUsedAfterLastGC = (UnsignedWord)Word.zero();
        this.arrayLength = 0;
        this.next = null;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleLinkedList.Element getNext() {
        return this.next;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setNext(UninterruptibleLinkedList.Element next) {
        this.next = (JfrOldObject)next;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getSpan() {
        return this.span;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void increaseSpan(UnsignedWord value) {
        this.span = this.span.add(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getObjectSize() {
        return this.objectSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getAllocationTicks() {
        return this.allocationTicks;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadId() {
        return this.threadId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getStackTraceId() {
        return this.stackTraceId;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getHeapUsedAfterLastGC() {
        return this.heapUsedAfterLastGC;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getArrayLength() {
        return this.arrayLength;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int compareTo(UninterruptibleComparable other) {
        UnsignedWord otherSpan = ((JfrOldObject)other).span;
        if (this.span.aboveThan(otherSpan)) {
            return 1;
        }
        if (this.span.belowThan(otherSpan)) {
            return -1;
        }
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object getReferent() {
        return ReferenceInternals.getReferent(this.reference);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAlive() {
        return ReferenceInternals.isReferentAlive(this.reference);
    }
}

