/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.runtimeinit;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SecurityProvidersInitializedAtRunTime;
import com.oracle.svm.core.jdk.SecurityProvidersSupport;
import java.security.Provider;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import sun.security.util.Debug;

@TargetClass(className="sun.security.jca.ProviderConfig", onlyWith={SecurityProvidersInitializedAtRunTime.class})
final class Target_sun_security_jca_ProviderConfig {
    @Alias
    private String provName;
    @Alias
    private static Debug debug;
    @Alias
    private Provider provider;
    @Alias
    private boolean isLoading;
    @Alias
    private int tries;

    Target_sun_security_jca_ProviderConfig() {
    }

    @Alias
    private native Provider doLoadProvider();

    @Alias
    private native boolean shouldLoad();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="This double-check is implemented correctly and is intentional.")
    Provider getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        Target_sun_security_jca_ProviderConfig target_sun_security_jca_ProviderConfig = this;
        synchronized (target_sun_security_jca_ProviderConfig) {
            if (this.provider != null) {
                return this.provider;
            }
            if (!this.shouldLoad()) {
                return null;
            }
            if (SecurityProvidersSupport.isBuiltInProvider(this.provName)) {
                this.provider = SecurityProvidersSupport.singleton().loadBuiltInProvider(this.provName, debug);
            } else {
                if (this.isLoading) {
                    if (debug != null) {
                        debug.println("Recursion loading provider: " + String.valueOf(this));
                        new Exception("Call trace").printStackTrace();
                    }
                    return null;
                }
                try {
                    this.isLoading = true;
                    ++this.tries;
                    this.provider = this.doLoadProvider();
                }
                finally {
                    this.isLoading = false;
                }
            }
        }
        return this.provider;
    }
}

