/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;

public final class ResourceURLConnection
extends URLConnection {
    private static final String CONTENT_LENGTH = "content-length";
    private static final String CONTENT_TYPE = "content-type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String LAST_MODIFIED = "last-modified";
    private byte[] data;
    private boolean isDirectory = false;
    private boolean initializedHeaders = false;

    public ResourceURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() {
        String resourceName;
        if (this.connected) {
            return;
        }
        this.connected = true;
        String urlHost = this.url.getHost();
        String hostNameOrNull = urlHost != null && !urlHost.isEmpty() ? urlHost : null;
        String urlPath = this.url.getPath();
        if (urlPath.isEmpty()) {
            throw new IllegalArgumentException("Empty URL path not allowed in resource URL");
        }
        Module module = hostNameOrNull != null ? (Module)ModuleLayer.boot().findModule(hostNameOrNull).orElse(null) : null;
        ResourceStorageEntryBase entry = Resources.getAtRuntime(module, resourceName = urlPath.substring(1), false);
        if (entry != null) {
            ResourceStorageEntry resourceStorageEntry = (ResourceStorageEntry)entry;
            List<byte[]> bytes = resourceStorageEntry.getData();
            this.isDirectory = resourceStorageEntry.isDirectory();
            String urlRef = this.url.getRef();
            int index = 0;
            if (urlRef != null) {
                try {
                    index = Integer.parseInt(urlRef);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("URL anchor '#" + urlRef + "' not allowed in resource URL");
                }
            }
            this.data = index < bytes.size() ? bytes.get(index) : bytes.get(0);
        } else {
            this.data = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.data == null) {
            throw new FileNotFoundException(this.url.toString());
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getContentLengthLong() {
        this.initializeHeaders();
        return super.getContentLengthLong();
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return super.getLastModified();
    }

    @Override
    public String getHeaderField(String name) {
        this.initializeHeaders();
        return super.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.initializeHeaders();
        return super.getHeaderFields();
    }

    @Override
    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        return super.getContentLength();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    private void initializeHeaders() {
        this.connect();
        if (!this.initializedHeaders) {
            if (!this.isDirectory) {
                String contentType = ResourceURLConnection.guessContentTypeFromName(this.url.getPath());
                if (contentType != null) {
                    this.properties.add(CONTENT_TYPE, contentType);
                }
                if (this.data != null) {
                    this.properties.add(CONTENT_LENGTH, String.valueOf(this.data.length));
                }
                long lastModified = Resources.getLastModifiedTime();
                Date date = new Date(lastModified);
                SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.properties.add(LAST_MODIFIED, fo.format(date));
            } else {
                this.properties.add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }
}

