/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.management.JmxServerIncluded;
import com.oracle.svm.core.jdk.management.ManagementAgentModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@TargetClass(className="jdk.internal.agent.Agent", onlyWith={ManagementAgentModule.IsPresent.class})
public final class Target_jdk_internal_agent_Agent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @TargetElement(onlyWith={JmxServerIncluded.class})
    public static void readConfiguration(String fname, Properties p) {
        if (fname == null) {
            return;
        }
        File configFile = new File(fname);
        if (!configFile.exists()) {
            ManagementAgentModule.agentError(ManagementAgentModule.CONFIG_FILE_NOT_FOUND, fname);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            p.load(in);
        }
        catch (FileNotFoundException e) {
            ManagementAgentModule.agentError(ManagementAgentModule.CONFIG_FILE_OPEN_FAILED, e.getMessage());
        }
        catch (IOException e) {
            ManagementAgentModule.agentError(ManagementAgentModule.CONFIG_FILE_OPEN_FAILED, e.getMessage());
        }
        catch (SecurityException e) {
            ManagementAgentModule.agentError(ManagementAgentModule.CONFIG_FILE_ACCESS_DENIED, fname);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    ManagementAgentModule.agentError(ManagementAgentModule.CONFIG_FILE_CLOSE_FAILED, fname);
                }
            }
        }
    }
}

