/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class ManagementAgentModule {
    private static final Method agentStartAgent;
    private static final Method agentError;
    static final String CONFIG_FILE_ACCESS_DENIED;
    static final String CONFIG_FILE_CLOSE_FAILED;
    static final String CONFIG_FILE_NOT_FOUND;
    static final String CONFIG_FILE_OPEN_FAILED;

    public static boolean isPresent() {
        return agentStartAgent != null;
    }

    static void agentError(String key, String message) {
        try {
            agentError.invoke(null, key, message);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Unable to reflectively invoke jdk.internal.agent.Agent.error(String, String)", e);
        }
    }

    static void agentStartAgent() {
        try {
            agentStartAgent.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Unable to reflectively invoke jdk.internal.agent.Agent.startAgent()", e);
        }
    }

    static {
        Optional<Module> agentModule = ModuleLayer.boot().findModule("jdk.management.agent");
        if (agentModule.isPresent()) {
            ManagementAgentModule.class.getModule().addReads(agentModule.get());
            Class agentClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.agent.Agent");
            agentStartAgent = ReflectionUtil.lookupMethod((Class)agentClass, (String)"startAgent", (Class[])new Class[0]);
            agentError = ReflectionUtil.lookupMethod((Class)agentClass, (String)"error", (Class[])new Class[]{String.class, String.class});
            Class agentConfigurationErrorClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.agent.AgentConfigurationError");
            CONFIG_FILE_ACCESS_DENIED = (String)ReflectionUtil.readStaticField((Class)agentConfigurationErrorClass, (String)"CONFIG_FILE_ACCESS_DENIED");
            CONFIG_FILE_CLOSE_FAILED = (String)ReflectionUtil.readStaticField((Class)agentConfigurationErrorClass, (String)"CONFIG_FILE_CLOSE_FAILED");
            CONFIG_FILE_NOT_FOUND = (String)ReflectionUtil.readStaticField((Class)agentConfigurationErrorClass, (String)"CONFIG_FILE_NOT_FOUND");
            CONFIG_FILE_OPEN_FAILED = (String)ReflectionUtil.readStaticField((Class)agentConfigurationErrorClass, (String)"CONFIG_FILE_OPEN_FAILED");
        } else {
            agentStartAgent = null;
            agentError = null;
            CONFIG_FILE_ACCESS_DENIED = null;
            CONFIG_FILE_CLOSE_FAILED = null;
            CONFIG_FILE_NOT_FOUND = null;
            CONFIG_FILE_OPEN_FAILED = null;
        }
    }

    static class IsPresent
    implements BooleanSupplier {
        IsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return ManagementAgentModule.isPresent();
        }
    }
}

