/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.LibCHelper;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.TimeZoneSupport;
import java.util.TimeZone;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;

@TargetClass(value=TimeZone.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_util_TimeZone {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static TimeZone defaultTimeZone;

    Target_java_util_TimeZone() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private static String getSystemTimeZoneID(String javaHome) {
        CCharPointer tzMappingsPtr = (CCharPointer)Word.nullPointer();
        int contentLen = 0;
        try (PrimitiveArrayView refContent = null;){
            if (ImageSingletons.contains(TimeZoneSupport.class)) {
                byte[] content = ((TimeZoneSupport)ImageSingletons.lookup(TimeZoneSupport.class)).getTzMappingsContent();
                contentLen = content.length;
                refContent = PrimitiveArrayView.createForReading(content);
                tzMappingsPtr = (CCharPointer)refContent.addressOfArrayElement(0);
            }
            CCharPointer tzId = LibCHelper.SVM_FindJavaTZmd(tzMappingsPtr, contentLen);
            String result = CTypeConversion.toJavaString((CCharPointer)tzId);
            LibC.free((PointerBase)tzId);
            String string = result;
            return string;
        }
    }
}

