/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SystemInOutErrSupport
implements InitialLayerOnlyImageSingleton {
    private final InputStream initialIn;
    private InputStream in;
    private PrintStream out;
    private final PrintStream initialErr;
    private PrintStream err;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    final AtomicBoolean isSealed;

    public SystemInOutErrSupport() {
        this.in = this.initialIn = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
        this.out = SystemInOutErrSupport.newPrintStream(new FileOutputStream(FileDescriptor.out), System.getProperty("sun.stdout.encoding"));
        this.err = this.initialErr = SystemInOutErrSupport.newPrintStream(new FileOutputStream(FileDescriptor.err), System.getProperty("sun.stderr.encoding"));
        this.isSealed = new AtomicBoolean(false);
    }

    private static PrintStream newPrintStream(FileOutputStream fos, String enc) {
        if (enc != null) {
            try {
                return new PrintStream((OutputStream)new BufferedOutputStream(fos, 128), true, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new PrintStream(new BufferedOutputStream(fos, 128), true);
    }

    public void seal() {
        if (!this.isSealed.getPlain()) {
            this.isSealed.set(true);
        }
    }

    public void checkSealed() {
        VMError.guarantee(!this.isSealed.get(), "SystemInOurErrorSupport is already sealed");
    }

    private static SystemInOutErrSupport singleton() {
        return (SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class);
    }

    @Fold
    public InputStream in() {
        this.seal();
        return this.in;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setIn(InputStream in) {
        SystemInOutErrSupport support = SystemInOutErrSupport.singleton();
        support.checkSealed();
        support.in = Objects.requireNonNull(in);
    }

    @Fold
    public PrintStream out() {
        this.seal();
        return this.out;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setOut(PrintStream out) {
        SystemInOutErrSupport support = SystemInOutErrSupport.singleton();
        support.checkSealed();
        support.out = Objects.requireNonNull(out);
    }

    @Fold
    public PrintStream err() {
        this.seal();
        return this.err;
    }

    @Fold
    public InputStream initialIn() {
        this.seal();
        return this.initialIn;
    }

    @Fold
    public PrintStream initialErr() {
        this.seal();
        return this.initialErr;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setErr(PrintStream err) {
        SystemInOutErrSupport support = SystemInOutErrSupport.singleton();
        support.checkSealed();
        support.err = Objects.requireNonNull(err);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

